// ----------------------------------------
//
//  CrashSightCallbackDelegate.cs
//
//  Author:
//       Yeelik,
//
//  Copyright (c) 2015 CrashSight.  All rights reserved.
//
// ----------------------------------------
//
using UnityEngine;

public abstract class CrashSightCallback
{
	private static volatile bool isQuitting = false;
	private static object quitLocker = new object();

	static CrashSightCallback()
	{
		// 注册应用退出事件监听器
		Application.quitting += OnApplicationQuitting;
	}

	/// <summary>
	/// 应用退出时的回调
	/// </summary>
	private static void OnApplicationQuitting()
	{
		lock (quitLocker)
		{
			isQuitting = true;
		}
	}

	/// <summary>
	/// 检查应用是否正在退出
	/// </summary>
	public static bool IsQuitting()
	{
		lock (quitLocker)
		{
			return isQuitting;
		}
	}

	public abstract string OnCrashBaseRetEvent(int methodId, int crashType);

}

public abstract class CrashSightLogCallback
{
	private static volatile bool isQuitting = false;
	private static object quitLocker = new object();

	static CrashSightLogCallback()
	{
		// 注册应用退出事件监听器
		Application.quitting += OnApplicationQuitting;
	}

	/// <summary>
	/// 应用退出时的回调
	/// </summary>
	private static void OnApplicationQuitting()
	{
		lock (quitLocker)
		{
			isQuitting = true;
		}
	}

	/// <summary>
	/// 检查应用是否正在退出
	/// </summary>
	public static bool IsQuitting()
	{
		lock (quitLocker)
		{
			return isQuitting;
		}
	}

	public abstract string OnSetLogPathEvent(int methodId, int crashType);

	public abstract void OnLogUploadResultEvent(int methodId, int crashType, int result);

}

