/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.core.tools.json;

import com.uqm.crashsight.core.tools.UQMLog;
import com.uqm.crashsight.core.tools.json.JsonBoolean;
import com.uqm.crashsight.core.tools.json.JsonDouble;
import com.uqm.crashsight.core.tools.json.JsonFloat;
import com.uqm.crashsight.core.tools.json.JsonInt;
import com.uqm.crashsight.core.tools.json.JsonList;
import com.uqm.crashsight.core.tools.json.JsonLong;
import com.uqm.crashsight.core.tools.json.JsonProp;
import com.uqm.crashsight.core.tools.json.JsonShort;
import com.uqm.crashsight.core.tools.json.JsonString;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonSerializable {
    public JSONObject rawObject = null;
    private static volatile ConcurrentHashMap<Class, ArrayList<Field>> mFields = new ConcurrentHashMap();

    public JsonSerializable() {
    }

    /*
     * WARNING - void declaration
     */
    public JsonSerializable(JSONObject json) throws JSONException {
        void var1_1;
        if (json == null) {
            json = new JSONObject();
        }
        this.fillWithJSON((JSONObject)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JsonSerializable(String json) throws JSONException {
        void var1_1;
        if (json == null) {
            json = "";
        }
        this.fillWithJSON(new JSONObject((String)var1_1));
    }

    private ArrayList<Field> getFields(Object obj) {
        Class<?> clazz = obj.getClass();
        return this.getFields(clazz);
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<Field> getFields(Class type) {
        void var1_1;
        if (mFields.containsKey(type)) {
            return mFields.get(type);
        }
        ArrayList<Field> arrayList = new ArrayList<Field>();
        Field[] fieldArray = type.getDeclaredFields();
        Object object = fieldArray;
        object = fieldArray;
        int n2 = fieldArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Field field = object[i2];
            if (!Modifier.isPublic(field.getModifiers()) || !field.isAnnotationPresent(JsonProp.class)) continue;
            arrayList.add(field);
        }
        object = type.getSuperclass();
        if (object != null && JsonSerializable.class.isAssignableFrom((Class<?>)object)) {
            ArrayList<Field> arrayList2 = this.getFields((Class)object);
            arrayList.addAll(0, arrayList2);
        }
        mFields.put((Class)var1_1, arrayList);
        return arrayList;
    }

    public JSONObject toUnityJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JsonSerializable jsonSerializable = this;
        Object object = jsonSerializable.getFields(jsonSerializable);
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            Object object2;
            Field field = (Field)object.next();
            try {
                object2 = field.get(this);
                if (object2 == null) continue;
                if (object2 instanceof JsonSerializable) {
                    jSONObject.put(field.getName(), (Object)((JsonSerializable)object2).toUnityJSONObject());
                    continue;
                }
                if (object2 instanceof List) {
                    JSONArray jSONArray = new JSONArray();
                    for (Object e2 : (List)object2) {
                        if (JsonSerializable.class.isAssignableFrom(e2.getClass())) {
                            jSONArray.put((Object)((JsonSerializable)e2).toUnityJSONObject());
                            continue;
                        }
                        jSONArray.put(e2);
                    }
                    jSONObject.put(field.getName(), (Object)jSONArray);
                    continue;
                }
                jSONObject.put(field.getName(), object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                object2 = illegalAccessException;
                UQMLog.e(illegalAccessException.getMessage(), new Object[0]);
            }
        }
        return jSONObject;
    }

    public String toUnityString() throws JSONException {
        return this.toUnityJSONObject().toString();
    }

    public String toJSONString() throws JSONException {
        return this.toJSONObject().toString();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JsonSerializable jsonSerializable = this;
        Object object = jsonSerializable.getFields(jsonSerializable);
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            Field field = (Field)object.next();
            JsonProp jsonProp = field.getAnnotation(JsonProp.class);
            Iterator iterator = field.getAnnotation(JsonList.class);
            if (jsonProp == null) continue;
            try {
                Object object2 = field.get(this);
                if (object2 == null) continue;
                if (iterator != null) {
                    field = new JSONArray();
                    if (!(object2 instanceof List)) continue;
                    iterator = (List)object2;
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        object2 = iterator.next();
                        if (JsonSerializable.class.isAssignableFrom(object2.getClass())) {
                            field.put(((JsonSerializable)object2).toJSONObject());
                            continue;
                        }
                        field.put(object2);
                    }
                    jSONObject.put(jsonProp.value(), (Object)field);
                    continue;
                }
                if (JsonSerializable.class.isAssignableFrom(field.getType())) {
                    if (!(object2 instanceof JsonSerializable)) continue;
                    jSONObject.put(jsonProp.value(), (Object)((JsonSerializable)object2).toJSONObject());
                    continue;
                }
                jSONObject.put(jsonProp.value(), object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                UQMLog.e("parse to json string error : " + illegalAccessException.getMessage(), new Object[0]);
            }
        }
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    private Object getDefaultValue(Field field) {
        Class<?> clazz = field.getType();
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            if (field.isAnnotationPresent(JsonInt.class)) {
                return field.getAnnotation(JsonInt.class).def();
            }
        } else if (Long.TYPE.isAssignableFrom(clazz)) {
            if (field.isAnnotationPresent(JsonLong.class)) {
                return field.getAnnotation(JsonLong.class).def();
            }
        } else if (String.class.isAssignableFrom(clazz)) {
            if (field.isAnnotationPresent(JsonString.class)) {
                return field.getAnnotation(JsonString.class).def();
            }
        } else if (Boolean.TYPE.isAssignableFrom(clazz)) {
            if (field.isAnnotationPresent(JsonBoolean.class)) {
                return field.getAnnotation(JsonBoolean.class).def();
            }
        } else if (Short.TYPE.isAssignableFrom(JsonShort.class)) {
            if (field.isAnnotationPresent(JsonShort.class)) {
                return field.getAnnotation(JsonShort.class).def();
            }
        } else if (Float.TYPE.isAssignableFrom(JsonFloat.class)) {
            if (field.isAnnotationPresent(JsonFloat.class)) {
                return Float.valueOf(field.getAnnotation(JsonFloat.class).def());
            }
        } else if (Double.TYPE.isAssignableFrom(JsonDouble.class)) {
            if (field.isAnnotationPresent(JsonDouble.class)) {
                void var1_1;
                return var1_1.getAnnotation(JsonDouble.class).def();
            }
        } else {
            return null;
        }
        return null;
    }

    private void fillWithJSON(JSONObject json) throws JSONException {
        this.rawObject = json;
        if (json.length() > 0) {
            JsonSerializable jsonSerializable = this;
            Object object = jsonSerializable.getFields(jsonSerializable);
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                Field field = (Field)object.next();
                if (!field.isAnnotationPresent(JsonProp.class)) continue;
                Object object2 = field.getAnnotation(JsonProp.class);
                JsonList jsonList = field.getAnnotation(JsonList.class);
                try {
                    object2 = json.opt(object2.value());
                    if (object2 == null && (object2 = this.getDefaultValue(field)) == null) continue;
                    if (jsonList != null && object2 instanceof JSONArray) {
                        object2 = (JSONArray)object2;
                        LinkedList<Object> linkedList = field.get(this);
                        if (field.getType() == List.class && linkedList == null) {
                            linkedList = new LinkedList<Object>();
                        }
                        linkedList = linkedList;
                        for (int i2 = 0; i2 < object2.length(); ++i2) {
                            Object object3 = object2.get(i2);
                            Class<?> clazz = Class.forName(jsonList.value());
                            if (JsonSerializable.class.isAssignableFrom(clazz)) {
                                linkedList.add(this.constructWithJSON(clazz, (JSONObject)object3));
                                continue;
                            }
                            linkedList.add(object3);
                        }
                        field.set(this, linkedList);
                        continue;
                    }
                    if (JsonSerializable.class.isAssignableFrom(field.getType())) {
                        if (!(object2 instanceof JSONObject)) continue;
                        JsonSerializable jsonSerializable2 = this;
                        field.set(jsonSerializable2, jsonSerializable2.constructWithJSON(field.getType(), (JSONObject)object2));
                        continue;
                    }
                    field.set(this, object2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    object2 = illegalAccessException;
                    UQMLog.d(illegalAccessException.getMessage(), new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    object2 = illegalArgumentException;
                    UQMLog.d(illegalArgumentException.getMessage(), new Object[0]);
                }
                catch (NullPointerException nullPointerException) {
                    object2 = nullPointerException;
                    UQMLog.d(nullPointerException.getMessage(), new Object[0]);
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    object2 = exceptionInInitializerError;
                    UQMLog.d(exceptionInInitializerError.getMessage(), new Object[0]);
                }
                catch (Exception exception) {
                    object2 = exception;
                    UQMLog.d(exception.getMessage(), new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object constructWithJSON(Class type, JSONObject object) throws JSONException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        void var2_2;
        Constructor constructor = type.getDeclaredConstructor(JSONObject.class);
        if (constructor == null) {
            return null;
        }
        return constructor.newInstance(var2_2);
    }
}

