/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;

class GzipOrRawInputStream
extends FilterInputStream {
    static final byte[] GZIP_HEADER = new byte[]{31, -117};

    GzipOrRawInputStream(InputStream inputStream2) throws IOException {
        this(inputStream2, 512);
    }

    GzipOrRawInputStream(InputStream inputStream2, int n) throws IOException {
        super(null);
        int n2;
        int n3;
        byte[] byArray = new byte[GZIP_HEADER.length];
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream2, 2);
        for (n3 = 0; n3 < byArray.length && (n2 = pushbackInputStream.read()) != -1; ++n3) {
            byArray[n3] = (byte)n2;
        }
        assert (n3 <= 2);
        pushbackInputStream.unread(byArray, 0, n3);
        this.in = n3 == 2 && Arrays.equals(byArray, GZIP_HEADER) ? new GZIPInputStream((InputStream)pushbackInputStream, n) : pushbackInputStream;
    }
}

