/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import software.amazon.ion.Decimal;
import software.amazon.ion.IonBool;
import software.amazon.ion.IonDecimal;
import software.amazon.ion.IonException;
import software.amazon.ion.IonFloat;
import software.amazon.ion.IonInt;
import software.amazon.ion.IonLob;
import software.amazon.ion.IonSequence;
import software.amazon.ion.IonStruct;
import software.amazon.ion.IonSymbol;
import software.amazon.ion.IonText;
import software.amazon.ion.IonTimestamp;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.SymbolToken;

public final class Equivalence {
    private static final boolean PUBLIC_COMPARISON_API = false;

    private Equivalence() {
    }

    private static int compareAnnotations(SymbolToken[] symbolTokenArray, SymbolToken[] symbolTokenArray2) {
        int n = symbolTokenArray.length;
        int n2 = n - symbolTokenArray2.length;
        if (n2 == 0) {
            for (int i = 0; n2 == 0 && i < n; ++i) {
                n2 = Equivalence.compareSymbolTokens(symbolTokenArray[i], symbolTokenArray2[i]);
            }
        }
        return n2;
    }

    private static int compareSymbolTokens(SymbolToken symbolToken, SymbolToken symbolToken2) {
        String string = symbolToken.getText();
        String string2 = symbolToken2.getText();
        if (string == null || string2 == null) {
            int n;
            if (string != null) {
                return 1;
            }
            if (string2 != null) {
                return -1;
            }
            int n2 = symbolToken.getSid();
            if (n2 < (n = symbolToken2.getSid())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }
        return string.compareTo(string2);
    }

    private static final Map<Field, Field> convertToMultiSet(IonStruct ionStruct, boolean bl) {
        HashMap<Field, Field> hashMap = new HashMap<Field, Field>();
        for (IonValue ionValue : ionStruct) {
            Field field = new Field(ionValue, bl);
            Field field2 = hashMap.put(field, field);
            if (field2 != null) {
                field.occurrences = field2.occurrences;
            }
            field.occurrences++;
        }
        return hashMap;
    }

    private static int compareStructs(IonStruct ionStruct, IonStruct ionStruct2, boolean bl) {
        int n = ionStruct.size() - ionStruct2.size();
        if (n == 0) {
            Map<Field, Field> map = Equivalence.convertToMultiSet(ionStruct, bl);
            for (IonValue ionValue : ionStruct2) {
                Field field = new Field(ionValue, bl);
                Field field2 = map.get(field);
                if (field2 == null || field2.occurrences == 0) {
                    return -1;
                }
                field2.occurrences--;
            }
        }
        return n;
    }

    private static int compareSequences(IonSequence ionSequence, IonSequence ionSequence2, boolean bl) {
        int n;
        block1: {
            n = ionSequence.size() - ionSequence2.size();
            if (n != 0) break block1;
            Iterator iterator2 = ionSequence.iterator();
            Iterator iterator3 = ionSequence2.iterator();
            while (iterator2.hasNext() && (n = Equivalence.ionCompareToImpl((IonValue)iterator2.next(), (IonValue)iterator3.next(), bl)) == 0) {
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int compareLobContents(IonLob ionLob, IonLob ionLob2) {
        int n;
        int n2 = ionLob.byteSize();
        int n3 = n2 - (n = ionLob2.byteSize());
        if (n3 == 0) {
            InputStream inputStream2 = ionLob.newInputStream();
            InputStream inputStream3 = ionLob2.newInputStream();
            try {
                try {
                    try {
                        while (n3 == 0) {
                            n2 = inputStream2.read();
                            n = inputStream3.read();
                            if (n2 == -1 || n == -1) {
                                if (n2 != -1) {
                                    n3 = 1;
                                }
                                if (n != -1) {
                                    n3 = -1;
                                }
                                break;
                            }
                            n3 = n2 - n;
                        }
                    }
                    finally {
                        inputStream2.close();
                    }
                }
                finally {
                    inputStream3.close();
                }
            }
            catch (IOException iOException) {
                throw new IonException(iOException);
            }
        }
        return n3;
    }

    private static boolean ionEqualsImpl(IonValue ionValue, IonValue ionValue2, boolean bl) {
        return Equivalence.ionCompareToImpl(ionValue, ionValue2, bl) == 0;
    }

    private static int ionCompareToImpl(IonValue ionValue, IonValue ionValue2, boolean bl) {
        IonType ionType;
        int n = 0;
        if (ionValue == null || ionValue2 == null) {
            if (ionValue != null) {
                n = 1;
            }
            if (ionValue2 != null) {
                n = -1;
            }
            return n;
        }
        IonType ionType2 = ionValue.getType();
        n = ionType2.compareTo(ionType = ionValue2.getType());
        if (n == 0) {
            boolean bl2 = ionValue.isNullValue();
            boolean bl3 = ionValue2.isNullValue();
            if (bl2 || bl3) {
                if (!bl2) {
                    n = 1;
                }
                if (!bl3) {
                    n = -1;
                }
            } else {
                switch (ionType2) {
                    case NULL: {
                        break;
                    }
                    case BOOL: {
                        if (((IonBool)ionValue).booleanValue()) {
                            n = ((IonBool)ionValue2).booleanValue() ? 0 : 1;
                            break;
                        }
                        n = ((IonBool)ionValue2).booleanValue() ? -1 : 0;
                        break;
                    }
                    case INT: {
                        n = ((IonInt)ionValue).bigIntegerValue().compareTo(((IonInt)ionValue2).bigIntegerValue());
                        break;
                    }
                    case FLOAT: {
                        n = Double.compare(((IonFloat)ionValue).doubleValue(), ((IonFloat)ionValue2).doubleValue());
                        break;
                    }
                    case DECIMAL: {
                        n = Decimal.equals(((IonDecimal)ionValue).decimalValue(), ((IonDecimal)ionValue2).decimalValue()) ? 0 : 1;
                        break;
                    }
                    case TIMESTAMP: {
                        if (bl) {
                            n = ((IonTimestamp)ionValue).timestampValue().equals(((IonTimestamp)ionValue2).timestampValue()) ? 0 : 1;
                            break;
                        }
                        n = ((IonTimestamp)ionValue).timestampValue().compareTo(((IonTimestamp)ionValue2).timestampValue());
                        break;
                    }
                    case STRING: {
                        n = ((IonText)ionValue).stringValue().compareTo(((IonText)ionValue2).stringValue());
                        break;
                    }
                    case SYMBOL: {
                        n = Equivalence.compareSymbolTokens(((IonSymbol)ionValue).symbolValue(), ((IonSymbol)ionValue2).symbolValue());
                        break;
                    }
                    case BLOB: 
                    case CLOB: {
                        n = Equivalence.compareLobContents((IonLob)ionValue, (IonLob)ionValue2);
                        break;
                    }
                    case STRUCT: {
                        n = Equivalence.compareStructs((IonStruct)ionValue, (IonStruct)ionValue2, bl);
                        break;
                    }
                    case LIST: 
                    case SEXP: 
                    case DATAGRAM: {
                        n = Equivalence.compareSequences((IonSequence)ionValue, (IonSequence)ionValue2, bl);
                    }
                }
            }
        }
        if (n == 0 && bl) {
            n = Equivalence.compareAnnotations(ionValue.getTypeAnnotationSymbols(), ionValue2.getTypeAnnotationSymbols());
        }
        return n;
    }

    public static boolean ionEquals(IonValue ionValue, IonValue ionValue2) {
        return Equivalence.ionEqualsImpl(ionValue, ionValue2, true);
    }

    public static boolean ionEqualsByContent(IonValue ionValue, IonValue ionValue2) {
        return Equivalence.ionEqualsImpl(ionValue, ionValue2, false);
    }

    static class Field {
        private final String name;
        private final IonValue value;
        private final boolean strict;
        private int occurrences;

        Field(IonValue ionValue, boolean bl) {
            SymbolToken symbolToken = ionValue.getFieldNameSymbol();
            String string = symbolToken.getText();
            if (string == null) {
                string = " -- UNKNOWN SYMBOL TEXT -- $" + symbolToken.getSid();
            }
            this.name = string;
            this.value = ionValue;
            this.strict = bl;
            this.occurrences = 0;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            Field field = (Field)object;
            return this.name.equals(field.name) && Equivalence.ionEqualsImpl(this.value, ((Field)object).value, this.strict);
        }
    }
}

