/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.ion.ContainedValueException;
import software.amazon.ion.Decimal;
import software.amazon.ion.IonSequence;
import software.amazon.ion.IonSexp;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.Timestamp;
import software.amazon.ion.ValueFactory;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonBlobLite;
import software.amazon.ion.impl.lite.IonBoolLite;
import software.amazon.ion.impl.lite.IonClobLite;
import software.amazon.ion.impl.lite.IonDecimalLite;
import software.amazon.ion.impl.lite.IonFloatLite;
import software.amazon.ion.impl.lite.IonIntLite;
import software.amazon.ion.impl.lite.IonListLite;
import software.amazon.ion.impl.lite.IonNullLite;
import software.amazon.ion.impl.lite.IonSexpLite;
import software.amazon.ion.impl.lite.IonStringLite;
import software.amazon.ion.impl.lite.IonStructLite;
import software.amazon.ion.impl.lite.IonSymbolLite;
import software.amazon.ion.impl.lite.IonSystemLite;
import software.amazon.ion.impl.lite.IonTimestampLite;
import software.amazon.ion.impl.lite.IonValueLite;

abstract class ValueFactoryLite
implements ValueFactory {
    private ContainerlessContext _context;

    ValueFactoryLite() {
    }

    protected void set_system(IonSystemLite ionSystemLite) {
        this._context = ContainerlessContext.wrap(ionSystemLite);
    }

    @Override
    public IonBlobLite newBlob(byte[] byArray) {
        IonBlobLite ionBlobLite = this.newBlob(byArray, 0, byArray == null ? 0 : byArray.length);
        return ionBlobLite;
    }

    @Override
    public IonBlobLite newBlob(byte[] byArray, int n, int n2) {
        IonBlobLite ionBlobLite = new IonBlobLite(this._context, byArray == null);
        ionBlobLite.setBytes(byArray, n, n2);
        return ionBlobLite;
    }

    @Override
    public IonBoolLite newBool(boolean bl) {
        IonBoolLite ionBoolLite = new IonBoolLite(this._context, false);
        ionBoolLite.setValue(bl);
        return ionBoolLite;
    }

    @Override
    public IonBoolLite newBool(Boolean bl) {
        IonBoolLite ionBoolLite = new IonBoolLite(this._context, bl == null);
        ionBoolLite.setValue(bl);
        return ionBoolLite;
    }

    @Override
    public IonClobLite newClob(byte[] byArray) {
        IonClobLite ionClobLite = this.newClob(byArray, 0, byArray == null ? 0 : byArray.length);
        return ionClobLite;
    }

    @Override
    public IonClobLite newClob(byte[] byArray, int n, int n2) {
        IonClobLite ionClobLite = new IonClobLite(this._context, byArray == null);
        ionClobLite.setBytes(byArray, n, n2);
        return ionClobLite;
    }

    @Override
    public IonDecimalLite newDecimal(long l) {
        IonDecimalLite ionDecimalLite = new IonDecimalLite(this._context, false);
        ionDecimalLite.setValue(l);
        return ionDecimalLite;
    }

    @Override
    public IonDecimalLite newDecimal(double d) {
        IonDecimalLite ionDecimalLite = new IonDecimalLite(this._context, false);
        ionDecimalLite.setValue(d);
        return ionDecimalLite;
    }

    @Override
    public IonDecimalLite newDecimal(BigInteger bigInteger) {
        boolean bl = bigInteger == null;
        IonDecimalLite ionDecimalLite = new IonDecimalLite(this._context, bl);
        if (bigInteger != null) {
            ionDecimalLite.setValue(Decimal.valueOf(bigInteger));
        }
        return ionDecimalLite;
    }

    @Override
    public IonDecimalLite newDecimal(BigDecimal bigDecimal) {
        boolean bl = bigDecimal == null;
        IonDecimalLite ionDecimalLite = new IonDecimalLite(this._context, bl);
        if (bigDecimal != null) {
            ionDecimalLite.setValue(bigDecimal);
        }
        return ionDecimalLite;
    }

    @Override
    public IonListLite newEmptyList() {
        IonListLite ionListLite = new IonListLite(this._context, false);
        return ionListLite;
    }

    @Override
    public IonSexpLite newEmptySexp() {
        IonSexpLite ionSexpLite = new IonSexpLite(this._context, false);
        return ionSexpLite;
    }

    @Override
    public IonStructLite newEmptyStruct() {
        IonStructLite ionStructLite = new IonStructLite(this._context, false);
        return ionStructLite;
    }

    @Override
    public IonFloatLite newFloat(long l) {
        IonFloatLite ionFloatLite = new IonFloatLite(this._context, false);
        ionFloatLite.setValue(l);
        return ionFloatLite;
    }

    @Override
    public IonFloatLite newFloat(double d) {
        IonFloatLite ionFloatLite = new IonFloatLite(this._context, false);
        ionFloatLite.setValue(d);
        return ionFloatLite;
    }

    @Override
    public IonIntLite newInt(int n) {
        IonIntLite ionIntLite = new IonIntLite(this._context, false);
        ionIntLite.setValue(n);
        return ionIntLite;
    }

    @Override
    public IonIntLite newInt(long l) {
        IonIntLite ionIntLite = new IonIntLite(this._context, false);
        ionIntLite.setValue(l);
        return ionIntLite;
    }

    @Override
    public IonIntLite newInt(Number number) {
        boolean bl = number == null;
        IonIntLite ionIntLite = new IonIntLite(this._context, bl);
        if (number != null) {
            ionIntLite.setValue(number);
        }
        return ionIntLite;
    }

    public IonListLite newList(Collection<? extends IonValue> collection) throws ContainedValueException, NullPointerException {
        IonListLite ionListLite = this.newEmptyList();
        if (collection == null) {
            ionListLite.makeNull();
        } else {
            ionListLite.addAll(collection);
        }
        return ionListLite;
    }

    @Override
    public IonListLite newList(IonSequence ionSequence) throws ContainedValueException, NullPointerException {
        IonListLite ionListLite = this.newEmptyList();
        ionListLite.add(ionSequence);
        return ionListLite;
    }

    @Override
    public IonListLite newList(IonValue ... ionValueArray) throws ContainedValueException, NullPointerException {
        List<IonValue> list = ionValueArray == null ? null : Arrays.asList(ionValueArray);
        IonListLite ionListLite = this.newEmptyList();
        if (list == null) {
            ionListLite.makeNull();
        } else {
            ionListLite.addAll((Collection<? extends IonValue>)list);
        }
        return ionListLite;
    }

    @Override
    public IonListLite newList(int[] nArray) {
        ArrayList<IonIntLite> arrayList = this.newInts(nArray);
        return this.newList(arrayList);
    }

    @Override
    public IonListLite newList(long[] lArray) {
        ArrayList<IonIntLite> arrayList = this.newInts(lArray);
        return this.newList(arrayList);
    }

    @Override
    public IonNullLite newNull() {
        IonNullLite ionNullLite = new IonNullLite(this._context);
        return ionNullLite;
    }

    @Override
    public IonValueLite newNull(IonType ionType) {
        switch (ionType) {
            case NULL: {
                return this.newNull();
            }
            case BOOL: {
                return this.newNullBool();
            }
            case INT: {
                return this.newNullInt();
            }
            case FLOAT: {
                return this.newNullFloat();
            }
            case DECIMAL: {
                return this.newNullDecimal();
            }
            case TIMESTAMP: {
                return this.newNullTimestamp();
            }
            case SYMBOL: {
                return this.newNullSymbol();
            }
            case STRING: {
                return this.newNullString();
            }
            case CLOB: {
                return this.newNullClob();
            }
            case BLOB: {
                return this.newNullBlob();
            }
            case LIST: {
                return this.newNullList();
            }
            case SEXP: {
                return this.newNullSexp();
            }
            case STRUCT: {
                return this.newNullStruct();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IonBlobLite newNullBlob() {
        IonBlobLite ionBlobLite = new IonBlobLite(this._context, true);
        return ionBlobLite;
    }

    @Override
    public IonBoolLite newNullBool() {
        IonBoolLite ionBoolLite = new IonBoolLite(this._context, true);
        return ionBoolLite;
    }

    @Override
    public IonClobLite newNullClob() {
        IonClobLite ionClobLite = new IonClobLite(this._context, true);
        return ionClobLite;
    }

    @Override
    public IonDecimalLite newNullDecimal() {
        IonDecimalLite ionDecimalLite = new IonDecimalLite(this._context, true);
        return ionDecimalLite;
    }

    @Override
    public IonFloatLite newNullFloat() {
        IonFloatLite ionFloatLite = new IonFloatLite(this._context, true);
        return ionFloatLite;
    }

    @Override
    public IonIntLite newNullInt() {
        IonIntLite ionIntLite = new IonIntLite(this._context, true);
        return ionIntLite;
    }

    @Override
    public IonListLite newNullList() {
        IonListLite ionListLite = new IonListLite(this._context, true);
        return ionListLite;
    }

    @Override
    public IonSexpLite newNullSexp() {
        IonSexpLite ionSexpLite = new IonSexpLite(this._context, true);
        return ionSexpLite;
    }

    @Override
    public IonStringLite newNullString() {
        IonStringLite ionStringLite = new IonStringLite(this._context, true);
        return ionStringLite;
    }

    @Override
    public IonStructLite newNullStruct() {
        IonStructLite ionStructLite = new IonStructLite(this._context, true);
        return ionStructLite;
    }

    @Override
    public IonSymbolLite newNullSymbol() {
        IonSymbolLite ionSymbolLite = new IonSymbolLite(this._context, true);
        return ionSymbolLite;
    }

    @Override
    public IonTimestampLite newNullTimestamp() {
        IonTimestampLite ionTimestampLite = new IonTimestampLite(this._context, true);
        return ionTimestampLite;
    }

    public IonSexpLite newSexp(Collection<? extends IonValue> collection) throws ContainedValueException, NullPointerException {
        IonSexpLite ionSexpLite = this.newEmptySexp();
        if (collection == null) {
            ionSexpLite.makeNull();
        } else {
            ionSexpLite.addAll(collection);
        }
        return ionSexpLite;
    }

    @Override
    public IonSexpLite newSexp(IonSequence ionSequence) throws ContainedValueException, NullPointerException {
        IonSexpLite ionSexpLite = this.newEmptySexp();
        ionSexpLite.add(ionSequence);
        return ionSexpLite;
    }

    @Override
    public IonSexp newSexp(IonValue ... ionValueArray) throws ContainedValueException, NullPointerException {
        List<IonValue> list = ionValueArray == null ? null : Arrays.asList(ionValueArray);
        IonSexpLite ionSexpLite = this.newEmptySexp();
        if (list == null) {
            ionSexpLite.makeNull();
        } else {
            ionSexpLite.addAll((Collection<? extends IonValue>)list);
        }
        return ionSexpLite;
    }

    @Override
    public IonSexpLite newSexp(int[] nArray) {
        ArrayList<IonIntLite> arrayList = this.newInts(nArray);
        return this.newSexp(arrayList);
    }

    @Override
    public IonSexpLite newSexp(long[] lArray) {
        ArrayList<IonIntLite> arrayList = this.newInts(lArray);
        return this.newSexp(arrayList);
    }

    @Override
    public IonStringLite newString(String string) {
        boolean bl = string == null;
        IonStringLite ionStringLite = new IonStringLite(this._context, bl);
        if (string != null) {
            ionStringLite.setValue(string);
        }
        return ionStringLite;
    }

    @Override
    public IonSymbolLite newSymbol(String string) {
        boolean bl = string == null;
        IonSymbolLite ionSymbolLite = new IonSymbolLite(this._context, bl);
        if (string != null) {
            ionSymbolLite.setValue(string);
        }
        return ionSymbolLite;
    }

    @Override
    public IonSymbolLite newSymbol(SymbolToken symbolToken) {
        return new IonSymbolLite(this._context, symbolToken);
    }

    @Override
    public IonTimestampLite newTimestamp(Timestamp timestamp) {
        boolean bl = timestamp == null;
        IonTimestampLite ionTimestampLite = new IonTimestampLite(this._context, bl);
        if (timestamp != null) {
            ionTimestampLite.setValue(timestamp);
        }
        return ionTimestampLite;
    }

    private ArrayList<IonIntLite> newInts(int[] nArray) {
        ArrayList<IonIntLite> arrayList = null;
        if (nArray != null) {
            arrayList = new ArrayList<IonIntLite>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                arrayList.add(this.newInt(n));
            }
        }
        return arrayList;
    }

    private ArrayList<IonIntLite> newInts(long[] lArray) {
        ArrayList<IonIntLite> arrayList = null;
        if (lArray != null) {
            arrayList = new ArrayList<IonIntLite>(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                long l = lArray[i];
                arrayList.add(this.newInt(l));
            }
        }
        return arrayList;
    }
}

