/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import software.amazon.ion.IonTimestamp;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.NullValueException;
import software.amazon.ion.Timestamp;
import software.amazon.ion.ValueVisitor;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonValueLite;

final class IonTimestampLite
extends IonValueLite
implements IonTimestamp {
    public static final Integer UTC_OFFSET = Timestamp.UTC_OFFSET;
    private static final int BIT_FLAG_YEAR = 1;
    private static final int BIT_FLAG_MONTH = 2;
    private static final int BIT_FLAG_DAY = 4;
    private static final int BIT_FLAG_MINUTE = 8;
    private static final int BIT_FLAG_SECOND = 16;
    private static final int BIT_FLAG_FRACTION = 32;
    private static final int HASH_SIGNATURE = IonType.TIMESTAMP.toString().hashCode();
    private Timestamp _timestamp_value;

    IonTimestampLite(ContainerlessContext containerlessContext, boolean bl) {
        super(containerlessContext, bl);
    }

    IonTimestampLite(IonTimestampLite ionTimestampLite, IonContext ionContext) {
        super(ionTimestampLite, ionContext);
        this._timestamp_value = ionTimestampLite._timestamp_value;
    }

    @Override
    IonTimestampLite clone(IonContext ionContext) {
        return new IonTimestampLite(this, ionContext);
    }

    @Override
    public IonTimestampLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    @Override
    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int n = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            n ^= this.timestampValue().hashCode();
        }
        return this.hashTypeAnnotations(n, symbolTableProvider);
    }

    @Override
    public IonType getType() {
        return IonType.TIMESTAMP;
    }

    @Override
    public Timestamp timestampValue() {
        if (this.isNullValue()) {
            return null;
        }
        return this._timestamp_value;
    }

    @Override
    public Date dateValue() {
        if (this._isNullValue()) {
            return null;
        }
        return this._timestamp_value.dateValue();
    }

    @Override
    public Integer getLocalOffset() throws NullValueException {
        if (this._isNullValue()) {
            throw new NullValueException();
        }
        return this._timestamp_value.getLocalOffset();
    }

    private Integer getInternalLocalOffset() {
        if (this._isNullValue()) {
            return null;
        }
        return this._timestamp_value.getLocalOffset();
    }

    @Override
    public void setValue(Timestamp timestamp) {
        this.checkForLock();
        this._timestamp_value = timestamp;
        this._isNullValue(timestamp == null);
    }

    @Override
    public void setValue(BigDecimal bigDecimal, Integer n) {
        this.setValue(Timestamp.forMillis(bigDecimal, n));
    }

    @Override
    public void setValue(long l, Integer n) {
        this.setValue(Timestamp.forMillis(l, n));
    }

    @Override
    public void setTime(Date date) {
        if (date == null) {
            this.makeNull();
        } else {
            this.setMillis(date.getTime());
        }
    }

    @Override
    public BigDecimal getDecimalMillis() {
        if (this._isNullValue()) {
            return null;
        }
        return this._timestamp_value.getDecimalMillis();
    }

    @Override
    public void setDecimalMillis(BigDecimal bigDecimal) {
        Integer n = this.getInternalLocalOffset();
        this.setValue(bigDecimal, n);
    }

    @Override
    public long getMillis() {
        if (this._isNullValue()) {
            throw new NullValueException();
        }
        return this._timestamp_value.getMillis();
    }

    @Override
    public void setMillis(long l) {
        Integer n = this.getInternalLocalOffset();
        this.setValue(l, n);
    }

    @Override
    public void setMillisUtc(long l) {
        this.setValue(l, UTC_OFFSET);
    }

    @Override
    public void setCurrentTime() {
        long l = System.currentTimeMillis();
        this.setMillis(l);
    }

    @Override
    public void setCurrentTimeUtc() {
        long l = System.currentTimeMillis();
        this.setMillisUtc(l);
    }

    @Override
    public void setLocalOffset(int n) throws NullValueException {
        this.setLocalOffset(new Integer(n));
    }

    @Override
    public void setLocalOffset(Integer n) throws NullValueException {
        this.validateThisNotNull();
        assert (this._timestamp_value != null);
        this.setValue(this._timestamp_value.getDecimalMillis(), n);
    }

    @Override
    public void makeNull() {
        this.checkForLock();
        this._timestamp_value = null;
        this._isNullValue(true);
    }

    @Override
    final void writeBodyTo(IonWriter ionWriter, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        ionWriter.writeTimestamp(this._timestamp_value);
    }

    @Override
    public void accept(ValueVisitor valueVisitor) throws Exception {
        valueVisitor.visit(this);
    }
}

