/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import software.amazon.ion.ContainedValueException;
import software.amazon.ion.IonStruct;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.IonWriter;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.ValueFactory;
import software.amazon.ion.ValueVisitor;
import software.amazon.ion.impl.PrivateCurriedValueFactory;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContainerLite;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonValueLite;

final class IonStructLite
extends IonContainerLite
implements IonStruct {
    private static final int HASH_SIGNATURE = IonType.STRUCT.toString().hashCode();
    private Map<String, Integer> _field_map;
    public int _field_map_duplicate_count;

    IonStructLite(ContainerlessContext containerlessContext, boolean bl) {
        super(containerlessContext, bl);
    }

    private IonStructLite(IonStructLite ionStructLite, IonContext ionContext) {
        super(ionStructLite, ionContext, true);
        this._field_map = null == this._field_map ? null : new HashMap<String, Integer>(ionStructLite._field_map);
        this._field_map_duplicate_count = ionStructLite._field_map_duplicate_count;
    }

    @Override
    IonStructLite clone(IonContext ionContext) {
        return new IonStructLite(this, ionContext);
    }

    @Override
    public IonStructLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    @Override
    protected void transitionToLargeSize(int n) {
        if (this._field_map != null) {
            return;
        }
        this.build_field_map();
    }

    protected void build_field_map() {
        int n = this._children == null ? 0 : this._children.length;
        this._field_map = new HashMap<String, Integer>(n);
        this._field_map_duplicate_count = 0;
        int n2 = this.get_child_count();
        for (int i = 0; i < n2; ++i) {
            IonValueLite ionValueLite = this.get_child(i);
            SymbolToken symbolToken = ionValueLite.getFieldNameSymbol();
            String string = symbolToken.getText();
            if (this._field_map.get(string) != null) {
                ++this._field_map_duplicate_count;
            }
            this._field_map.put(string, i);
        }
    }

    private void add_field(String string, int n) {
        Integer n2 = this._field_map.get(string);
        if (n2 != null) {
            ++this._field_map_duplicate_count;
            if (n2 > n) {
                n = n2;
            }
        }
        this._field_map.put(string, n);
    }

    private void remove_field(String string, int n, int n2) {
        if (this._field_map == null) {
            return;
        }
        Integer n3 = this._field_map.get(string);
        assert (n3 != null);
        this._field_map.remove(string);
        this._field_map_duplicate_count -= n2 - 1;
    }

    private void remove_field_from_field_map(String string, int n) {
        Integer n2 = this._field_map.get(string);
        assert (n2 != null);
        if (n2 != n) {
            assert (this._field_map_duplicate_count > 0);
            --this._field_map_duplicate_count;
        } else if (this._field_map_duplicate_count > 0) {
            int n3 = this.find_last_duplicate(string, n);
            if (n3 == -1) {
                this._field_map.remove(string);
            } else {
                this._field_map.put(string, n3);
                --this._field_map_duplicate_count;
            }
        } else {
            this._field_map.remove(string);
        }
    }

    private void patch_map_elements_helper(int n) {
        if (this._field_map == null) {
            return;
        }
        if (n >= this.get_child_count()) {
            return;
        }
        for (int i = n; i < this.get_child_count(); ++i) {
            IonValueLite ionValueLite = this.get_child(i);
            String string = ionValueLite.getFieldName();
            Integer n2 = this._field_map.get(string);
            if (n2 == i) continue;
            this._field_map.put(string, i);
        }
    }

    @Override
    public void dump(PrintWriter printWriter) {
        super.dump(printWriter);
        if (this._field_map == null) {
            return;
        }
        printWriter.println("   dups: " + this._field_map_duplicate_count);
        Iterator<Map.Entry<String, Integer>> iterator2 = this._field_map.entrySet().iterator();
        printWriter.print("   map: [");
        boolean bl = true;
        while (iterator2.hasNext()) {
            Map.Entry<String, Integer> entry = iterator2.next();
            if (!bl) {
                printWriter.print(",");
            }
            printWriter.print(entry.getKey() + ":" + entry.getValue());
            bl = false;
        }
        printWriter.println("]");
    }

    @Override
    public String validate() {
        if (this._field_map == null) {
            return null;
        }
        String string = "";
        for (Map.Entry<String, Integer> entry : this._field_map.entrySet()) {
            IonValueLite ionValueLite;
            int n = entry.getValue();
            IonValueLite ionValueLite2 = ionValueLite = n >= 0 && n < this.get_child_count() ? this.get_child(n) : null;
            if (ionValueLite != null && n == ionValueLite._elementid() && entry.getKey().equals(ionValueLite.getFieldName())) continue;
            string = string + "map entry [" + entry + "] doesn't match list value [" + ionValueLite + "]\n";
        }
        return string == "" ? null : string;
    }

    private int find_last_duplicate(String string, int n) {
        int n2 = n;
        while (n2 > 0) {
            IonValueLite ionValueLite;
            if (!string.equals((ionValueLite = this.get_child(--n2)).getFieldName())) continue;
            return n2;
        }
        assert (this.there_is_only_one(string, n));
        return -1;
    }

    private boolean there_is_only_one(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < this.get_child_count(); ++i) {
            IonValueLite ionValueLite = this.get_child(i);
            if (!ionValueLite.getFieldName().equals(string)) continue;
            ++n2;
        }
        return n2 == 1 || n2 == 0;
    }

    @Override
    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int n = 16777619;
        int n2 = 8191;
        int n3 = 127;
        int n4 = 31;
        int n5 = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            for (IonValue ionValue : this) {
                IonValueLite ionValueLite = (IonValueLite)ionValue;
                SymbolToken symbolToken = ionValueLite.getFieldNameSymbol(symbolTableProvider);
                String string = symbolToken.getText();
                int n6 = string == null ? symbolToken.getSid() * 127 : string.hashCode() * 31;
                n6 ^= n6 << 17 ^ n6 >> 15;
                int n7 = HASH_SIGNATURE;
                n7 = 8191 * n7 + ionValueLite.hashCode(symbolTableProvider);
                n7 = 16777619 * n7 + n6;
                n7 ^= n7 << 19 ^ n7 >> 13;
                n5 += n7;
            }
        }
        return this.hashTypeAnnotations(n5, symbolTableProvider);
    }

    @Override
    public IonStruct cloneAndRemove(String ... stringArray) {
        return this.doClone(false, stringArray);
    }

    @Override
    public IonStruct cloneAndRetain(String ... stringArray) {
        return this.doClone(true, stringArray);
    }

    private IonStruct doClone(boolean bl, String ... stringArray) {
        IonStructLite ionStructLite;
        if (this.isNullValue()) {
            ionStructLite = this.getSystem().newNullStruct();
        } else {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
            if (bl && hashSet.contains(null)) {
                throw new NullPointerException("Can't retain an unknown field name");
            }
            ionStructLite = this.getSystem().newEmptyStruct();
            for (IonValue ionValue : this) {
                SymbolToken symbolToken = ionValue.getFieldNameSymbol();
                String string = symbolToken.getText();
                if (hashSet.contains(string) != bl) continue;
                string = ionValue.getFieldName();
                ionStructLite.add(string, ionValue.clone());
            }
        }
        ionStructLite.setTypeAnnotationSymbols(this.getTypeAnnotationSymbols());
        return ionStructLite;
    }

    @Override
    public IonType getType() {
        return IonType.STRUCT;
    }

    @Override
    public boolean containsKey(Object object) {
        String string = (String)object;
        return null != this.get(string);
    }

    @Override
    public boolean containsValue(Object object) {
        IonValue ionValue = (IonValue)object;
        return ionValue.getContainer() == this;
    }

    @Override
    public IonValue get(String string) {
        int n = this.find_field_helper(string);
        IonValueLite ionValueLite = n < 0 ? null : this.get_child(n);
        return ionValueLite;
    }

    private int find_field_helper(String string) {
        IonStructLite.validateFieldName(string);
        if (!this.isNullValue()) {
            if (this._field_map != null) {
                Integer n = this._field_map.get(string);
                if (n != null) {
                    return n;
                }
            } else {
                int n = this.get_child_count();
                for (int i = 0; i < n; ++i) {
                    IonValueLite ionValueLite = this.get_child(i);
                    if (!string.equals(ionValueLite.getFieldName())) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    @Override
    public void clear() {
        super.clear();
        this._field_map = null;
        this._field_map_duplicate_count = 0;
    }

    @Override
    public boolean add(IonValue ionValue) throws NullPointerException, IllegalArgumentException, ContainedValueException {
        String string = ionValue.getFieldNameSymbol().getText();
        if (string != null) {
            IonStructLite.validateFieldName(string);
        }
        IonValueLite ionValueLite = (IonValueLite)ionValue;
        this._add(string, ionValueLite);
        return true;
    }

    @Override
    public ValueFactory add(final String string) {
        return new PrivateCurriedValueFactory(this._context.getSystem()){

            @Override
            protected void handle(IonValue ionValue) {
                IonStructLite.this.add(string, ionValue);
            }
        };
    }

    private void _add(String string, IonValueLite ionValueLite) {
        int n = this.get_child_count();
        this.add(n, ionValueLite);
        if (this._field_map != null) {
            this.add_field(string, ionValueLite._elementid());
        }
    }

    @Override
    public void add(String string, IonValue ionValue) {
        this.checkForLock();
        this.validateNewChild(ionValue);
        IonStructLite.validateFieldName(string);
        IonValueLite ionValueLite = (IonValueLite)ionValue;
        this._add(string, ionValueLite);
        ionValueLite.setFieldName(string);
    }

    @Override
    public void add(SymbolToken symbolToken, IonValue ionValue) {
        String string = symbolToken.getText();
        if (string != null) {
            this.add(string, ionValue);
            return;
        }
        if (symbolToken.getSid() < 1) {
            throw new IllegalArgumentException("fieldName has no text or ID");
        }
        this.checkForLock();
        this.validateNewChild(ionValue);
        IonValueLite ionValueLite = (IonValueLite)ionValue;
        ionValueLite.setFieldNameSymbol(symbolToken);
        this._add(string, ionValueLite);
    }

    @Override
    public ValueFactory put(final String string) {
        return new PrivateCurriedValueFactory(this._context.getSystem()){

            @Override
            protected void handle(IonValue ionValue) {
                IonStructLite.this.put(string, ionValue);
            }
        };
    }

    @Override
    public void putAll(Map<? extends String, ? extends IonValue> map) {
        for (Map.Entry<? extends String, ? extends IonValue> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void put(String string, IonValue ionValue) {
        this.checkForLock();
        IonStructLite.validateFieldName(string);
        if (ionValue != null) {
            this.validateNewChild(ionValue);
        }
        int n = this.get_child_count();
        boolean bl = false;
        if (this._field_map != null && this._field_map_duplicate_count == 0) {
            Integer n2 = this._field_map.get(string);
            if (n2 != null) {
                n = n2;
                this.remove_field_from_field_map(string, n);
                this.remove_child(n);
                bl = true;
            }
        } else {
            int n3 = 0;
            int n4 = this.get_child_count();
            while (n4 > 0) {
                IonValueLite ionValueLite;
                if (!string.equals((ionValueLite = this.get_child(--n4)).getFieldNameSymbol().getText())) continue;
                this.remove_child(n4);
                n = n4;
                ++n3;
                bl = true;
            }
            if (bl) {
                this.remove_field(string, n, n3);
            }
        }
        if (bl) {
            this.patch_map_elements_helper(n);
            this.patch_elements_helper(n);
        }
        if (ionValue != null) {
            this.add(string, ionValue);
        }
    }

    @Override
    public ListIterator<IonValue> listIterator(int n) {
        return new IonContainerLite.SequenceContentIterator(n, this.isReadOnly()){

            @Override
            public void remove() {
                if (this.__readOnly) {
                    throw new UnsupportedOperationException();
                }
                this.force_position_sync();
                int n = this.__pos;
                if (!this.__lastMoveWasPrevious) {
                    --n;
                }
                if (n < 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                IonValueLite ionValueLite = this.__current;
                int n2 = ionValueLite._elementid();
                assert (n2 == n);
                if (IonStructLite.this._field_map != null) {
                    IonStructLite.this.remove_field_from_field_map(ionValueLite.getFieldName(), n);
                }
                super.remove();
                if (IonStructLite.this._field_map != null) {
                    IonStructLite.this.patch_map_elements_helper(n);
                }
            }
        };
    }

    @Override
    public IonValue remove(String string) {
        this.checkForLock();
        IonValue ionValue = this.get(string);
        if (ionValue == null) {
            return null;
        }
        int n = ((IonValueLite)ionValue)._elementid();
        if (this._field_map != null) {
            this.remove_field_from_field_map(string, n);
        }
        super.remove(ionValue);
        if (this._field_map != null) {
            this.patch_map_elements_helper(n);
        }
        return ionValue;
    }

    @Override
    public boolean remove(IonValue ionValue) {
        if (ionValue == null) {
            throw new NullPointerException();
        }
        this.checkForLock();
        if (ionValue.getContainer() != this) {
            return false;
        }
        IonValueLite ionValueLite = (IonValueLite)ionValue;
        int n = ionValueLite._elementid();
        if (this._field_map != null) {
            this.remove_field_from_field_map(ionValueLite.getFieldName(), n);
        }
        super.remove(ionValueLite);
        if (this._field_map != null) {
            this.patch_map_elements_helper(n);
        }
        return true;
    }

    @Override
    public boolean removeAll(String ... stringArray) {
        int n;
        boolean bl = false;
        this.checkForLock();
        int n2 = n = this.get_child_count();
        while (n2 > 0) {
            IonValueLite ionValueLite;
            if (!IonStructLite.isListedField(ionValueLite = this.get_child(--n2), stringArray)) continue;
            ionValueLite.removeFromContainer();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(String ... stringArray) {
        int n;
        this.checkForLock();
        boolean bl = false;
        int n2 = n = this.get_child_count();
        while (n2 > 0) {
            IonValueLite ionValueLite;
            if (IonStructLite.isListedField(ionValueLite = this.get_child(--n2), stringArray)) continue;
            ionValueLite.removeFromContainer();
            bl = true;
        }
        return bl;
    }

    private static boolean isListedField(IonValue ionValue, String[] stringArray) {
        String string = ionValue.getFieldName();
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static void validateFieldName(String string) {
        if (string == null) {
            throw new NullPointerException("fieldName is null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("fieldName is empty");
        }
    }

    @Override
    final void writeBodyTo(IonWriter ionWriter, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        if (this.isNullValue()) {
            ionWriter.writeNull(IonType.STRUCT);
        } else {
            ionWriter.stepIn(IonType.STRUCT);
            this.writeChildren(ionWriter, this, symbolTableProvider);
            ionWriter.stepOut();
        }
    }

    @Override
    public void accept(ValueVisitor valueVisitor) throws Exception {
        valueVisitor.visit(this);
    }
}

