/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.zip.CRC32;
import software.amazon.ion.IonLob;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonValueLite;

abstract class IonLobLite
extends IonValueLite
implements IonLob {
    private byte[] _lob_value;

    protected IonLobLite(ContainerlessContext containerlessContext, boolean bl) {
        super(containerlessContext, bl);
    }

    IonLobLite(IonLobLite ionLobLite, IonContext ionContext) {
        super(ionLobLite, ionContext);
        if (null != ionLobLite._lob_value) {
            int n = ionLobLite._lob_value.length;
            this._lob_value = new byte[n];
            System.arraycopy(ionLobLite._lob_value, 0, this._lob_value, 0, n);
        }
    }

    @Override
    public abstract IonLobLite clone();

    protected int lobHashCode(int n, PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int n2 = n;
        if (!this.isNullValue()) {
            CRC32 cRC32 = new CRC32();
            cRC32.update(this.getBytes());
            n2 ^= (int)cRC32.getValue();
        }
        return this.hashTypeAnnotations(n2, symbolTableProvider);
    }

    protected final void copyBytesFrom(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            this._lob_value = null;
            this._isNullValue(true);
        } else {
            if (this._lob_value == null || this._lob_value.length != n2) {
                this._lob_value = new byte[n2];
            }
            System.arraycopy(byArray, n, this._lob_value, 0, n2);
            this._isNullValue(false);
        }
    }

    protected byte[] getBytesNoCopy() {
        return this._lob_value;
    }

    @Override
    public final InputStream newInputStream() {
        if (this._isNullValue()) {
            return null;
        }
        return new ByteArrayInputStream(this._lob_value);
    }

    @Override
    public final byte[] getBytes() {
        byte[] byArray = this._isNullValue() ? null : (byte[])this._lob_value.clone();
        return byArray;
    }

    @Override
    public final void setBytes(byte[] byArray) {
        this.setBytes(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    @Override
    public final void setBytes(byte[] byArray, int n, int n2) {
        this.checkForLock();
        this.copyBytesFrom(byArray, n, n2);
    }

    @Override
    public final int byteSize() {
        this.validateThisNotNull();
        return this._lob_value.length;
    }
}

