/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import software.amazon.ion.ContainedValueException;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonDatagram;
import software.amazon.ion.IonException;
import software.amazon.ion.IonSymbol;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.IonWriter;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.ValueFactory;
import software.amazon.ion.ValueVisitor;
import software.amazon.ion.impl.PrivateCurriedValueFactory;
import software.amazon.ion.impl.PrivateIonDatagram;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContainerLite;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonSequenceLite;
import software.amazon.ion.impl.lite.IonSymbolLite;
import software.amazon.ion.impl.lite.IonSystemLite;
import software.amazon.ion.impl.lite.IonValueLite;
import software.amazon.ion.impl.lite.ReverseBinaryEncoder;
import software.amazon.ion.impl.lite.TopLevelContext;

final class IonDatagramLite
extends IonSequenceLite
implements IonDatagram,
PrivateIonDatagram,
IonContext {
    private static final int HASH_SIGNATURE = IonType.DATAGRAM.toString().hashCode();
    private final IonSystemLite _system;
    private final IonCatalog _catalog;
    private SymbolTable _pending_symbol_table;
    private int _pending_symbol_table_idx;
    private IonSymbolLite _ivm;
    private static final int REVERSE_BINARY_ENCODER_INITIAL_SIZE = 32768;

    IonDatagramLite(IonSystemLite ionSystemLite, IonCatalog ionCatalog) {
        super(ContainerlessContext.wrap(ionSystemLite), false);
        this._system = ionSystemLite;
        this._catalog = ionCatalog;
        this._pending_symbol_table_idx = -1;
    }

    IonDatagramLite(IonDatagramLite ionDatagramLite) {
        super(ionDatagramLite, (IonContext)ContainerlessContext.wrap(ionDatagramLite._system));
        this._system = ionDatagramLite._system;
        this._catalog = ionDatagramLite._catalog;
    }

    @Override
    IonDatagramLite clone(IonContext ionContext) {
        String string = "IonDatagram cannot have a parent context (be nested)";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public IonDatagramLite clone() {
        return new IonDatagramLite(this);
    }

    @Override
    public IonValueLite topLevelValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SymbolToken[] getTypeAnnotationSymbols() {
        return SymbolToken.EMPTY_ARRAY;
    }

    @Override
    public SymbolToken getFieldNameSymbol() {
        return null;
    }

    @Override
    public void makeReadOnly() {
        if (this._isLocked()) {
            return;
        }
        if (this._children != null) {
            for (int i = 0; i < this._child_count; ++i) {
                IonValueLite ionValueLite = this._children[i];
                ionValueLite.makeReadOnly();
            }
        }
        this._isLocked(true);
    }

    @Override
    public SymbolTable getSymbolTable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SymbolTable getAssignedSymbolTable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSymbolTable(SymbolTable symbolTable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendTrailingSymbolTable(SymbolTable symbolTable) {
        assert (symbolTable.isLocalTable() || symbolTable.isSystemTable());
        this._pending_symbol_table = symbolTable;
        this._pending_symbol_table_idx = this.get_child_count();
    }

    @Override
    public boolean add(IonValue ionValue) throws ContainedValueException, NullPointerException {
        int n = this._child_count;
        this.add(n, ionValue);
        return true;
    }

    @Override
    public ValueFactory add() {
        return new PrivateCurriedValueFactory(this.getSystem()){

            @Override
            protected void handle(IonValue ionValue) {
                IonDatagramLite.this.add(ionValue);
            }
        };
    }

    @Override
    public void add(int n, IonValue ionValue) throws ContainedValueException, NullPointerException {
        if (ionValue == null) {
            throw new NullPointerException();
        }
        if (!(ionValue instanceof IonValueLite)) {
            throw new IllegalArgumentException("IonValue implementation can't be mixed");
        }
        IonValueLite ionValueLite = (IonValueLite)ionValue;
        super.add(n, ionValueLite);
        this._pending_symbol_table = null;
        this._pending_symbol_table_idx = -1;
    }

    @Override
    public ValueFactory add(final int n) {
        return new PrivateCurriedValueFactory(this.getSystem()){

            @Override
            protected void handle(IonValue ionValue) {
                IonDatagramLite.this.add(n, ionValue);
            }
        };
    }

    @Override
    public boolean addAll(Collection<? extends IonValue> collection) {
        boolean bl = false;
        for (IonValue ionValue : collection) {
            bl = this.add(ionValue) || bl;
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends IonValue> collection) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        boolean bl = false;
        for (IonValue ionValue : collection) {
            this.add(n++, ionValue);
            bl = true;
        }
        if (bl) {
            this.patch_elements_helper(n);
        }
        return bl;
    }

    @Override
    public int hashCode() {
        int n = 8191;
        int n2 = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            for (IonValue ionValue : this) {
                n2 = n * n2 + ionValue.hashCode();
                n2 ^= n2 << 29 ^ n2 >> 3;
            }
        }
        return n2;
    }

    @Override
    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        String string = "IonDatagrams do not need a resolved Symbol table use #hashCode()";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public <T extends IonValue> T[] extract(Class<T> clazz) {
        if (this.isNullValue()) {
            return null;
        }
        IonValue[] ionValueArray = (IonValue[])Array.newInstance(clazz, this.size());
        this.toArray(ionValueArray);
        this.clear();
        return ionValueArray;
    }

    @Override
    public ListIterator<IonValue> listIterator(int n) {
        IonContainerLite.SequenceContentIterator sequenceContentIterator = new IonContainerLite.SequenceContentIterator(n, this.isReadOnly());
        return sequenceContentIterator;
    }

    @Override
    public IonValue set(int n, IonValue ionValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IonContext getContextForIndex(IonValue ionValue, int n) {
        IonValueLite ionValueLite;
        if (n == this._pending_symbol_table_idx) {
            SymbolTable symbolTable = this._pending_symbol_table;
            this._pending_symbol_table = null;
            this._pending_symbol_table_idx = -1;
            return TopLevelContext.wrap(symbolTable, this);
        }
        IonValueLite ionValueLite2 = ionValueLite = n > 0 ? this.get_child(n - 1) : null;
        if (ionValueLite != null && ionValueLite._context != this) {
            return ionValueLite._context;
        }
        return TopLevelContext.wrap(null, this);
    }

    @Override
    public void accept(ValueVisitor valueVisitor) throws Exception {
        valueVisitor.visit(this);
    }

    @Override
    public void addTypeAnnotation(String string) {
        String string2 = "Datagrams do not have annotations";
        throw new UnsupportedOperationException(string2);
    }

    @Override
    public IonContainerLite getContainer() {
        return null;
    }

    @Override
    public IonSystemLite getSystem() {
        return this._system;
    }

    @Override
    public IonType getType() {
        return IonType.DATAGRAM;
    }

    @Override
    public final void writeTo(IonWriter ionWriter) {
        try {
            ionWriter.writeSymbol("$ion_1_0");
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
        for (IonValue ionValue : this) {
            ionValue.writeTo(ionWriter);
        }
    }

    @Override
    final void writeBodyTo(IonWriter ionWriter, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        throw new UnsupportedOperationException("IonDatagram does not operate with a Symbol Table");
    }

    @Override
    public int byteSize() throws IonException {
        ReverseBinaryEncoder reverseBinaryEncoder = new ReverseBinaryEncoder(32768);
        reverseBinaryEncoder.serialize(this);
        return reverseBinaryEncoder.byteSize();
    }

    @Override
    public byte[] getBytes() throws IonException {
        ReverseBinaryEncoder reverseBinaryEncoder = new ReverseBinaryEncoder(32768);
        reverseBinaryEncoder.serialize(this);
        return reverseBinaryEncoder.toNewByteArray();
    }

    @Override
    public int getBytes(OutputStream outputStream2) throws IOException, IonException {
        ReverseBinaryEncoder reverseBinaryEncoder = new ReverseBinaryEncoder(32768);
        reverseBinaryEncoder.serialize(this);
        return reverseBinaryEncoder.writeBytes(outputStream2);
    }

    @Override
    public IonValue systemGet(int n) throws IndexOutOfBoundsException {
        ListIterator<IonValue> listIterator = this.systemIterator();
        IonValue ionValue = null;
        if (n < 0) {
            throw new IndexOutOfBoundsException("" + n);
        }
        for (int i = 0; i <= n; ++i) {
            if (!listIterator.hasNext()) {
                throw new IndexOutOfBoundsException("" + n);
            }
            ionValue = listIterator.next();
        }
        return ionValue;
    }

    @Override
    public ListIterator<IonValue> systemIterator() {
        return new SystemContentIterator(this.isReadOnly());
    }

    @Override
    public int systemSize() {
        int n = 0;
        ListIterator<IonValue> listIterator = this.systemIterator();
        while (listIterator.hasNext()) {
            IonValue ionValue = listIterator.next();
            ++n;
        }
        return n;
    }

    void setSymbolTableAtIndex(int n, SymbolTable symbolTable) {
        assert (n < this.get_child_count());
        TopLevelContext topLevelContext = TopLevelContext.wrap(symbolTable, this);
        TopLevelContext topLevelContext2 = (TopLevelContext)this._children[n].getContext();
        while (n < this.get_child_count() && this._children[n].getContext() == topLevelContext2) {
            this._children[n++].setContext(topLevelContext);
        }
    }

    protected synchronized IonSymbolLite get_ivm() {
        if (this._ivm == null) {
            this._ivm = this.getSystem().newSymbol("$ion_1_0");
        }
        return this._ivm;
    }

    static class SystemIteratorPosition {
        protected final SystemContentIterator __iterator;
        protected int __index_adjustment;
        protected int __local_index;
        protected IonValueLite[] __local_values = new IonValueLite[3];
        protected int __local_value_count;
        protected int __user_index;
        protected IonValueLite __current_user_value;
        protected SymbolTable __current_symbols;
        protected int __current_symbols_index;

        SystemIteratorPosition(SystemContentIterator systemContentIterator) {
            this.__iterator = systemContentIterator;
        }

        void load_initial_position() {
            this.__user_index = 0;
            this.__local_index = -1;
            this.__current_symbols_index = -1;
            this.load_updated_position();
        }

        protected int get_external_pos() {
            int n = this.__user_index;
            n += this.__index_adjustment;
            n -= this.__local_value_count;
            return n += this.__local_index;
        }

        protected boolean on_system_value() {
            return this.__current_user_value != this.__local_values[0];
        }

        protected boolean has_next() {
            if (this.__local_index + 1 < this.__local_value_count) {
                return true;
            }
            return this.__user_index + 1 < this.__iterator.get_datagram_child_count();
        }

        protected boolean has_prev() {
            if (this.__user_index > 0) {
                return true;
            }
            return this.__local_index > 0;
        }

        protected void copyFrom(SystemIteratorPosition systemIteratorPosition) {
            this.__index_adjustment = systemIteratorPosition.__index_adjustment;
            this.__user_index = systemIteratorPosition.__user_index;
            this.__local_index = systemIteratorPosition.__local_index;
            this.__current_user_value = systemIteratorPosition.__current_user_value;
            this.__current_symbols = systemIteratorPosition.__current_symbols;
            this.__current_symbols_index = systemIteratorPosition.__current_symbols_index;
            if (systemIteratorPosition.__local_value_count > 0) {
                if (this.__local_values == null || systemIteratorPosition.__local_value_count >= this.__local_values.length) {
                    this.__local_values = new IonValueLite[systemIteratorPosition.__local_values.length];
                }
                System.arraycopy(systemIteratorPosition.__local_values, 0, this.__local_values, 0, systemIteratorPosition.__local_value_count);
            }
            this.__local_value_count = systemIteratorPosition.__local_value_count;
        }

        private void load_updated_position() {
            IonValueLite ionValueLite = this.__current_user_value;
            if (this.__user_index < 0 || this.__user_index > 0 && this.__user_index >= this.__iterator.get_datagram_child_count()) {
                throw new IonException("attempt to position iterator past end of values");
            }
            if (this.__user_index < this.__iterator.get_datagram_child_count()) {
                this.__current_user_value = this.__iterator.get_datagram_child(this.__user_index);
                assert (this.__current_user_value != null);
            } else {
                assert (this.__user_index == 0 && this.__iterator.get_datagram_child_count() == 0);
                this.__current_user_value = null;
            }
            int n = this.__local_value_count;
            this.__local_value_count = 0;
            if (this.__current_user_value != null) {
                this.push_system_value(this.__current_user_value);
            }
            this.load_current_symbol_table(ionValueLite);
            for (int i = this.__local_value_count; i < n; ++i) {
                this.__local_values[i] = null;
            }
            this.__index_adjustment += this.__local_value_count - 1;
        }

        void load_current_symbol_table(IonValueLite ionValueLite) {
            Object object;
            IonValueLite ionValueLite2 = this.__current_user_value;
            int n = this.__user_index;
            IonValueLite ionValueLite3 = ionValueLite;
            SymbolTable symbolTable = this.__current_symbols;
            int n2 = this.__current_symbols_index;
            this.__current_symbols = null;
            this.__current_symbols_index = n;
            SymbolTable symbolTable2 = null;
            if (ionValueLite2 != null) {
                this.__current_symbols = symbolTable2 = ionValueLite2.getAssignedSymbolTable();
            }
            if (n - 1 != n2) {
                n2 = n - 1;
                symbolTable = null;
                if (n2 >= 0 && n2 < this.__iterator.get_datagram_child_count()) {
                    ionValueLite3 = this.__iterator.get_datagram_child(n2);
                    symbolTable = ionValueLite3.getAssignedSymbolTable();
                }
            }
            if (symbolTable2 != symbolTable) {
                object = symbolTable2;
                while (object != null) {
                    IonValue ionValue;
                    boolean bl = object.isSystemTable();
                    if (bl) {
                        ionValue = this.__iterator.get_datagram_ivm();
                    } else {
                        IonSystem ionSystem = this.__iterator.get_datagram_system();
                        ionValue = PrivateUtils.symtabTree(ionSystem, (SymbolTable)object);
                    }
                    assert (ionValue != null && this.__iterator.get_datagram_system() == ionValue.getSystem());
                    if (ionValue == ionValueLite3 || SystemIteratorPosition.is_ivm(ionValueLite2) && bl) {
                        int n3;
                        int n4 = n3 = ionValueLite3 == null ? -1 : ionValueLite3._elementid() - 1;
                        ionValueLite3 = n3 >= 0 ? this.__iterator.get_datagram_child(n3) : null;
                    } else {
                        this.push_system_value((IonValueLite)ionValue);
                        ionValueLite3 = null;
                    }
                    if ((object = ionValue.getSymbolTable()) != null && !object.isSystemTable()) continue;
                    break;
                }
            }
            if (n == 0 && !SystemIteratorPosition.is_ivm(ionValueLite2)) {
                object = this.__iterator.get_datagram_ivm();
                this.push_system_value((IonValueLite)object);
            }
        }

        private static final boolean is_ivm(IonValue ionValue) {
            IonSymbol ionSymbol;
            SymbolToken symbolToken;
            return ionValue instanceof IonSymbol && ionValue.getTypeAnnotationSymbols().length == 0 && (symbolToken = (ionSymbol = (IonSymbol)ionValue).symbolValue()) != null && "$ion_1_0".equals(symbolToken.getText());
        }

        private void push_system_value(IonValueLite ionValueLite) {
            if (this.__local_value_count >= this.__local_values.length) {
                int n;
                int n2 = n = this.__local_values == null ? 2 : this.__local_values.length * 2;
                assert (n > this.__local_value_count);
                IonValueLite[] ionValueLiteArray = new IonValueLite[n];
                if (this.__local_value_count > 0) {
                    System.arraycopy(this.__local_values, 0, ionValueLiteArray, 0, this.__local_value_count);
                }
                this.__local_values = ionValueLiteArray;
            }
            this.__local_values[this.__local_value_count++] = ionValueLite;
        }

        protected IonValueLite load_position() {
            IonValueLite ionValueLite = null;
            assert (this.__local_index < this.__local_value_count);
            ionValueLite = this.__local_values[this.__local_value_count - this.__local_index - 1];
            return ionValueLite;
        }

        private final void force_position_sync_helper() {
            if (!this.__iterator.datagram_contains(this.__current_user_value)) {
                throw new IonException("current user value removed outside this iterator - position lost");
            }
            int n = this.__user_index;
            int n2 = this.__current_user_value._elementid();
            if (n != n2) {
                int n3 = 0;
                SymbolTable symbolTable = null;
                for (int i = 0; i < n2; --i) {
                    SymbolTable symbolTable2 = this.__iterator.get_datagram_child(i).getSymbolTable();
                    if (symbolTable2 != symbolTable) {
                        IonSystem ionSystem = this.__iterator.getSystem();
                        n3 += SystemIteratorPosition.count_system_values(ionSystem, symbolTable, symbolTable2);
                    }
                    symbolTable = symbolTable2;
                }
                this.__index_adjustment = n3 + this.__local_value_count;
                this.__user_index = n2;
            }
        }

        private static int count_system_values(IonSystem ionSystem, SymbolTable symbolTable, SymbolTable symbolTable2) {
            int n = 0;
            while (symbolTable2.isLocalTable()) {
                ++n;
                symbolTable2 = PrivateUtils.symtabTree(ionSystem, symbolTable2).getSymbolTable();
            }
            assert (symbolTable2 != null);
            if (symbolTable == null || symbolTable.getIonVersionId().equals(symbolTable2.getIonVersionId())) {
                ++n;
            }
            return n;
        }
    }

    protected final class SystemContentIterator
    implements ListIterator<IonValue> {
        private final boolean __readOnly;
        private IonValueLite __current;
        private SystemIteratorPosition __pos;
        private SystemIteratorPosition __temp_pos;

        public SystemContentIterator(boolean bl) {
            if (IonDatagramLite.this._isLocked() && !bl) {
                throw new IllegalStateException("you can't open an updatable iterator on a read only value");
            }
            this.__readOnly = bl;
            this.__temp_pos = new SystemIteratorPosition(this);
            this.__pos = new SystemIteratorPosition(this);
            this.__pos.load_initial_position();
        }

        private IonSystem getSystem() {
            return IonDatagramLite.this.getSystem();
        }

        protected IonValueLite set_position(SystemIteratorPosition systemIteratorPosition) {
            this.__temp_pos = this.__pos;
            this.__pos = systemIteratorPosition;
            this.__current = this.__pos.load_position();
            return this.__current;
        }

        private void force_position_sync() {
            int n = this.__pos.__user_index;
            if (n < 0 || n >= IonDatagramLite.this._child_count) {
                return;
            }
            IonValueLite ionValueLite = this.__pos.__current_user_value;
            if (ionValueLite == null || ionValueLite == IonDatagramLite.this._children[n]) {
                return;
            }
            if (this.__readOnly) {
                throw new IonException("read only sequence was changed");
            }
            this.__pos.force_position_sync_helper();
        }

        @Override
        public void add(IonValue ionValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean hasNext() {
            return this.__pos.has_next();
        }

        @Override
        public IonValue next() {
            SystemIteratorPosition systemIteratorPosition = this.next_index_helper();
            if (systemIteratorPosition == null) {
                throw new NoSuchElementException();
            }
            IonValueLite ionValueLite = this.set_position(systemIteratorPosition);
            assert (ionValueLite == this.__current);
            return ionValueLite;
        }

        @Override
        public final int nextIndex() {
            SystemIteratorPosition systemIteratorPosition = this.next_index_helper();
            if (systemIteratorPosition == null) {
                return this.__pos.get_external_pos() + 1;
            }
            int n = systemIteratorPosition.get_external_pos();
            return n;
        }

        private final SystemIteratorPosition next_index_helper() {
            SystemIteratorPosition systemIteratorPosition = null;
            this.force_position_sync();
            if (!this.__pos.has_next()) {
                return null;
            }
            systemIteratorPosition = this.__temp_pos;
            assert (systemIteratorPosition != null && systemIteratorPosition != this.__pos);
            systemIteratorPosition.copyFrom(this.__pos);
            ++systemIteratorPosition.__local_index;
            if (systemIteratorPosition.__local_index < systemIteratorPosition.__local_value_count) {
                return systemIteratorPosition;
            }
            assert (systemIteratorPosition.__user_index <= IonDatagramLite.this.get_child_count());
            ++systemIteratorPosition.__user_index;
            systemIteratorPosition.load_updated_position();
            systemIteratorPosition.__local_index = 0;
            return systemIteratorPosition;
        }

        @Override
        public final boolean hasPrevious() {
            return this.__pos.has_prev();
        }

        @Override
        public IonValue previous() {
            SystemIteratorPosition systemIteratorPosition = this.previous_index_helper();
            if (systemIteratorPosition == null) {
                throw new NoSuchElementException();
            }
            IonValueLite ionValueLite = this.set_position(systemIteratorPosition);
            assert (ionValueLite == this.__current);
            return ionValueLite;
        }

        @Override
        public final int previousIndex() {
            SystemIteratorPosition systemIteratorPosition = this.previous_index_helper();
            if (systemIteratorPosition == null) {
                return -1;
            }
            int n = systemIteratorPosition.get_external_pos();
            return n;
        }

        private final SystemIteratorPosition previous_index_helper() {
            SystemIteratorPosition systemIteratorPosition = null;
            this.force_position_sync();
            if (!this.__pos.has_prev()) {
                return null;
            }
            systemIteratorPosition = this.__temp_pos;
            assert (systemIteratorPosition != null && systemIteratorPosition != this.__pos);
            systemIteratorPosition.copyFrom(this.__pos);
            --systemIteratorPosition.__local_index;
            if (systemIteratorPosition.__local_index >= 0) {
                return systemIteratorPosition;
            }
            assert (systemIteratorPosition.__user_index > 0);
            systemIteratorPosition.__index_adjustment -= systemIteratorPosition.__local_value_count;
            --systemIteratorPosition.__user_index;
            systemIteratorPosition.load_updated_position();
            systemIteratorPosition.__local_index = systemIteratorPosition.__local_value_count - 1;
            return systemIteratorPosition;
        }

        @Override
        public void remove() {
            if (this.__readOnly) {
                throw new UnsupportedOperationException();
            }
            this.force_position_sync();
            if (this.__current == null || this.__pos == null) {
                throw new NoSuchElementException();
            }
            if (this.__pos.on_system_value()) {
                throw new UnsupportedOperationException();
            }
            int n = this.__pos.__user_index;
            assert (n >= 0);
            IonValueLite ionValueLite = this.__current;
            int n2 = ionValueLite._elementid();
            assert (n2 == n);
            IonDatagramLite.this.remove_child(n);
            IonDatagramLite.this.patch_elements_helper(n2);
            this.__pos.__index_adjustment -= this.__pos.__local_value_count;
            if (this.__pos.__user_index < IonDatagramLite.this.get_child_count() - 1) {
                this.__pos.load_updated_position();
                this.__pos.__local_index = -1;
            }
            this.__current = null;
        }

        @Override
        public void set(IonValue ionValue) {
            throw new UnsupportedOperationException();
        }

        protected int get_datagram_child_count() {
            return IonDatagramLite.this.get_child_count();
        }

        protected IonValueLite get_datagram_child(int n) {
            return IonDatagramLite.this.get_child(n);
        }

        protected IonSystem get_datagram_system() {
            return IonDatagramLite.this._system;
        }

        protected boolean datagram_contains(IonValueLite ionValueLite) {
            return IonDatagramLite.this.contains(ionValueLite);
        }

        protected IonSymbolLite get_datagram_ivm() {
            return IonDatagramLite.this.get_ivm();
        }
    }
}

