/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.bin;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import software.amazon.ion.impl.bin.Block;
import software.amazon.ion.impl.bin.BlockAllocator;

final class WriteBuffer
implements Closeable {
    private final BlockAllocator allocator;
    private final List<Block> blocks;
    private Block current;
    private int index;
    private static final int OCTET_MASK = 255;
    private static final char HIGH_SURROGATE_FIRST = '\ud800';
    private static final char HIGH_SURROGATE_LAST = '\udbff';
    private static final char LOW_SURROGATE_FIRST = '\udc00';
    private static final char LOW_SURROGATE_LAST = '\udfff';
    private static final int SURROGATE_BASE = 65536;
    private static final int BITS_PER_SURROGATE = 10;
    private static final int UTF8_FOLLOW_MASK = 63;
    private static final int UTF8_FOLLOW_PREFIX_MASK = 128;
    private static final int UTF8_2_OCTET_PREFIX_MASK = 192;
    private static final int UTF8_3_OCTET_PREFIX_MASK = 224;
    private static final int UTF8_4_OCTET_PREFIX_MASK = 240;
    private static final int UTF8_BITS_PER_FOLLOW_OCTET = 6;
    private static final int UTF8_2_OCTET_SHIFT = 6;
    private static final int UTF8_3_OCTET_SHIFT = 12;
    private static final int UTF8_4_OCTET_SHIFT = 18;
    private static final int UTF8_2_OCTET_MIN_VALUE = 128;
    private static final int UTF8_3_OCTET_MIN_VALUE = 2048;
    private static final int UINT_2_OCTET_SHIFT = 8;
    private static final int UINT_3_OCTET_SHIFT = 16;
    private static final int UINT_4_OCTET_SHIFT = 24;
    private static final int UINT_5_OCTET_SHIFT = 32;
    private static final int UINT_6_OCTET_SHIFT = 40;
    private static final int UINT_7_OCTET_SHIFT = 48;
    private static final int UINT_8_OCTET_SHIFT = 56;
    private static final long INT8_SIGN_MASK = 128L;
    private static final long INT16_SIGN_MASK = 32768L;
    private static final long INT24_SIGN_MASK = 0x800000L;
    private static final long INT32_SIGN_MASK = 0x80000000L;
    private static final long INT40_SIGN_MASK = 0x8000000000L;
    private static final long INT48_SIGN_MASK = 0x800000000000L;
    private static final long INT56_SIGN_MASK = 0x80000000000000L;
    private static final long INT64_SIGN_MASK = Long.MIN_VALUE;
    private static final long VAR_INT_BITS_PER_OCTET = 7L;
    private static final long VAR_INT_MASK = 127L;
    private static final long VAR_UINT_9_OCTET_SHIFT = 56L;
    private static final long VAR_UINT_9_OCTET_MIN_VALUE = 0x100000000000000L;
    private static final long VAR_UINT_8_OCTET_SHIFT = 49L;
    private static final long VAR_UINT_8_OCTET_MIN_VALUE = 0x2000000000000L;
    private static final long VAR_UINT_7_OCTET_SHIFT = 42L;
    private static final long VAR_UINT_7_OCTET_MIN_VALUE = 0x40000000000L;
    private static final long VAR_UINT_6_OCTET_SHIFT = 35L;
    private static final long VAR_UINT_6_OCTET_MIN_VALUE = 0x800000000L;
    private static final long VAR_UINT_5_OCTET_SHIFT = 28L;
    private static final long VAR_UINT_5_OCTET_MIN_VALUE = 0x10000000L;
    private static final long VAR_UINT_4_OCTET_SHIFT = 21L;
    private static final long VAR_UINT_4_OCTET_MIN_VALUE = 0x200000L;
    private static final long VAR_UINT_3_OCTET_SHIFT = 14L;
    private static final long VAR_UINT_3_OCTET_MIN_VALUE = 16384L;
    private static final long VAR_UINT_2_OCTET_SHIFT = 7L;
    private static final long VAR_UINT_2_OCTET_MIN_VALUE = 128L;
    private static final long VAR_INT_FINAL_OCTET_SIGNAL_MASK = 128L;
    private static final long VAR_INT_SIGNED_OCTET_MASK = 63L;
    private static final long VAR_INT_SIGNBIT_ON_MASK = 64L;
    private static final long VAR_INT_SIGNBIT_OFF_MASK = 0L;
    private static final long VAR_INT_10_OCTET_SHIFT = 62L;
    private static final long VAR_INT_10_OCTET_MIN_VALUE = 0x4000000000000000L;
    private static final long VAR_INT_9_OCTET_MIN_VALUE = 0x80000000000000L;
    private static final long VAR_INT_8_OCTET_MIN_VALUE = 0x1000000000000L;
    private static final long VAR_INT_7_OCTET_MIN_VALUE = 0x20000000000L;
    private static final long VAR_INT_6_OCTET_MIN_VALUE = 0x400000000L;
    private static final long VAR_INT_5_OCTET_MIN_VALUE = 0x8000000L;
    private static final long VAR_INT_4_OCTET_MIN_VALUE = 0x100000L;
    private static final long VAR_INT_3_OCTET_MIN_VALUE = 8192L;
    private static final long VAR_INT_2_OCTET_MIN_VALUE = 64L;
    private static final long VAR_INT_BITS_PER_SIGNED_OCTET = 6L;
    private static final long VAR_SINT_2_OCTET_SHIFT = 13L;
    private static final long VAR_SINT_3_OCTET_SHIFT = 20L;
    private static final long VAR_SINT_4_OCTET_SHIFT = 27L;
    private static final long VAR_SINT_5_OCTET_SHIFT = 34L;

    public WriteBuffer(BlockAllocator blockAllocator) {
        this.allocator = blockAllocator;
        this.blocks = new ArrayList<Block>();
        this.allocateNewBlock();
        this.index = 0;
        this.current = this.blocks.get(0);
    }

    private void allocateNewBlock() {
        this.blocks.add(this.allocator.allocateBlock());
    }

    private int index(long l) {
        return (int)(l / (long)this.allocator.getBlockSize());
    }

    private int offset(long l) {
        return (int)(l % (long)this.allocator.getBlockSize());
    }

    public void reset() {
        this.close();
        this.allocateNewBlock();
        this.index = 0;
        this.current = this.blocks.get(this.index);
    }

    @Override
    public void close() {
        for (Block block : this.blocks) {
            block.close();
        }
        this.blocks.clear();
    }

    public void truncate(long l) {
        int n = this.index(l);
        int n2 = this.offset(l);
        Block block = this.blocks.get(n);
        this.index = n;
        block.limit = n2;
        this.current = block;
    }

    public int remaining() {
        return this.current.remaining();
    }

    public long position() {
        return (long)this.index * (long)this.allocator.getBlockSize() + (long)this.current.limit;
    }

    public int getUInt8At(long l) {
        int n = this.index(l);
        int n2 = this.offset(l);
        Block block = this.blocks.get(n);
        return block.data[n2] & 0xFF;
    }

    public void writeByte(byte by) {
        if (this.remaining() < 1) {
            if (this.index == this.blocks.size() - 1) {
                this.allocateNewBlock();
            }
            ++this.index;
            this.current = this.blocks.get(this.index);
        }
        Block block = this.current;
        block.data[block.limit] = by;
        ++block.limit;
    }

    private void writeBytesSlow(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            Block block = this.current;
            int n3 = Math.min(n2, block.remaining());
            System.arraycopy(byArray, n, block.data, block.limit, n3);
            block.limit += n3;
            n += n3;
            n2 -= n3;
            if (block.remaining() != 0) continue;
            if (this.index == this.blocks.size() - 1) {
                this.allocateNewBlock();
            }
            ++this.index;
            this.current = this.blocks.get(this.index);
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) {
        if (n2 > this.remaining()) {
            this.writeBytesSlow(byArray, n, n2);
            return;
        }
        Block block = this.current;
        System.arraycopy(byArray, n, block.data, block.limit, n2);
        block.limit += n2;
    }

    public void writeBytes(byte[] byArray) {
        this.writeBytes(byArray, 0, byArray.length);
    }

    private int writeUTF8Slow(CharSequence charSequence, int n, int n2) {
        int n3 = 0;
        while (n2 > 0) {
            char c = charSequence.charAt(n);
            if (c >= '\udc00' && c <= '\udfff') {
                throw new IllegalArgumentException("Unpaired low surrogate: " + c);
            }
            if (c >= '\ud800' && c <= '\udbff') {
                ++n;
                if (--n2 == 0) {
                    throw new IllegalArgumentException("Unpaired low surrogate at end of character sequence: " + c);
                }
                char c2 = charSequence.charAt(n);
                if (c2 < '\udc00' || c2 > '\udfff') {
                    throw new IllegalArgumentException("Low surrogate with unpaired high surrogate: " + c + " + " + c2);
                }
                int n4 = (c - 55296 << 10 | c2 - 56320) + 65536;
                this.writeByte((byte)(0xF0 | n4 >> 18));
                this.writeByte((byte)(0x80 | n4 >> 12 & 0x3F));
                this.writeByte((byte)(0x80 | n4 >> 6 & 0x3F));
                this.writeByte((byte)(0x80 | n4 & 0x3F));
                n3 += 4;
            } else if (c < '\u0080') {
                this.writeByte((byte)c);
                ++n3;
            } else if (c < '\u0800') {
                this.writeByte((byte)(0xC0 | c >> 6));
                this.writeByte((byte)(0x80 | c & 0x3F));
                n3 += 2;
            } else {
                this.writeByte((byte)(0xE0 | c >> 12));
                this.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte((byte)(0x80 | c & 0x3F));
                n3 += 3;
            }
            ++n;
            --n2;
        }
        return n3;
    }

    private int writeUTF8UpTo3Byte(CharSequence charSequence, int n, int n2) {
        if (n2 * 3 > this.remaining()) {
            return this.writeUTF8Slow(charSequence, n, n2);
        }
        Block block = this.current;
        int n3 = block.limit;
        int n4 = 0;
        while (n2 > 0) {
            char c = charSequence.charAt(n);
            if (c >= '\udc00' && c <= '\udfff') {
                throw new IllegalArgumentException("Unpaired low surrogate: " + c);
            }
            if (c >= '\ud800' && c <= '\udbff') break;
            if (c < '\u0080') {
                block.data[n3++] = (byte)c;
                ++n4;
            } else if (c < '\u0800') {
                block.data[n3++] = (byte)(0xC0 | c >> 6);
                block.data[n3++] = (byte)(0x80 | c & 0x3F);
                n4 += 2;
            } else {
                block.data[n3++] = (byte)(0xE0 | c >> 12);
                block.data[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                block.data[n3++] = (byte)(0x80 | c & 0x3F);
                n4 += 3;
            }
            ++n;
            --n2;
        }
        block.limit = n3;
        if (n2 > 0) {
            return n4 + this.writeUTF8Slow(charSequence, n, n2);
        }
        return n4;
    }

    private int writeUTF8UpTo2Byte(CharSequence charSequence, int n, int n2) {
        if (n2 * 2 > this.remaining()) {
            return this.writeUTF8Slow(charSequence, n, n2);
        }
        Block block = this.current;
        int n3 = block.limit;
        char c = '\u0000';
        int n4 = 0;
        while (n2 > 0 && (c = charSequence.charAt(n)) < '\u0800') {
            if (c < '\u0080') {
                block.data[n3++] = (byte)c;
                ++n4;
            } else {
                block.data[n3++] = (byte)(0xC0 | c >> 6);
                block.data[n3++] = (byte)(0x80 | c & 0x3F);
                n4 += 2;
            }
            ++n;
            --n2;
        }
        block.limit = n3;
        if (n2 > 0) {
            if (c >= '\udc00' && c <= '\udfff') {
                throw new IllegalArgumentException("Unpaired low surrogate: " + c);
            }
            if (c >= '\ud800' && c <= '\udbff') {
                return n4 + this.writeUTF8Slow(charSequence, n, n2);
            }
            return n4 + this.writeUTF8UpTo3Byte(charSequence, n, n2);
        }
        return n4;
    }

    public int writeUTF8(CharSequence charSequence, int n, int n2) {
        if (n2 > this.remaining()) {
            return this.writeUTF8Slow(charSequence, n, n2);
        }
        Block block = this.current;
        int n3 = block.limit;
        char c = '\u0000';
        int n4 = 0;
        while (n2 > 0 && (c = charSequence.charAt(n)) < '\u0080') {
            block.data[n3++] = (byte)c;
            ++n4;
            ++n;
            --n2;
        }
        block.limit = n3;
        if (n2 > 0) {
            if (c < '\u0800') {
                return n4 + this.writeUTF8UpTo2Byte(charSequence, n, n2);
            }
            if (c >= '\udc00' && c <= '\udfff') {
                throw new IllegalArgumentException("Unpaired low surrogate: " + c);
            }
            if (c >= '\ud800' && c <= '\udbff') {
                return n4 + this.writeUTF8Slow(charSequence, n, n2);
            }
            return n4 + this.writeUTF8UpTo3Byte(charSequence, n, n2);
        }
        return n4;
    }

    public int writeUTF8(CharSequence charSequence) {
        return this.writeUTF8(charSequence, 0, charSequence.length());
    }

    public void writeUInt8(long l) {
        this.writeByte((byte)l);
    }

    private void writeUInt16Slow(long l) {
        this.writeByte((byte)(l >> 8));
        this.writeByte((byte)l);
    }

    public void writeUInt16(long l) {
        if (this.remaining() < 2) {
            this.writeUInt16Slow(l);
            return;
        }
        Block block = this.current;
        byte[] byArray = block.data;
        int n = block.limit;
        byArray[n++] = (byte)(l >> 8);
        byArray[n++] = (byte)l;
        block.limit = n;
    }

    private void writeUInt24Slow(long l) {
        this.writeByte((byte)(l >> 16));
        this.writeByte((byte)(l >> 8));
        this.writeByte((byte)l);
    }

    public void writeUInt24(long l) {
        if (this.remaining() < 3) {
            this.writeUInt24Slow(l);
            return;
        }
        Block block = this.current;
        byte[] byArray = block.data;
        int n = block.limit;
        byArray[n++] = (byte)(l >> 16);
        byArray[n++] = (byte)(l >> 8);
        byArray[n++] = (byte)l;
        block.limit = n;
    }

    private void writeUInt32Slow(long l) {
        this.writeByte((byte)(l >> 24));
        this.writeByte((byte)(l >> 16));
        this.writeByte((byte)(l >> 8));
        this.writeByte((byte)l);
    }

    public void writeUInt32(long l) {
        if (this.remaining() < 4) {
            this.writeUInt32Slow(l);
            return;
        }
        Block block = this.current;
        byte[] byArray = block.data;
        int n = block.limit;
        byArray[n++] = (byte)(l >> 24);
        byArray[n++] = (byte)(l >> 16);
        byArray[n++] = (byte)(l >> 8);
        byArray[n++] = (byte)l;
        block.limit = n;
    }

    private void writeUInt40Slow(long l) {
        this.writeByte((byte)(l >> 32));
        this.writeByte((byte)(l >> 24));
        this.writeByte((byte)(l >> 16));
        this.writeByte((byte)(l >> 8));
        this.writeByte((byte)l);
    }

    public void writeUInt40(long l) {
        if (this.remaining() < 5) {
            this.writeUInt40Slow(l);
            return;
        }
        Block block = this.current;
        byte[] byArray = block.data;
        int n = block.limit;
        byArray[n++] = (byte)(l >> 32);
        byArray[n++] = (byte)(l >> 24);
        byArray[n++] = (byte)(l >> 16);
        byArray[n++] = (byte)(l >> 8);
        byArray[n++] = (byte)l;
        block.limit = n;
    }

    private void writeUInt48Slow(long l) {
        this.writeByte((byte)(l >> 40));
        this.writeByte((byte)(l >> 32));
        this.writeByte((byte)(l >> 24));
        this.writeByte((byte)(l >> 16));
        this.writeByte((byte)(l >> 8));
        this.writeByte((byte)l);
    }

    public void writeUInt48(long l) {
        if (this.remaining() < 6) {
            this.writeUInt48Slow(l);
            return;
        }
        Block block = this.current;
        byte[] byArray = block.data;
        int n = block.limit;
        byArray[n++] = (byte)(l >> 40);
        byArray[n++] = (byte)(l >> 32);
        byArray[n++] = (byte)(l >> 24);
        byArray[n++] = (byte)(l >> 16);
        byArray[n++] = (byte)(l >> 8);
        byArray[n++] = (byte)l;
        block.limit = n;
    }

    private void writeUInt56Slow(long l) {
        this.writeByte((byte)(l >> 48));
        this.writeByte((byte)(l >> 40));
        this.writeByte((byte)(l >> 32));
        this.writeByte((byte)(l >> 24));
        this.writeByte((byte)(l >> 16));
        this.writeByte((byte)(l >> 8));
        this.writeByte((byte)l);
    }

    public void writeUInt56(long l) {
        if (this.remaining() < 7) {
            this.writeUInt56Slow(l);
            return;
        }
        Block block = this.current;
        byte[] byArray = block.data;
        int n = block.limit;
        byArray[n++] = (byte)(l >> 48);
        byArray[n++] = (byte)(l >> 40);
        byArray[n++] = (byte)(l >> 32);
        byArray[n++] = (byte)(l >> 24);
        byArray[n++] = (byte)(l >> 16);
        byArray[n++] = (byte)(l >> 8);
        byArray[n++] = (byte)l;
        block.limit = n;
    }

    private void writeUInt64Slow(long l) {
        this.writeByte((byte)(l >> 56));
        this.writeByte((byte)(l >> 48));
        this.writeByte((byte)(l >> 40));
        this.writeByte((byte)(l >> 32));
        this.writeByte((byte)(l >> 24));
        this.writeByte((byte)(l >> 16));
        this.writeByte((byte)(l >> 8));
        this.writeByte((byte)l);
    }

    public void writeUInt64(long l) {
        if (this.remaining() < 8) {
            this.writeUInt64Slow(l);
            return;
        }
        Block block = this.current;
        byte[] byArray = block.data;
        int n = block.limit;
        byArray[n++] = (byte)(l >> 56);
        byArray[n++] = (byte)(l >> 48);
        byArray[n++] = (byte)(l >> 40);
        byArray[n++] = (byte)(l >> 32);
        byArray[n++] = (byte)(l >> 24);
        byArray[n++] = (byte)(l >> 16);
        byArray[n++] = (byte)(l >> 8);
        byArray[n++] = (byte)l;
        block.limit = n;
    }

    public void writeInt8(long l) {
        if (l < 0L) {
            l = -l | 0x80L;
        }
        this.writeUInt8(l);
    }

    public void writeInt16(long l) {
        if (l < 0L) {
            l = -l | 0x8000L;
        }
        this.writeUInt16(l);
    }

    public void writeInt24(long l) {
        if (l < 0L) {
            l = -l | 0x800000L;
        }
        this.writeUInt24(l);
    }

    public void writeInt32(long l) {
        if (l < 0L) {
            l = -l | 0x80000000L;
        }
        this.writeUInt32(l);
    }

    public void writeInt40(long l) {
        if (l < 0L) {
            l = -l | 0x8000000000L;
        }
        this.writeUInt40(l);
    }

    public void writeInt48(long l) {
        if (l < 0L) {
            l = -l | 0x800000000000L;
        }
        this.writeUInt48(l);
    }

    public void writeInt56(long l) {
        if (l < 0L) {
            l = -l | 0x80000000000000L;
        }
        this.writeUInt56(l);
    }

    public void writeInt64(long l) {
        if (l < 0L) {
            l = -l | Long.MIN_VALUE;
        }
        this.writeUInt64(l);
    }

    private int writeVarUIntSlow(long l) {
        int n = 1;
        if (l >= 0x100000000000000L) {
            this.writeUInt8(l >> 56 & 0x7FL);
            ++n;
        }
        if (l >= 0x2000000000000L) {
            this.writeUInt8(l >> 49 & 0x7FL);
            ++n;
        }
        if (l >= 0x40000000000L) {
            this.writeUInt8(l >> 42 & 0x7FL);
            ++n;
        }
        if (l >= 0x800000000L) {
            this.writeUInt8(l >> 35 & 0x7FL);
            ++n;
        }
        if (l >= 0x10000000L) {
            this.writeUInt8(l >> 28 & 0x7FL);
            ++n;
        }
        if (l >= 0x200000L) {
            this.writeUInt8(l >> 21 & 0x7FL);
            ++n;
        }
        if (l >= 16384L) {
            this.writeUInt8(l >> 14 & 0x7FL);
            ++n;
        }
        if (l >= 128L) {
            this.writeUInt8(l >> 7 & 0x7FL);
            ++n;
        }
        this.writeUInt8(l & 0x7FL | 0x80L);
        return n;
    }

    private int writeVarUIntDirect2(long l) {
        Block block = this.current;
        byte[] byArray = block.data;
        int n = block.limit;
        byArray[n++] = (byte)(l >> 7 & 0x7FL);
        byArray[n++] = (byte)(l & 0x7FL | 0x80L);
        block.limit = n;
        return 2;
    }

    private int writeVarUIntDirect3(long l) {
        Block block = this.current;
        byte[] byArray = block.data;
        int n = block.limit;
        byArray[n++] = (byte)(l >> 14 & 0x7FL);
        byArray[n++] = (byte)(l >> 7 & 0x7FL);
        byArray[n++] = (byte)(l & 0x7FL | 0x80L);
        block.limit = n;
        return 3;
    }

    private int writeVarUIntDirect4(long l) {
        Block block = this.current;
        byte[] byArray = block.data;
        int n = block.limit;
        byArray[n++] = (byte)(l >> 21 & 0x7FL);
        byArray[n++] = (byte)(l >> 14 & 0x7FL);
        byArray[n++] = (byte)(l >> 7 & 0x7FL);
        byArray[n++] = (byte)(l & 0x7FL | 0x80L);
        block.limit = n;
        return 4;
    }

    private int writeVarUIntDirect5(long l) {
        Block block = this.current;
        byte[] byArray = block.data;
        int n = block.limit;
        byArray[n++] = (byte)(l >> 28 & 0x7FL);
        byArray[n++] = (byte)(l >> 21 & 0x7FL);
        byArray[n++] = (byte)(l >> 14 & 0x7FL);
        byArray[n++] = (byte)(l >> 7 & 0x7FL);
        byArray[n++] = (byte)(l & 0x7FL | 0x80L);
        block.limit = n;
        return 5;
    }

    public int writeVarUInt(long l) {
        if (l < 128L) {
            this.writeUInt8(l & 0x7FL | 0x80L);
            return 1;
        }
        if (l < 16384L) {
            if (this.remaining() < 2) {
                return this.writeVarUIntSlow(l);
            }
            return this.writeVarUIntDirect2(l);
        }
        if (l < 0x200000L) {
            if (this.remaining() < 3) {
                return this.writeVarUIntSlow(l);
            }
            return this.writeVarUIntDirect3(l);
        }
        if (l < 0x10000000L) {
            if (this.remaining() < 4) {
                return this.writeVarUIntSlow(l);
            }
            return this.writeVarUIntDirect4(l);
        }
        if (l < 0x800000000L) {
            if (this.remaining() < 5) {
                return this.writeVarUIntSlow(l);
            }
            return this.writeVarUIntDirect5(l);
        }
        return this.writeVarUIntSlow(l);
    }

    private int writeVarIntSlow(long l, long l2) {
        long l3;
        int n = 1;
        if (l >= 0x4000000000000000L) {
            this.writeUInt8(l >> 62 & 0x3FL | l2);
            ++n;
        }
        if (l >= 0x80000000000000L) {
            l3 = l >> 56;
            this.writeUInt8(n == 1 ? l3 & 0x3FL | l2 : l3 & 0x7FL);
            ++n;
        }
        if (l >= 0x1000000000000L) {
            l3 = l >> 49;
            this.writeUInt8(n == 1 ? l3 & 0x3FL | l2 : l3 & 0x7FL);
            ++n;
        }
        if (l >= 0x20000000000L) {
            l3 = l >> 42;
            this.writeUInt8(n == 1 ? l3 & 0x3FL | l2 : l3 & 0x7FL);
            ++n;
        }
        if (l >= 0x400000000L) {
            l3 = l >> 35;
            this.writeUInt8(n == 1 ? l3 & 0x3FL | l2 : l3 & 0x7FL);
            ++n;
        }
        if (l >= 0x8000000L) {
            l3 = l >> 28;
            this.writeUInt8(n == 1 ? l3 & 0x3FL | l2 : l3 & 0x7FL);
            ++n;
        }
        if (l >= 0x100000L) {
            l3 = l >> 21;
            this.writeUInt8(n == 1 ? l3 & 0x3FL | l2 : l3 & 0x7FL);
            ++n;
        }
        if (l >= 8192L) {
            l3 = l >> 14;
            this.writeUInt8(n == 1 ? l3 & 0x3FL | l2 : l3 & 0x7FL);
            ++n;
        }
        if (l >= 64L) {
            l3 = l >> 7;
            this.writeUInt8(n == 1 ? l3 & 0x3FL | l2 : l3 & 0x7FL);
            ++n;
        }
        this.writeUInt8((n == 1 ? l & 0x3FL | l2 : l & 0x7FL) | 0x80L);
        return n;
    }

    public int writeVarInt(long l) {
        long l2;
        assert (l != Long.MIN_VALUE);
        long l3 = l < 0L ? 64L : 0L;
        long l4 = l2 = l < 0L ? -l : l;
        if (l2 < 64L) {
            this.writeUInt8(l2 & 0x3FL | 0x80L | l3);
            return 1;
        }
        long l5 = l < 0L ? 1L : 0L;
        int n = this.remaining();
        if (l2 < 8192L && n >= 2) {
            return this.writeVarUIntDirect2(l2 | l5 << 13);
        }
        if (l2 < 0x100000L && n >= 3) {
            return this.writeVarUIntDirect3(l2 | l5 << 20);
        }
        if (l2 < 0x8000000L && n >= 4) {
            return this.writeVarUIntDirect4(l2 | l5 << 27);
        }
        if (l2 < 0x400000000L && n >= 5) {
            return this.writeVarUIntDirect5(l2 | l5 << 34);
        }
        return this.writeVarIntSlow(l2, l3);
    }

    public void writeVarUIntDirect1At(long l, long l2) {
        this.writeUInt8At(l, l2 & 0x7FL | 0x80L);
    }

    private void writeVarUIntDirect2StraddlingAt(int n, int n2, long l) {
        Block block = this.blocks.get(n);
        block.data[n2] = (byte)(l >> 7 & 0x7FL);
        Block block2 = this.blocks.get(n + 1);
        block2.data[0] = (byte)(l & 0x7FL | 0x80L);
    }

    public void writeVarUIntDirect2At(long l, long l2) {
        int n = this.index(l);
        int n2 = this.offset(l);
        if (n2 + 2 > this.allocator.getBlockSize()) {
            this.writeVarUIntDirect2StraddlingAt(n, n2, l2);
            return;
        }
        Block block = this.blocks.get(n);
        block.data[n2] = (byte)(l2 >> 7 & 0x7FL);
        block.data[n2 + 1] = (byte)(l2 & 0x7FL | 0x80L);
    }

    public void writeUInt8At(long l, long l2) {
        int n = this.index(l);
        int n2 = this.offset(l);
        Block block = this.blocks.get(n);
        block.data[n2] = (byte)l2;
    }

    public void writeTo(OutputStream outputStream2) throws IOException {
        for (Block block : this.blocks) {
            outputStream2.write(block.data, 0, block.limit);
        }
    }

    public void writeTo(OutputStream outputStream2, long l, long l2) throws IOException {
        while (l2 > 0L) {
            int n = this.index(l);
            int n2 = this.offset(l);
            Block block = this.blocks.get(n);
            int n3 = (int)Math.min((long)(block.data.length - n2), l2);
            outputStream2.write(block.data, n2, n3);
            l += (long)n3;
            l2 -= (long)n3;
        }
    }
}

