/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.bin;

import java.io.IOException;
import java.math.BigInteger;
import software.amazon.ion.Decimal;
import software.amazon.ion.IonDatagram;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.Timestamp;
import software.amazon.ion.impl.PrivateByteTransferReader;
import software.amazon.ion.impl.PrivateByteTransferSink;
import software.amazon.ion.impl.PrivateIonWriter;
import software.amazon.ion.impl.PrivateSymtabExtendsCache;
import software.amazon.ion.impl.PrivateUtils;

abstract class AbstractIonWriter
implements PrivateByteTransferSink,
PrivateIonWriter {
    private final PrivateSymtabExtendsCache symtabExtendsCache;

    AbstractIonWriter(WriteValueOptimization writeValueOptimization) {
        this.symtabExtendsCache = writeValueOptimization == WriteValueOptimization.COPY_OPTIMIZED ? new PrivateSymtabExtendsCache() : null;
    }

    public final void writeValue(IonValue ionValue) throws IOException {
        if (ionValue != null) {
            if (ionValue instanceof IonDatagram) {
                this.finish();
            }
            ionValue.writeTo(this);
        }
    }

    @Override
    public final void writeValue(IonReader ionReader) throws IOException {
        PrivateByteTransferReader privateByteTransferReader;
        IonType ionType = ionReader.getType();
        if (this.isStreamCopyOptimized() && (privateByteTransferReader = ionReader.asFacet(PrivateByteTransferReader.class)) != null && (PrivateUtils.isNonSymbolScalar(ionType) || this.symtabExtendsCache.symtabsCompat(this.getSymbolTable(), ionReader.getSymbolTable()))) {
            privateByteTransferReader.transferCurrentValue(this);
            return;
        }
        this.writeValueRecursive(ionReader);
    }

    public final void writeValueRecursive(IonReader ionReader) throws IOException {
        SymbolToken[] symbolTokenArray;
        IonType ionType = ionReader.getType();
        SymbolToken symbolToken = ionReader.getFieldNameSymbol();
        if (symbolToken != null && !this.isFieldNameSet() && this.isInStruct()) {
            this.setFieldNameSymbol(symbolToken);
        }
        if ((symbolTokenArray = ionReader.getTypeAnnotationSymbols()).length > 0) {
            this.setTypeAnnotationSymbols(symbolTokenArray);
        }
        if (ionReader.isNullValue()) {
            this.writeNull(ionType);
            return;
        }
        block0 : switch (ionType) {
            case BOOL: {
                boolean bl = ionReader.booleanValue();
                this.writeBool(bl);
                break;
            }
            case INT: {
                switch (ionReader.getIntegerSize()) {
                    case INT: {
                        int n = ionReader.intValue();
                        this.writeInt(n);
                        break block0;
                    }
                    case LONG: {
                        long l = ionReader.longValue();
                        this.writeInt(l);
                        break block0;
                    }
                    case BIG_INTEGER: {
                        BigInteger bigInteger = ionReader.bigIntegerValue();
                        this.writeInt(bigInteger);
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case FLOAT: {
                double d = ionReader.doubleValue();
                this.writeFloat(d);
                break;
            }
            case DECIMAL: {
                Decimal decimal = ionReader.decimalValue();
                this.writeDecimal(decimal);
                break;
            }
            case TIMESTAMP: {
                Timestamp timestamp = ionReader.timestampValue();
                this.writeTimestamp(timestamp);
                break;
            }
            case SYMBOL: {
                SymbolToken symbolToken2 = ionReader.symbolValue();
                this.writeSymbolToken(symbolToken2);
                break;
            }
            case STRING: {
                String string = ionReader.stringValue();
                this.writeString(string);
                break;
            }
            case CLOB: {
                byte[] byArray = ionReader.newBytes();
                this.writeClob(byArray);
                break;
            }
            case BLOB: {
                byte[] byArray = ionReader.newBytes();
                this.writeBlob(byArray);
                break;
            }
            case LIST: 
            case SEXP: 
            case STRUCT: {
                ionReader.stepIn();
                this.stepIn(ionType);
                while (ionReader.next() != null) {
                    this.writeValue(ionReader);
                }
                this.stepOut();
                ionReader.stepOut();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type: " + (Object)((Object)ionType));
            }
        }
    }

    @Override
    public final void writeValues(IonReader ionReader) throws IOException {
        if (ionReader.getType() != null) {
            this.writeValue(ionReader);
        }
        while (ionReader.next() != null) {
            this.writeValue(ionReader);
        }
    }

    @Override
    public final boolean isStreamCopyOptimized() {
        return this.symtabExtendsCache != null;
    }

    static enum WriteValueOptimization {
        NONE,
        COPY_OPTIMIZED;

    }
}

