/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import software.amazon.ion.impl.UnifiedDataPageX;
import software.amazon.ion.impl.UnifiedInputBufferX;
import software.amazon.ion.impl.UnifiedInputStreamX;

final class UnifiedSavePointManagerX {
    private static final int FREE_LIST_LIMIT = 20;
    UnifiedInputStreamX _stream;
    UnifiedInputBufferX _buffer;
    SavePoint _inuse;
    SavePoint _free;
    int _free_count;
    SavePoint _active_stack;
    int _open_save_points;

    public UnifiedSavePointManagerX(UnifiedInputStreamX unifiedInputStreamX) {
        this._stream = unifiedInputStreamX;
        this._buffer = unifiedInputStreamX._buffer;
        this._inuse = null;
        this._free = null;
        this._active_stack = null;
    }

    public final boolean isSavePointOpen() {
        return this._open_save_points > 0;
    }

    public final long lengthOf(SavePoint savePoint) {
        long l;
        int n = savePoint.getStartIdx();
        int n2 = savePoint.getEndIdx();
        if (n == -1 || n2 == -1) {
            return 0L;
        }
        if (n == n2) {
            int n3 = savePoint.getStartPos();
            int n4 = savePoint.getEndPos();
            l = n4 - n3;
        } else {
            UnifiedDataPageX unifiedDataPageX = this._buffer.getPage(n);
            UnifiedDataPageX unifiedDataPageX2 = this._buffer.getPage(n2);
            long l2 = unifiedDataPageX.getFilePosition(savePoint.getStartPos());
            long l3 = unifiedDataPageX2.getFilePosition(savePoint.getEndPos());
            l = l3 - l2;
        }
        return l;
    }

    public final SavePoint savePointAllocate() {
        SavePoint savePoint;
        if (this._free != null) {
            savePoint = this._free;
            this._free = savePoint._next;
            --this._free_count;
            savePoint.clear();
        } else {
            savePoint = new SavePoint(this);
        }
        savePoint._next = this._inuse;
        savePoint._prev = null;
        if (this._inuse != null) {
            this._inuse._prev = savePoint;
        } else {
            this._inuse = savePoint;
        }
        return savePoint;
    }

    public final void savePointFree(SavePoint savePoint) {
        assert (savePoint.isClear());
        if (this._free_count >= 20) {
            return;
        }
        if (savePoint._prev == null) {
            savePoint._prev = savePoint._next;
        } else {
            this._inuse = savePoint._next;
        }
        if (savePoint._next != null) {
            savePoint._next._prev = savePoint._prev;
        }
        savePoint._next = this._free;
        this._free = savePoint;
        ++this._free_count;
    }

    public final SavePoint savePointActiveTop() {
        return this._active_stack;
    }

    public final void savePointPushActive(SavePoint savePoint, long l, long l2) {
        assert (!savePoint.isActive());
        int n = this._buffer.getCurrentPageIdx();
        int n2 = this._stream._pos;
        int n3 = this._stream._limit;
        UnifiedDataPageX unifiedDataPageX = this._buffer.getPage(n);
        savePoint.set_prev_pos(n, n2, n3, l, l2);
        savePoint._next_active = this._active_stack;
        this._active_stack = savePoint;
        savePoint.set_active();
        n = savePoint.getStartIdx();
        n2 = savePoint.getStartPos();
        unifiedDataPageX = this._buffer.getPage(n);
        n3 = savePoint.getEndIdx() != savePoint.getStartIdx() ? unifiedDataPageX.getBufferLimit() : savePoint.getEndPos();
        this._stream.make_page_current(unifiedDataPageX, n, n2, n3);
    }

    public final void savePointPopActive(SavePoint savePoint) {
        if (savePoint != this._active_stack) {
            throw new IllegalArgumentException("save point being released isn't currently active");
        }
        this._active_stack = savePoint._next_active;
        savePoint._next_active = null;
        savePoint.set_inactive();
        this._stream.save_point_reset_to_prev(savePoint);
    }

    private void save_point_clear(SavePoint savePoint) {
        if (savePoint.isClear()) {
            return;
        }
        int n = savePoint.getStartIdx();
        int n2 = savePoint.getEndIdx();
        if ((n2 != -1 || n != -1) && n != -1) {
            --this._open_save_points;
            this.save_point_unpin(savePoint);
        }
    }

    private final void save_point_unpin(SavePoint savePoint) {
        if (savePoint.isActive()) {
            throw new IllegalArgumentException("you can't release an active save point");
        }
        assert (savePoint.isDefined());
        if (this._buffer.decLock() && this._open_save_points == 0) {
            this._buffer.resetToCurrentPage();
        }
    }

    private final SavePoint save_point_start(SavePoint savePoint, long l, long l2) {
        if (savePoint.isDefined()) {
            throw new IllegalArgumentException("you can't start an active save point");
        }
        int n = this._buffer.getCurrentPageIdx();
        this._buffer.incLock();
        savePoint.set_start_pos(n, this._stream._pos, l, l2);
        ++this._open_save_points;
        return savePoint;
    }

    private final void save_point_mark_end(SavePoint savePoint, int n) {
        if (savePoint.isActive()) {
            throw new IllegalArgumentException("you can't start an active save point");
        }
        UnifiedDataPageX unifiedDataPageX = this._buffer.getCurrentPage();
        int n2 = this._buffer.getCurrentPageIdx();
        int n3 = this._stream._pos + n;
        if (n != 0) {
            if (n3 >= unifiedDataPageX.getBufferLimit()) {
                n3 -= unifiedDataPageX.getOriginalStartingOffset();
                unifiedDataPageX = this._buffer.getPage(++n2);
            } else if (n3 < unifiedDataPageX.getStartingOffset()) {
                int n4 = n3 - unifiedDataPageX.getOriginalStartingOffset();
                unifiedDataPageX = this._buffer.getPage(--n2);
                n3 = unifiedDataPageX.getBufferLimit() - n4;
            }
            if (unifiedDataPageX == null || n3 >= unifiedDataPageX.getBufferLimit() || n3 < unifiedDataPageX.getStartingOffset()) {
                this.end_point_too_far(n2);
            }
        }
        savePoint.set_end_pos(n2, n3);
    }

    private final void end_point_too_far(int n) {
        String string = "end point [" + n + "] must be within 1 page of current [" + this._buffer.getCurrentPageIdx() + "]";
        throw new IllegalArgumentException(string);
    }

    public static class SavePoint {
        private UnifiedSavePointManagerX _owner;
        private SavePointState _state;
        private int _start_idx;
        private int _start_pos;
        private long _start_line_count;
        private long _start_line_start;
        private int _end_idx;
        private int _end_pos;
        private int _prev_idx;
        private int _prev_pos;
        private int _prev_limit;
        private long _prev_line_count;
        private long _prev_line_start;
        private SavePoint _next;
        private SavePoint _prev;
        private SavePoint _next_active;

        SavePoint(UnifiedSavePointManagerX unifiedSavePointManagerX) {
            this.clear();
            this._owner = unifiedSavePointManagerX;
        }

        private final void set_start_pos(int n, int n2, long l, long l2) {
            assert (this._state == SavePointState.CLEAR);
            this._state = SavePointState.DEFINED;
            this._start_idx = n;
            this._start_pos = n2;
            this._start_line_count = l;
            this._start_line_start = l2;
        }

        private final void set_end_pos(int n, int n2) {
            assert (this._state == SavePointState.DEFINED);
            this._end_idx = n;
            this._end_pos = n2;
        }

        private final void set_prev_pos(int n, int n2, int n3, long l, long l2) {
            assert (this._state == SavePointState.DEFINED);
            this._prev_idx = n;
            this._prev_pos = n2;
            this._prev_limit = n3;
            this._prev_line_count = l;
            this._prev_line_start = l2;
        }

        public final void clear() {
            assert (this._state != SavePointState.ACTIVE);
            if (this.isDefined()) {
                this._owner.save_point_clear(this);
            }
            this._state = SavePointState.CLEAR;
            this._start_idx = -1;
            this._end_idx = -1;
            this._prev_idx = -1;
        }

        public final void start(long l, long l2) {
            this._owner.save_point_start(this, l, l2);
        }

        public final void markEnd() {
            this._owner.save_point_mark_end(this, 0);
        }

        public final void markEnd(int n) {
            this._owner.save_point_mark_end(this, n);
        }

        public final void free() {
            this._owner.savePointFree(this);
        }

        public final boolean isClear() {
            return this._state == SavePointState.CLEAR;
        }

        public final boolean isDefined() {
            return this._state == SavePointState.DEFINED || this._state == SavePointState.ACTIVE;
        }

        public final boolean isActive() {
            return this._state == SavePointState.ACTIVE;
        }

        public final void set_active() {
            assert (this._state == SavePointState.DEFINED);
            this._state = SavePointState.ACTIVE;
        }

        public final void set_inactive() {
            assert (this._state == SavePointState.ACTIVE);
            this._state = SavePointState.DEFINED;
        }

        public final long length() {
            if (this._start_idx == -1 || this._end_idx == -1) {
                return 0L;
            }
            return this._owner.lengthOf(this);
        }

        public final int getStartIdx() {
            return this._start_idx;
        }

        public final int getStartPos() {
            assert (this._state != SavePointState.CLEAR);
            return this._start_pos;
        }

        public final long getStartLineNumber() {
            return this._start_line_count;
        }

        public final long getStartLineStart() {
            return this._start_line_start;
        }

        public final long getStartFilePosition() {
            if (this._start_idx == -1) {
                return -1L;
            }
            UnifiedDataPageX unifiedDataPageX = this._owner._buffer.getPage(this._start_idx);
            return unifiedDataPageX.getFilePosition(this._start_pos);
        }

        public final int getEndIdx() {
            return this._end_idx;
        }

        public final int getEndPos() {
            assert (this._state != SavePointState.CLEAR);
            return this._end_pos;
        }

        public final long getEndFilePosition() {
            assert (this._state != SavePointState.CLEAR);
            if (this._end_idx == -1) {
                return -1L;
            }
            UnifiedDataPageX unifiedDataPageX = this._owner._buffer.getPage(this._end_idx);
            return unifiedDataPageX.getFilePosition(this._end_pos);
        }

        public final int getPrevIdx() {
            return this._prev_idx;
        }

        public final int getPrevPos() {
            assert (this._state != SavePointState.CLEAR);
            return this._prev_pos;
        }

        public final int getPrevLimit() {
            assert (this._state != SavePointState.CLEAR);
            return this._prev_limit;
        }

        public final long getPrevLineNumber() {
            return this._prev_line_count;
        }

        public final long getPrevLineStart() {
            return this._prev_line_start;
        }

        public static enum SavePointState {
            CLEAR,
            DEFINED,
            ACTIVE;

        }
    }
}

