/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

abstract class UnifiedDataPageX {
    protected PageType _page_type;
    protected int _page_limit;
    protected int _base_offset;
    protected int _unread_count;
    protected long _file_offset;
    protected byte[] _bytes;
    protected char[] _characters;

    public static final UnifiedDataPageX makePage(byte[] byArray, int n, int n2) {
        return new Bytes(byArray, n, n2);
    }

    public static final UnifiedDataPageX makePage(char[] cArray, int n, int n2) {
        return new Chars(cArray, n, n2);
    }

    public static final UnifiedDataPageX makePage(PageType pageType, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("invalid page size must be > 0");
        }
        switch (pageType) {
            case CHARS: {
                return new Chars(n);
            }
            case BYTES: {
                return new Bytes(n);
            }
        }
        throw new IllegalArgumentException("invalid page type, s/b 1 or 2");
    }

    private UnifiedDataPageX() {
    }

    public abstract int getValue(int var1);

    public abstract void putValue(int var1, int var2);

    public final PageType getPageType() {
        return this._page_type;
    }

    public final char[] getCharBuffer() {
        return this._characters;
    }

    public final byte[] getByteBuffer() {
        return this._bytes;
    }

    private final boolean isBytes() {
        return this._page_type == PageType.BYTES;
    }

    int load(Reader reader, int n, long l) throws IOException {
        if (this.isBytes()) {
            throw new UnsupportedOperationException("byte pages can't load characters");
        }
        int n2 = reader.read(this._characters, n, this._characters.length - n);
        if (n2 > 0) {
            this._page_limit = n + n2;
            this._base_offset = n;
            this._unread_count = 0;
            this.setFilePosition(l, n);
        }
        return n2;
    }

    int load(InputStream inputStream2, int n, long l) throws IOException {
        if (!this.isBytes()) {
            throw new UnsupportedOperationException("character pages can't load bytes");
        }
        int n2 = inputStream2.read(this._bytes, n, this._bytes.length - n);
        if (n2 > 0) {
            this._base_offset = n;
            this._unread_count = 0;
            this._page_limit = n + n2;
            this.setFilePosition(l, n);
        }
        return n2;
    }

    public int getBufferLimit() {
        return this._page_limit;
    }

    public int getOriginalStartingOffset() {
        return this._base_offset;
    }

    public int getStartingOffset() {
        return this._base_offset - this._unread_count;
    }

    public int getUnreadCount() {
        return this._unread_count;
    }

    public void inc_unread_count() {
        ++this._unread_count;
    }

    public final void setFilePosition(long l, int n) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this._file_offset = l - (long)n;
    }

    public final long getFilePosition(int n) {
        return this._file_offset + (long)n;
    }

    public final int getOffsetOfFilePosition(long l) {
        if (!this.containsOffset(l)) {
            String string = "requested file position [" + Long.toString(l) + "] is not in this page [" + Long.toString(this.getStartingFileOffset()) + "-" + Long.toString(this.getFilePosition(this._page_limit)) + "]";
            throw new IllegalArgumentException(string);
        }
        return (int)(l - this._file_offset);
    }

    public final long getStartingFileOffset() {
        return this._file_offset + (long)this._base_offset;
    }

    public final boolean containsOffset(long l) {
        if (this._file_offset + (long)this._base_offset > l) {
            return false;
        }
        return l < this._file_offset + (long)this._page_limit;
    }

    protected final int getLengthFollowingFilePosition(long l) {
        int n = this.getOffsetOfFilePosition(l);
        return this._page_limit - n;
    }

    public final void reset(int n) {
        this._page_limit = this._base_offset = n;
    }

    public abstract int readFrom(int var1, byte[] var2, int var3, int var4);

    public abstract int readFrom(int var1, char[] var2, int var3, int var4);

    public static final class Chars
    extends UnifiedDataPageX {
        public Chars(int n) {
            this(new char[n], 0, n);
        }

        public Chars(char[] cArray, int n, int n2) {
            this._page_type = PageType.CHARS;
            this._characters = cArray;
            this._base_offset = n;
            this._page_limit = n + n2;
        }

        @Override
        public int getValue(int n) {
            if (n < 0 || n > this._page_limit - this._base_offset) {
                throw new IllegalArgumentException("offset " + n + " is not contained in page, limit is " + (this._page_limit - this._base_offset));
            }
            return this._characters[n];
        }

        @Override
        public void putValue(int n, int n2) {
            this._characters[n] = (char)n2;
        }

        @Override
        public final int readFrom(int n, byte[] byArray, int n2, int n3) {
            throw new UnsupportedOperationException("character pages can't read bytes");
        }

        @Override
        public final int readFrom(int n, char[] cArray, int n2, int n3) {
            int n4 = n3;
            if (n >= this._page_limit) {
                return -1;
            }
            if (n4 > this._page_limit - n) {
                n4 = this._page_limit - n;
            }
            System.arraycopy(this._characters, n, cArray, n2, n4);
            return n4;
        }
    }

    public static final class Bytes
    extends UnifiedDataPageX {
        public Bytes(int n) {
            this(new byte[n], 0, n);
        }

        public Bytes(byte[] byArray, int n, int n2) {
            this._page_type = PageType.BYTES;
            this._bytes = byArray;
            this._base_offset = n;
            this._page_limit = n + n2;
        }

        @Override
        public int getValue(int n) {
            return this._bytes[n] & 0xFF;
        }

        @Override
        public void putValue(int n, int n2) {
            this._bytes[this._base_offset] = (byte)n2;
        }

        @Override
        public final int readFrom(int n, byte[] byArray, int n2, int n3) {
            int n4 = n3;
            if (n >= this._page_limit) {
                return -1;
            }
            if (n4 > this._page_limit - n) {
                n4 = this._page_limit - n;
            }
            System.arraycopy(this._bytes, n, byArray, n2, n4);
            return n4;
        }

        @Override
        public final int readFrom(int n, char[] cArray, int n2, int n3) {
            throw new UnsupportedOperationException("byte pages can't read characters");
        }
    }

    public static enum PageType {
        BYTES,
        CHARS;

    }
}

