/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import software.amazon.ion.SymbolToken;
import software.amazon.ion.UnknownSymbolException;
import software.amazon.ion.util.IonTextUtils;

final class SymbolTokenImpl
implements SymbolToken {
    private final String myText;
    private final int mySid;

    SymbolTokenImpl(String string, int n) {
        assert (string != null || n > 0) : "Neither text nor sid is defined";
        this.myText = string;
        this.mySid = n;
    }

    SymbolTokenImpl(int n) {
        assert (n > 0) : "sid is undefined";
        this.myText = null;
        this.mySid = n;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public String assumeText() {
        if (this.myText == null) {
            throw new UnknownSymbolException(this.mySid);
        }
        return this.myText;
    }

    @Override
    public int getSid() {
        return this.mySid;
    }

    public String toString() {
        String string = this.myText == null ? null : IonTextUtils.printString(this.myText);
        return "SymbolToken::{text:" + string + ",id:" + this.mySid + "}";
    }
}

