/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import software.amazon.ion.Decimal;
import software.amazon.ion.EmptySymbolException;
import software.amazon.ion.impl.AppendableFastAppendable;
import software.amazon.ion.impl.Base64Encoder;
import software.amazon.ion.impl.OutputStreamFastAppendable;
import software.amazon.ion.impl.PrivateIonConstants;
import software.amazon.ion.impl.PrivateIonTextWriterBuilder;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.util.PrivateFastAppendable;

@Deprecated
public final class PrivateIonTextAppender
implements Closeable,
Flushable {
    private static final boolean[] IDENTIFIER_START_CHAR_FLAGS;
    private static final boolean[] IDENTIFIER_FOLLOW_CHAR_FLAGS;
    public static final boolean[] OPERATOR_CHAR_FLAGS;
    public static final String[] ZERO_PADDING;
    private static final String[] STRING_ESCAPE_CODES;
    static final String[] LONG_STRING_ESCAPE_CODES;
    static final String[] SYMBOL_ESCAPE_CODES;
    static final String[] JSON_ESCAPE_CODES;
    private static final String HEX_4_PREFIX = "\\u";
    private static final String HEX_8_PREFIX = "\\U";
    private static final String TRIPLE_QUOTES = "'''";
    private final PrivateFastAppendable myAppendable;
    private final boolean escapeNonAscii;
    private final char[] _fixedIntBuffer = new char[PrivateIonConstants.MAX_LONG_TEXT_SIZE];

    private static boolean is8bitValue(int n) {
        return (n & 0xFFFFFF00) == 0;
    }

    private static boolean isDecimalDigit(int n) {
        return n >= 48 && n <= 57;
    }

    public static boolean isIdentifierStart(int n) {
        return IDENTIFIER_START_CHAR_FLAGS[n & 0xFF] && PrivateIonTextAppender.is8bitValue(n);
    }

    public static boolean isIdentifierPart(int n) {
        return IDENTIFIER_FOLLOW_CHAR_FLAGS[n & 0xFF] && PrivateIonTextAppender.is8bitValue(n);
    }

    public static boolean isOperatorPart(int n) {
        return OPERATOR_CHAR_FLAGS[n & 0xFF] && PrivateIonTextAppender.is8bitValue(n);
    }

    PrivateIonTextAppender(PrivateFastAppendable privateFastAppendable, boolean bl) {
        this.myAppendable = privateFastAppendable;
        this.escapeNonAscii = bl;
    }

    public static PrivateIonTextAppender forFastAppendable(PrivateFastAppendable privateFastAppendable, Charset charset) {
        boolean bl = charset.equals(PrivateUtils.ASCII_CHARSET);
        return new PrivateIonTextAppender(privateFastAppendable, bl);
    }

    public static PrivateIonTextAppender forAppendable(Appendable appendable, Charset charset) {
        AppendableFastAppendable appendableFastAppendable = new AppendableFastAppendable(appendable);
        return PrivateIonTextAppender.forFastAppendable(appendableFastAppendable, charset);
    }

    public static PrivateIonTextAppender forAppendable(Appendable appendable) {
        AppendableFastAppendable appendableFastAppendable = new AppendableFastAppendable(appendable);
        boolean bl = false;
        return new PrivateIonTextAppender(appendableFastAppendable, bl);
    }

    public static PrivateIonTextAppender forOutputStream(OutputStream outputStream2, Charset charset) {
        OutputStreamFastAppendable outputStreamFastAppendable = new OutputStreamFastAppendable(outputStream2);
        return PrivateIonTextAppender.forFastAppendable(outputStreamFastAppendable, charset);
    }

    @Override
    public void flush() throws IOException {
        if (this.myAppendable instanceof Flushable) {
            ((Flushable)((Object)this.myAppendable)).flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.myAppendable instanceof Closeable) {
            ((Closeable)((Object)this.myAppendable)).close();
        }
    }

    public void appendAscii(char c) throws IOException {
        this.myAppendable.appendAscii(c);
    }

    public void appendAscii(CharSequence charSequence) throws IOException {
        this.myAppendable.appendAscii(charSequence);
    }

    public void appendAscii(CharSequence charSequence, int n, int n2) throws IOException {
        this.myAppendable.appendAscii(charSequence, n, n2);
    }

    public void appendUtf16(char c) throws IOException {
        this.myAppendable.appendUtf16(c);
    }

    public void appendUtf16Surrogate(char c, char c2) throws IOException {
        this.myAppendable.appendUtf16Surrogate(c, c2);
    }

    public final void printString(CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            this.appendAscii("null.string");
        } else {
            this.appendAscii('\"');
            this.printCodePoints(charSequence, STRING_ESCAPE_CODES);
            this.appendAscii('\"');
        }
    }

    public final void printLongString(CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            this.appendAscii("null.string");
        } else {
            this.appendAscii(TRIPLE_QUOTES);
            this.printCodePoints(charSequence, LONG_STRING_ESCAPE_CODES);
            this.appendAscii(TRIPLE_QUOTES);
        }
    }

    public final void printJsonString(CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            this.appendAscii("null");
        } else {
            this.appendAscii('\"');
            this.printCodePoints(charSequence, JSON_ESCAPE_CODES);
            this.appendAscii('\"');
        }
    }

    public static boolean isIdentifierKeyword(CharSequence charSequence) {
        int n = 0;
        int n2 = charSequence.length();
        boolean bl = false;
        switch (charSequence.charAt(n++)) {
            case '$': {
                if (n2 == 1) {
                    return false;
                }
                while (n < n2) {
                    char c;
                    if (PrivateIonTextAppender.isDecimalDigit(c = charSequence.charAt(n++))) continue;
                    return false;
                }
                return true;
            }
            case 'f': {
                if (n2 != 5 || charSequence.charAt(n++) != 'a' || charSequence.charAt(n++) != 'l' || charSequence.charAt(n++) != 's' || charSequence.charAt(n++) != 'e') break;
                bl = true;
                break;
            }
            case 'n': {
                if (n2 == 4 && charSequence.charAt(n++) == 'u' && charSequence.charAt(n++) == 'l' && charSequence.charAt(n++) == 'l') {
                    bl = true;
                    break;
                }
                if (n2 != 3 || charSequence.charAt(n++) != 'a' || charSequence.charAt(n++) != 'n') break;
                bl = true;
                break;
            }
            case 't': {
                if (n2 != 4 || charSequence.charAt(n++) != 'r' || charSequence.charAt(n++) != 'u' || charSequence.charAt(n++) != 'e') break;
                bl = true;
            }
        }
        return bl;
    }

    public static boolean symbolNeedsQuoting(CharSequence charSequence, boolean bl) {
        int n = charSequence.length();
        if (n == 0) {
            throw new EmptySymbolException();
        }
        if (!PrivateIonTextAppender.isIdentifierKeyword(charSequence)) {
            char c = charSequence.charAt(0);
            if (!bl && PrivateIonTextAppender.isOperatorPart(c)) {
                for (int i = 0; i < n; ++i) {
                    c = charSequence.charAt(i);
                    if (PrivateIonTextAppender.isOperatorPart(c)) continue;
                    return true;
                }
                return false;
            }
            if (PrivateIonTextAppender.isIdentifierStart(c)) {
                for (int i = 0; i < n; ++i) {
                    c = charSequence.charAt(i);
                    if (c != '\'' && c >= ' ' && c <= '~' && PrivateIonTextAppender.isIdentifierPart(c)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public final void printSymbol(CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            this.appendAscii("null.symbol");
        } else {
            if (charSequence.length() == 0) {
                throw new EmptySymbolException();
            }
            if (PrivateIonTextAppender.symbolNeedsQuoting(charSequence, true)) {
                this.appendAscii('\'');
                this.printCodePoints(charSequence, SYMBOL_ESCAPE_CODES);
                this.appendAscii('\'');
            } else {
                this.appendAscii(charSequence);
            }
        }
    }

    public final void printQuotedSymbol(CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            this.appendAscii("null.symbol");
        } else {
            if (charSequence.length() == 0) {
                throw new EmptySymbolException();
            }
            this.appendAscii('\'');
            this.printCodePoints(charSequence, SYMBOL_ESCAPE_CODES);
            this.appendAscii('\'');
        }
    }

    private final void printCodePoints(CharSequence charSequence, String[] stringArray) throws IOException {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            String string;
            int n2;
            char c = '\u0000';
            for (n2 = i; n2 < n; ++n2) {
                c = charSequence.charAt(n2);
                if (c < '\u0100' && stringArray[c] == null) continue;
                if (n2 <= i) break;
                this.appendAscii(charSequence, i, n2);
                i = n2;
                break;
            }
            if (n2 == n) {
                this.appendAscii(charSequence, i, n2);
                break;
            }
            if (c < '\u0080') {
                assert (stringArray[c] != null);
                this.appendAscii(stringArray[c]);
                continue;
            }
            if (c < '\u0100') {
                assert (stringArray[c] != null);
                if (this.escapeNonAscii || c <= '\u009f') {
                    this.appendAscii(stringArray[c]);
                    continue;
                }
                this.appendUtf16(c);
                continue;
            }
            if (c < '\ud800' || c >= '\ue000') {
                string = Integer.toHexString(c);
                if (this.escapeNonAscii) {
                    this.appendAscii(HEX_4_PREFIX);
                    this.appendAscii(ZERO_PADDING[4 - string.length()]);
                    this.appendAscii(string);
                    continue;
                }
                this.appendUtf16(c);
                continue;
            }
            if (PrivateIonConstants.isHighSurrogate(c)) {
                char c2;
                if (++i == n || !PrivateIonConstants.isLowSurrogate(c2 = charSequence.charAt(i))) {
                    String string2 = "text is invalid UTF-16. It contains an unmatched leading surrogate 0x" + Integer.toHexString(c) + " at index " + (i - 1);
                    throw new IllegalArgumentException(string2);
                }
                if (this.escapeNonAscii) {
                    int n3 = PrivateIonConstants.makeUnicodeScalar(c, c2);
                    String string3 = Integer.toHexString(n3);
                    this.appendAscii(HEX_8_PREFIX);
                    this.appendAscii(ZERO_PADDING[8 - string3.length()]);
                    this.appendAscii(string3);
                    continue;
                }
                this.appendUtf16Surrogate(c, c2);
                continue;
            }
            assert (PrivateIonConstants.isLowSurrogate(c));
            string = "text is invalid UTF-16. It contains an unmatched trailing surrogate 0x" + Integer.toHexString(c) + " at index " + i;
            throw new IllegalArgumentException(string);
        }
    }

    public void printInt(long l) throws IOException {
        int n = this._fixedIntBuffer.length;
        if (l == 0L) {
            this._fixedIntBuffer[--n] = 48;
        } else if (l < 0L) {
            while (l != 0L) {
                this._fixedIntBuffer[--n] = (char)(48L - l % 10L);
                l /= 10L;
            }
            this._fixedIntBuffer[--n] = 45;
        } else {
            while (l != 0L) {
                this._fixedIntBuffer[--n] = (char)(48L + l % 10L);
                l /= 10L;
            }
        }
        this.appendAscii(CharBuffer.wrap(this._fixedIntBuffer), n, this._fixedIntBuffer.length);
    }

    public void printInt(BigInteger bigInteger) throws IOException {
        if (bigInteger == null) {
            this.appendAscii("null.int");
            return;
        }
        this.appendAscii(bigInteger.toString());
    }

    public void printDecimal(PrivateIonTextWriterBuilder privateIonTextWriterBuilder, BigDecimal bigDecimal) throws IOException {
        if (bigDecimal == null) {
            this.appendAscii("null.decimal");
            return;
        }
        BigInteger bigInteger = bigDecimal.unscaledValue();
        int n = bigDecimal.signum();
        if (n < 0) {
            this.appendAscii('-');
            bigInteger = bigInteger.negate();
        } else if (bigDecimal instanceof Decimal && ((Decimal)bigDecimal).isNegativeZero()) {
            this.appendAscii('-');
        }
        String string = bigInteger.toString();
        int n2 = string.length();
        int n3 = bigDecimal.scale();
        int n4 = -n3;
        if (privateIonTextWriterBuilder._decimal_as_float) {
            this.appendAscii(string);
            this.appendAscii('e');
            this.appendAscii(Integer.toString(n4));
        } else if (n4 == 0) {
            this.appendAscii(string);
            this.appendAscii('.');
        } else if (n4 < 0) {
            int n5 = n2 - 1 - n3;
            if (n5 >= 0) {
                int n6 = n2 - n3;
                this.appendAscii(string, 0, n6);
                this.appendAscii('.');
                this.appendAscii(string, n6, n2);
            } else if (n5 >= -6) {
                this.appendAscii("0.");
                this.appendAscii("00000", 0, n3 - n2);
                this.appendAscii(string);
            } else {
                this.appendAscii(string);
                this.appendAscii("d-");
                this.appendAscii(Integer.toString(n3));
            }
        } else {
            this.appendAscii(string);
            this.appendAscii('d');
            this.appendAscii(Integer.toString(n4));
        }
    }

    public void printFloat(double d) throws IOException {
        if (d == 0.0) {
            if (Double.compare(d, 0.0) == 0) {
                this.appendAscii("0e0");
            } else {
                this.appendAscii("-0e0");
            }
        } else if (Double.isNaN(d)) {
            this.appendAscii("nan");
        } else if (d == Double.POSITIVE_INFINITY) {
            this.appendAscii("+inf");
        } else if (d == Double.NEGATIVE_INFINITY) {
            this.appendAscii("-inf");
        } else {
            String string = Double.toString(d);
            if (string.endsWith(".0")) {
                this.appendAscii(string, 0, string.length() - 2);
                this.appendAscii("e0");
            } else {
                this.appendAscii(string);
                if (string.indexOf(69) == -1) {
                    this.appendAscii("e0");
                }
            }
        }
    }

    public void printFloat(Double d) throws IOException {
        if (d == null) {
            this.appendAscii("null.float");
        } else {
            this.printFloat((double)d);
        }
    }

    public void printBlob(PrivateIonTextWriterBuilder privateIonTextWriterBuilder, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (byArray == null) {
            this.appendAscii("null.blob");
            return;
        }
        Base64Encoder.TextStream textStream = new Base64Encoder.TextStream(new ByteArrayInputStream(byArray, n, n2));
        char[] cArray = new char[privateIonTextWriterBuilder.isPrettyPrintOn() ? 80 : 400];
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        if (privateIonTextWriterBuilder._blob_as_string) {
            this.appendAscii('\"');
        } else {
            this.appendAscii("{{");
            if (privateIonTextWriterBuilder.isPrettyPrintOn()) {
                this.appendAscii(' ');
            }
        }
        while ((n3 = textStream.read(cArray, 0, cArray.length)) >= 1) {
            this.appendAscii(charBuffer, 0, n3);
        }
        if (privateIonTextWriterBuilder._blob_as_string) {
            this.appendAscii('\"');
        } else {
            if (privateIonTextWriterBuilder.isPrettyPrintOn()) {
                this.appendAscii(' ');
            }
            this.appendAscii("}}");
        }
    }

    private void printClobBytes(byte[] byArray, int n, int n2, String[] stringArray) throws IOException {
        for (int i = n; i < n2; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            String string = stringArray[c];
            if (string != null) {
                this.appendAscii(string);
                continue;
            }
            this.appendAscii(c);
        }
    }

    public void printClob(PrivateIonTextWriterBuilder privateIonTextWriterBuilder, byte[] byArray, int n, int n2) throws IOException {
        boolean bl;
        if (byArray == null) {
            this.appendAscii("null.clob");
            return;
        }
        boolean bl2 = privateIonTextWriterBuilder._clob_as_string && privateIonTextWriterBuilder._string_as_json;
        int n3 = privateIonTextWriterBuilder.getLongStringThreshold();
        boolean bl3 = bl = 0 < n3 && n3 < byArray.length;
        if (!privateIonTextWriterBuilder._clob_as_string) {
            this.appendAscii("{{");
            if (privateIonTextWriterBuilder.isPrettyPrintOn()) {
                this.appendAscii(' ');
            }
        }
        if (bl2) {
            this.appendAscii('\"');
            this.printClobBytes(byArray, n, n + n2, JSON_ESCAPE_CODES);
            this.appendAscii('\"');
        } else if (bl) {
            this.appendAscii(TRIPLE_QUOTES);
            this.printClobBytes(byArray, n, n + n2, LONG_STRING_ESCAPE_CODES);
            this.appendAscii(TRIPLE_QUOTES);
        } else {
            this.appendAscii('\"');
            this.printClobBytes(byArray, n, n + n2, STRING_ESCAPE_CODES);
            this.appendAscii('\"');
        }
        if (!privateIonTextWriterBuilder._clob_as_string) {
            if (privateIonTextWriterBuilder.isPrettyPrintOn()) {
                this.appendAscii(' ');
            }
            this.appendAscii("}}");
        }
    }

    static {
        int n;
        int n2;
        IDENTIFIER_START_CHAR_FLAGS = new boolean[256];
        IDENTIFIER_FOLLOW_CHAR_FLAGS = new boolean[256];
        for (n2 = 97; n2 <= 122; ++n2) {
            PrivateIonTextAppender.IDENTIFIER_START_CHAR_FLAGS[n2] = true;
            PrivateIonTextAppender.IDENTIFIER_FOLLOW_CHAR_FLAGS[n2] = true;
        }
        for (n2 = 65; n2 <= 90; ++n2) {
            PrivateIonTextAppender.IDENTIFIER_START_CHAR_FLAGS[n2] = true;
            PrivateIonTextAppender.IDENTIFIER_FOLLOW_CHAR_FLAGS[n2] = true;
        }
        PrivateIonTextAppender.IDENTIFIER_START_CHAR_FLAGS[95] = true;
        PrivateIonTextAppender.IDENTIFIER_FOLLOW_CHAR_FLAGS[95] = true;
        PrivateIonTextAppender.IDENTIFIER_START_CHAR_FLAGS[36] = true;
        PrivateIonTextAppender.IDENTIFIER_FOLLOW_CHAR_FLAGS[36] = true;
        for (n2 = 48; n2 <= 57; ++n2) {
            PrivateIonTextAppender.IDENTIFIER_FOLLOW_CHAR_FLAGS[n2] = true;
        }
        char[] cArray = new char[]{'<', '>', '=', '+', '-', '*', '&', '^', '%', '~', '/', '?', '.', ';', '!', '|', '@', '`', '#'};
        OPERATOR_CHAR_FLAGS = new boolean[256];
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            PrivateIonTextAppender.OPERATOR_CHAR_FLAGS[c] = true;
        }
        ZERO_PADDING = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000"};
        STRING_ESCAPE_CODES = new String[256];
        PrivateIonTextAppender.STRING_ESCAPE_CODES[0] = "\\0";
        PrivateIonTextAppender.STRING_ESCAPE_CODES[7] = "\\a";
        PrivateIonTextAppender.STRING_ESCAPE_CODES[8] = "\\b";
        PrivateIonTextAppender.STRING_ESCAPE_CODES[9] = "\\t";
        PrivateIonTextAppender.STRING_ESCAPE_CODES[10] = "\\n";
        PrivateIonTextAppender.STRING_ESCAPE_CODES[11] = "\\v";
        PrivateIonTextAppender.STRING_ESCAPE_CODES[12] = "\\f";
        PrivateIonTextAppender.STRING_ESCAPE_CODES[13] = "\\r";
        PrivateIonTextAppender.STRING_ESCAPE_CODES[92] = "\\\\";
        PrivateIonTextAppender.STRING_ESCAPE_CODES[34] = "\\\"";
        for (n = 1; n < 32; ++n) {
            if (STRING_ESCAPE_CODES[n] != null) continue;
            String string = Integer.toHexString(n);
            PrivateIonTextAppender.STRING_ESCAPE_CODES[n] = "\\x" + ZERO_PADDING[2 - string.length()] + string;
        }
        for (n = 127; n < 256; ++n) {
            String string = Integer.toHexString(n);
            PrivateIonTextAppender.STRING_ESCAPE_CODES[n] = "\\x" + string;
        }
        LONG_STRING_ESCAPE_CODES = new String[256];
        for (n = 0; n < 256; ++n) {
            PrivateIonTextAppender.LONG_STRING_ESCAPE_CODES[n] = STRING_ESCAPE_CODES[n];
        }
        PrivateIonTextAppender.LONG_STRING_ESCAPE_CODES[10] = null;
        PrivateIonTextAppender.LONG_STRING_ESCAPE_CODES[39] = "\\'";
        PrivateIonTextAppender.LONG_STRING_ESCAPE_CODES[34] = null;
        SYMBOL_ESCAPE_CODES = new String[256];
        for (n = 0; n < 256; ++n) {
            PrivateIonTextAppender.SYMBOL_ESCAPE_CODES[n] = STRING_ESCAPE_CODES[n];
        }
        PrivateIonTextAppender.SYMBOL_ESCAPE_CODES[39] = "\\'";
        PrivateIonTextAppender.SYMBOL_ESCAPE_CODES[34] = null;
        JSON_ESCAPE_CODES = new String[256];
        PrivateIonTextAppender.JSON_ESCAPE_CODES[8] = "\\b";
        PrivateIonTextAppender.JSON_ESCAPE_CODES[9] = "\\t";
        PrivateIonTextAppender.JSON_ESCAPE_CODES[10] = "\\n";
        PrivateIonTextAppender.JSON_ESCAPE_CODES[12] = "\\f";
        PrivateIonTextAppender.JSON_ESCAPE_CODES[13] = "\\r";
        PrivateIonTextAppender.JSON_ESCAPE_CODES[92] = "\\\\";
        PrivateIonTextAppender.JSON_ESCAPE_CODES[34] = "\\\"";
        for (n = 0; n < 32; ++n) {
            if (JSON_ESCAPE_CODES[n] != null) continue;
            String string = Integer.toHexString(n);
            PrivateIonTextAppender.JSON_ESCAPE_CODES[n] = HEX_4_PREFIX + ZERO_PADDING[4 - string.length()] + string;
        }
        for (n = 127; n < 256; ++n) {
            String string = Integer.toHexString(n);
            PrivateIonTextAppender.JSON_ESCAPE_CODES[n] = "\\u00" + string;
        }
    }
}

