/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import software.amazon.ion.IonException;
import software.amazon.ion.IonType;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.Timestamp;
import software.amazon.ion.impl.IonWriterSystem;
import software.amazon.ion.impl.PrivateIonTextAppender;
import software.amazon.ion.impl.PrivateIonTextWriterBuilder;
import software.amazon.ion.impl.SymbolTableReader;
import software.amazon.ion.system.IonTextWriterBuilder;
import software.amazon.ion.util.IonTextUtils;
import software.amazon.ion.util.PrivateFastAppendable;

class IonWriterSystemText
extends IonWriterSystem {
    private final PrivateIonTextWriterBuilder _options;
    private final int _long_string_threshold;
    private final PrivateIonTextAppender _output;
    private boolean _closed;
    boolean _in_struct;
    boolean _pending_separator;
    private boolean _is_writing_ivm;
    private boolean _following_long_string;
    int _separator_character;
    int _top;
    int[] _stack_parent_type = new int[10];
    boolean[] _stack_pending_comma = new boolean[10];

    protected IonWriterSystemText(SymbolTable symbolTable, PrivateIonTextWriterBuilder privateIonTextWriterBuilder, PrivateFastAppendable privateFastAppendable) {
        super(symbolTable, privateIonTextWriterBuilder.getInitialIvmHandling(), privateIonTextWriterBuilder.getIvmMinimizing());
        this._output = PrivateIonTextAppender.forFastAppendable(privateFastAppendable, privateIonTextWriterBuilder.getCharset());
        this._options = privateIonTextWriterBuilder;
        this._separator_character = this._options.isPrettyPrintOn() ? 10 : 32;
        int n = this._options.getLongStringThreshold();
        if (n < 1) {
            n = Integer.MAX_VALUE;
        }
        this._long_string_threshold = n;
    }

    PrivateIonTextWriterBuilder getBuilder() {
        return this._options;
    }

    @Override
    public int getDepth() {
        return this._top;
    }

    @Override
    public boolean isInStruct() {
        return this._in_struct;
    }

    protected IonType getContainer() {
        IonType ionType;
        if (this._top < 1) {
            ionType = IonType.DATAGRAM;
        } else {
            switch (this._stack_parent_type[this._top - 1]) {
                case 16: {
                    ionType = IonType.DATAGRAM;
                    break;
                }
                case 12: {
                    ionType = IonType.SEXP;
                    break;
                }
                case 11: {
                    ionType = IonType.LIST;
                    break;
                }
                case 13: {
                    ionType = IonType.STRUCT;
                    break;
                }
                default: {
                    throw new IonException("unexpected container in parent stack: " + this._stack_parent_type[this._top - 1]);
                }
            }
        }
        return ionType;
    }

    void push(int n) {
        if (this._top + 1 == this._stack_parent_type.length) {
            this.growStack();
        }
        this._stack_parent_type[this._top] = n;
        this._stack_pending_comma[this._top] = this._pending_separator;
        switch (n) {
            case 12: {
                this._separator_character = 32;
                break;
            }
            case 11: 
            case 13: {
                this._separator_character = 44;
                break;
            }
            default: {
                this._separator_character = this._options.isPrettyPrintOn() ? 10 : 32;
            }
        }
        ++this._top;
    }

    void growStack() {
        int n = this._stack_parent_type.length;
        int n2 = n * 2;
        int[] nArray = new int[n2];
        boolean[] blArray = new boolean[n2];
        System.arraycopy(this._stack_parent_type, 0, nArray, 0, n);
        System.arraycopy(this._stack_pending_comma, 0, blArray, 0, n);
        this._stack_parent_type = nArray;
        this._stack_pending_comma = blArray;
    }

    int pop() {
        --this._top;
        int n = this._stack_parent_type[this._top];
        int n2 = this._top > 0 ? this._stack_parent_type[this._top - 1] : -1;
        switch (n2) {
            case -1: 
            case 12: {
                this._in_struct = false;
                this._separator_character = 32;
                break;
            }
            case 11: {
                this._in_struct = false;
                this._separator_character = 44;
                break;
            }
            case 13: {
                this._in_struct = true;
                this._separator_character = 44;
                break;
            }
            default: {
                this._separator_character = this._options.isPrettyPrintOn() ? 10 : 32;
            }
        }
        return n;
    }

    int topType() {
        return this._stack_parent_type[this._top - 1];
    }

    boolean topPendingComma() {
        if (this._top == 0) {
            return false;
        }
        return this._stack_pending_comma[this._top - 1];
    }

    private boolean containerIsSexp() {
        if (this._top == 0) {
            return false;
        }
        int n = this.topType();
        return n == 12;
    }

    void printLeadingWhiteSpace() throws IOException {
        for (int i = 0; i < this._top; ++i) {
            this._output.appendAscii(' ');
            this._output.appendAscii(' ');
        }
    }

    void closeCollection(char c) throws IOException {
        if (this._options.isPrettyPrintOn()) {
            this._output.appendAscii(this._options.lineSeparator());
            this.printLeadingWhiteSpace();
        }
        this._output.appendAscii(c);
    }

    private void writeSidLiteral(int n) throws IOException {
        assert (n > 0);
        boolean bl = this._options._symbol_as_string;
        if (bl) {
            this._output.appendAscii('\"');
        }
        this._output.appendAscii('$');
        this._output.printInt(n);
        if (bl) {
            this._output.appendAscii('\"');
        }
    }

    private void writeSymbolToken(String string) throws IOException {
        if (this._options._symbol_as_string) {
            if (this._options._string_as_json) {
                this._output.printJsonString(string);
            } else {
                this._output.printString(string);
            }
        } else {
            IonTextUtils.SymbolVariant symbolVariant = IonTextUtils.symbolVariant(string);
            switch (symbolVariant) {
                case IDENTIFIER: {
                    this._output.appendAscii(string);
                    break;
                }
                case OPERATOR: {
                    if (this.containerIsSexp()) {
                        this._output.appendAscii(string);
                        break;
                    }
                }
                case QUOTED: {
                    this._output.printQuotedSymbol(string);
                }
            }
        }
    }

    void writeFieldNameToken(SymbolToken symbolToken) throws IOException {
        String string = symbolToken.getText();
        if (string == null) {
            int n = symbolToken.getSid();
            this.writeSidLiteral(n);
        } else {
            this.writeSymbolToken(string);
        }
    }

    void writeAnnotations(SymbolToken[] symbolTokenArray) throws IOException {
        for (SymbolToken symbolToken : symbolTokenArray) {
            this.writeAnnotationToken(symbolToken);
            this._output.appendAscii("::");
        }
    }

    void writeAnnotationToken(SymbolToken symbolToken) throws IOException {
        String string = symbolToken.getText();
        if (string == null) {
            this._output.appendAscii('$');
            this._output.appendAscii(Integer.toString(symbolToken.getSid()));
        } else {
            this._output.printSymbol(string);
        }
    }

    boolean writeSeparator(boolean bl) throws IOException {
        if (this._options.isPrettyPrintOn()) {
            if (this._pending_separator && this._separator_character > 32) {
                this._output.appendAscii((char)this._separator_character);
                bl = false;
            }
            this._output.appendAscii(this._options.lineSeparator());
            this.printLeadingWhiteSpace();
        } else if (this._pending_separator) {
            this._output.appendAscii((char)this._separator_character);
            if (this._separator_character > 32) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    void startValue() throws IOException {
        SymbolToken[] symbolTokenArray;
        super.startValue();
        boolean bl = this._following_long_string;
        bl = this.writeSeparator(bl);
        if (this._in_struct) {
            symbolTokenArray = this.assumeFieldNameSymbol();
            this.writeFieldNameToken((SymbolToken)symbolTokenArray);
            this._output.appendAscii(':');
            this.clearFieldName();
            bl = false;
        }
        if (this.hasAnnotations() && !this._is_writing_ivm) {
            if (!this._options._skip_annotations) {
                symbolTokenArray = this.getTypeAnnotationSymbols();
                this.writeAnnotations(symbolTokenArray);
                bl = false;
            }
            this.clearAnnotations();
        }
        this._following_long_string = bl;
    }

    void closeValue() throws IOException {
        super.endValue();
        this._pending_separator = true;
        this._following_long_string = false;
        if (this.getDepth() == 0) {
            try {
                this.flush();
            }
            catch (IOException iOException) {
                throw new IonException(iOException);
            }
        }
    }

    @Override
    void writeIonVersionMarkerAsIs(SymbolTable symbolTable) throws IOException {
        this._is_writing_ivm = true;
        this.writeSymbolAsIs(symbolTable.getIonVersionId());
        this._is_writing_ivm = false;
    }

    @Override
    void writeLocalSymtab(SymbolTable symbolTable) throws IOException {
        SymbolTable[] symbolTableArray = symbolTable.getImportedTables();
        IonTextWriterBuilder.LstMinimizing lstMinimizing = this._options.getLstMinimizing();
        if (lstMinimizing == null) {
            symbolTable.writeTo(this);
        } else if (lstMinimizing == IonTextWriterBuilder.LstMinimizing.LOCALS && symbolTableArray.length > 0) {
            SymbolTableReader symbolTableReader = new SymbolTableReader(symbolTable);
            IonType ionType = symbolTableReader.next();
            assert (IonType.STRUCT.equals((Object)ionType));
            SymbolToken[] symbolTokenArray = symbolTableReader.getTypeAnnotationSymbols();
            assert (symbolTokenArray != null && symbolTokenArray.length >= 1);
            this.setTypeAnnotationSymbols(symbolTokenArray);
            this.stepIn(IonType.STRUCT);
            symbolTableReader.stepIn();
            while ((ionType = symbolTableReader.next()) != null) {
                String string = symbolTableReader.getFieldName();
                if ("symbols".equals(string)) continue;
                this.writeValue(symbolTableReader);
            }
            this.stepOut();
        } else {
            SymbolTable symbolTable2 = symbolTable.getSystemSymbolTable();
            this.writeIonVersionMarker(symbolTable2);
        }
        super.writeLocalSymtab(symbolTable);
    }

    @Override
    public void stepIn(IonType ionType) throws IOException {
        char c;
        int n;
        this.startValue();
        switch (ionType) {
            case SEXP: {
                if (!this._options._sexp_as_list) {
                    n = 12;
                    this._in_struct = false;
                    c = '(';
                    break;
                }
            }
            case LIST: {
                n = 11;
                this._in_struct = false;
                c = '[';
                break;
            }
            case STRUCT: {
                n = 13;
                this._in_struct = true;
                c = '{';
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.push(n);
        this._output.appendAscii(c);
        this._pending_separator = false;
        this._following_long_string = false;
    }

    @Override
    public void stepOut() throws IOException {
        char c;
        if (this._top < 1) {
            throw new IllegalStateException("Cannot stepOut any further, already at top level.");
        }
        this._pending_separator = this.topPendingComma();
        int n = this.pop();
        switch (n) {
            case 11: {
                c = ']';
                break;
            }
            case 12: {
                c = ')';
                break;
            }
            case 13: {
                c = '}';
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.closeCollection(c);
        this.closeValue();
    }

    @Override
    public void writeNull() throws IOException {
        this.startValue();
        this._output.appendAscii("null");
        this.closeValue();
    }

    @Override
    public void writeNull(IonType ionType) throws IOException {
        String string;
        this.startValue();
        if (this._options._untyped_nulls) {
            string = "null";
        } else {
            switch (ionType) {
                case NULL: {
                    string = "null";
                    break;
                }
                case BOOL: {
                    string = "null.bool";
                    break;
                }
                case INT: {
                    string = "null.int";
                    break;
                }
                case FLOAT: {
                    string = "null.float";
                    break;
                }
                case DECIMAL: {
                    string = "null.decimal";
                    break;
                }
                case TIMESTAMP: {
                    string = "null.timestamp";
                    break;
                }
                case SYMBOL: {
                    string = "null.symbol";
                    break;
                }
                case STRING: {
                    string = "null.string";
                    break;
                }
                case BLOB: {
                    string = "null.blob";
                    break;
                }
                case CLOB: {
                    string = "null.clob";
                    break;
                }
                case SEXP: {
                    string = "null.sexp";
                    break;
                }
                case LIST: {
                    string = "null.list";
                    break;
                }
                case STRUCT: {
                    string = "null.struct";
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected type " + (Object)((Object)ionType));
                }
            }
        }
        this._output.appendAscii(string);
        this.closeValue();
    }

    @Override
    public void writeBool(boolean bl) throws IOException {
        this.startValue();
        this._output.appendAscii(bl ? "true" : "false");
        this.closeValue();
    }

    @Override
    public void writeInt(long l) throws IOException {
        this.startValue();
        this._output.printInt(l);
        this.closeValue();
    }

    @Override
    public void writeInt(BigInteger bigInteger) throws IOException {
        if (bigInteger == null) {
            this.writeNull(IonType.INT);
            return;
        }
        this.startValue();
        this._output.printInt(bigInteger);
        this.closeValue();
    }

    @Override
    public void writeFloat(double d) throws IOException {
        this.startValue();
        this._output.printFloat(d);
        this.closeValue();
    }

    @Override
    public void writeDecimal(BigDecimal bigDecimal) throws IOException {
        if (bigDecimal == null) {
            this.writeNull(IonType.DECIMAL);
            return;
        }
        this.startValue();
        this._output.printDecimal(this._options, bigDecimal);
        this.closeValue();
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws IOException {
        if (timestamp == null) {
            this.writeNull(IonType.TIMESTAMP);
            return;
        }
        this.startValue();
        if (this._options._timestamp_as_millis) {
            long l = timestamp.getMillis();
            this._output.appendAscii(Long.toString(l));
        } else if (this._options._timestamp_as_string) {
            this._output.appendAscii('\"');
            this._output.appendAscii(timestamp.toString());
            this._output.appendAscii('\"');
        } else {
            this._output.appendAscii(timestamp.toString());
        }
        this.closeValue();
    }

    @Override
    public void writeString(String string) throws IOException {
        this.startValue();
        if (string != null && !this._following_long_string && this._long_string_threshold < string.length()) {
            this._output.printLongString(string);
            this.closeValue();
            this._following_long_string = true;
        } else {
            if (this._options._string_as_json) {
                this._output.printJsonString(string);
            } else {
                this._output.printString(string);
            }
            this.closeValue();
        }
    }

    @Override
    void writeSymbolAsIs(int n) throws IOException {
        SymbolTable symbolTable = this.getSymbolTable();
        String string = symbolTable.findKnownSymbol(n);
        if (string != null) {
            this.writeSymbolAsIs(string);
        } else {
            this.startValue();
            this.writeSidLiteral(n);
            this.closeValue();
        }
    }

    @Override
    public void writeSymbolAsIs(String string) throws IOException {
        if (string == null) {
            this.writeNull(IonType.SYMBOL);
            return;
        }
        this.startValue();
        this.writeSymbolToken(string);
        this.closeValue();
    }

    @Override
    public void writeBlob(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            this.writeNull(IonType.BLOB);
            return;
        }
        this.startValue();
        this._output.printBlob(this._options, byArray, n, n2);
        this.closeValue();
    }

    @Override
    public void writeClob(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            this.writeNull(IonType.CLOB);
            return;
        }
        this.startValue();
        this._output.printClob(this._options, byArray, n, n2);
        this.closeValue();
    }

    @Override
    public void flush() throws IOException {
        if (!this._closed) {
            this._output.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            try {
                if (this.getDepth() == 0) {
                    this.finish();
                }
            }
            finally {
                this._closed = true;
                this._output.close();
            }
        }
    }
}

