/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import software.amazon.ion.IonException;

class IonUTF8 {
    private static final int UNICODE_MAX_ONE_BYTE_SCALAR = 127;
    private static final int UNICODE_MAX_TWO_BYTE_SCALAR = 2047;
    private static final int UNICODE_MAX_THREE_BYTE_SCALAR = 65535;
    private static final int UNICODE_MAX_FOUR_BYTE_SCALAR = 0x10FFFF;
    private static final int UNICODE_THREE_BYTES_OR_FEWER_MASK = -65536;
    private static final int UNICODE_TWO_BYTE_HEADER = 192;
    private static final int UNICODE_THREE_BYTE_HEADER = 224;
    private static final int UNICODE_FOUR_BYTE_HEADER = 240;
    private static final int UNICODE_CONTINUATION_BYTE_HEADER = 128;
    private static final int UNICODE_TWO_BYTE_MASK = 31;
    private static final int UNICODE_THREE_BYTE_MASK = 15;
    private static final int UNICODE_FOUR_BYTE_MASK = 7;
    private static final int UNICODE_CONTINUATION_BYTE_MASK = 63;
    private static final int MAXIMUM_UTF16_1_CHAR_CODE_POINT = 65535;
    private static final int SURROGATE_OFFSET = 65536;
    private static final int SURROGATE_MASK = -1024;
    private static final int HIGH_SURROGATE = 55296;
    private static final int LOW_SURROGATE = 56320;

    IonUTF8() {
    }

    public static final boolean isHighSurrogate(int n) {
        return (n & 0xFFFFFC00) == 55296;
    }

    public static final boolean isLowSurrogate(int n) {
        return (n & 0xFFFFFC00) == 56320;
    }

    public static final boolean isSurrogate(int n) {
        return n >= 55296 && n <= 57343;
    }

    public static final boolean isOneByteUTF8(int n) {
        return (n & 0x80) == 0;
    }

    public static final boolean isTwoByteUTF8(int n) {
        return (n & 0xFFFFFFE0) == 192;
    }

    public static final boolean isThreeByteUTF8(int n) {
        return (n & 0xFFFFFFF0) == 224;
    }

    public static final boolean isFourByteUTF8(int n) {
        return (n & 0xFFFFFFF8) == 240;
    }

    public static final boolean isContinueByteUTF8(int n) {
        return (n & 0xFFFFFFC0) == 128;
    }

    public static final boolean isStartByte(int n) {
        return IonUTF8.isOneByteUTF8(n) || !IonUTF8.isContinueByteUTF8(n);
    }

    public static final char twoByteScalar(int n, int n2) {
        int n3 = (n & 0x1F) << 6 | n2 & 0x3F;
        return (char)n3;
    }

    public static final int threeByteScalar(int n, int n2, int n3) {
        int n4 = (n & 0xF) << 12 | (n2 & 0x3F) << 6 | n3 & 0x3F;
        return n4;
    }

    public static final int fourByteScalar(int n, int n2, int n3, int n4) {
        int n5 = (n & 7) << 18 | (n2 & 0x3F) << 12 | (n3 & 0x3F) << 6 | n4 & 0x3F;
        return n5;
    }

    public static final boolean isOneByteScalar(int n) {
        return n <= 127;
    }

    public static final boolean isTwoByteScalar(int n) {
        return n <= 2047;
    }

    public static final boolean isThreeByteScalar(int n) {
        return n <= 65535;
    }

    public static final boolean isFourByteScalar(int n) {
        return n <= 0x10FFFF;
    }

    public static final int getUTF8ByteCount(int n) {
        if ((n & 0xFFFF0000) != 0) {
            if (n >= 0 && n <= 0x10FFFF) {
                return 4;
            }
            throw new InvalidUnicodeCodePoint();
        }
        if (n <= 127) {
            return 1;
        }
        if (n <= 2047) {
            return 2;
        }
        return 3;
    }

    public static final int getUTF8LengthFromFirstByte(int n) {
        if (IonUTF8.isOneByteUTF8(n &= 0xFF)) {
            return 1;
        }
        if (IonUTF8.isTwoByteUTF8(n)) {
            return 2;
        }
        if (IonUTF8.isThreeByteUTF8(n)) {
            return 3;
        }
        if (IonUTF8.isFourByteUTF8(n)) {
            return 4;
        }
        return -1;
    }

    public static final byte getByte1Of2(int n) {
        int n2 = 0xC0 | n >> 6 & 0x1F;
        return (byte)n2;
    }

    public static final byte getByte2Of2(int n) {
        int n2 = 0x80 | n & 0x3F;
        return (byte)n2;
    }

    public static final byte getByte1Of3(int n) {
        int n2 = 0xE0 | n >> 12 & 0xF;
        return (byte)n2;
    }

    public static final byte getByte2Of3(int n) {
        int n2 = 0x80 | n >> 6 & 0x3F;
        return (byte)n2;
    }

    public static final byte getByte3Of3(int n) {
        int n2 = 0x80 | n & 0x3F;
        return (byte)n2;
    }

    public static final byte getByte1Of4(int n) {
        int n2 = 0xF0 | n >> 18 & 7;
        return (byte)n2;
    }

    public static final byte getByte2Of4(int n) {
        int n2 = 0x80 | n >> 12 & 0x3F;
        return (byte)n2;
    }

    public static final byte getByte3Of4(int n) {
        int n2 = 0x80 | n >> 6 & 0x3F;
        return (byte)n2;
    }

    public static final byte getByte4Of4(int n) {
        int n2 = 0x80 | n & 0x3F;
        return (byte)n2;
    }

    public static final int getAs4BytesReversed(int n) {
        switch (IonUTF8.getUTF8ByteCount(n)) {
            case 1: {
                return n;
            }
            case 2: {
                int n2 = IonUTF8.getByte1Of2(n);
                return n2 |= IonUTF8.getByte2Of2(n) << 8;
            }
            case 3: {
                int n3 = IonUTF8.getByte1Of3(n);
                n3 |= IonUTF8.getByte2Of3(n) << 8;
                return n3 |= IonUTF8.getByte3Of3(n) << 16;
            }
            case 4: {
                int n4 = IonUTF8.getByte1Of4(n);
                n4 |= IonUTF8.getByte2Of4(n) << 8;
                n4 |= IonUTF8.getByte3Of4(n) << 16;
                return n4 |= IonUTF8.getByte4Of4(n) << 24;
            }
        }
        throw new InvalidUnicodeCodePoint();
    }

    public static final int convertToUTF8Bytes(int n, byte[] byArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n2 + n3;
        switch (IonUTF8.getUTF8ByteCount(n)) {
            case 1: {
                if (n4 >= n5) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                byArray[n4++] = (byte)(n & 0xFF);
                break;
            }
            case 2: {
                if (n4 + 1 >= n5) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                byArray[n4++] = IonUTF8.getByte1Of2(n);
                byArray[n4++] = IonUTF8.getByte2Of2(n);
                break;
            }
            case 3: {
                if (n4 + 2 >= n5) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                byArray[n4++] = IonUTF8.getByte1Of3(n);
                byArray[n4++] = IonUTF8.getByte2Of3(n);
                byArray[n4++] = IonUTF8.getByte3Of3(n);
                break;
            }
            case 4: {
                if (n4 + 3 >= n5) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                byArray[n4++] = IonUTF8.getByte1Of4(n);
                byArray[n4++] = IonUTF8.getByte2Of4(n);
                byArray[n4++] = IonUTF8.getByte3Of4(n);
                byArray[n4++] = IonUTF8.getByte4Of4(n);
            }
        }
        return n4 - n2;
    }

    public static final int packBytesAfter1(int n, int n2) {
        int n3;
        switch (n2) {
            default: {
                throw new IllegalArgumentException("pack requires len > 1");
            }
            case 2: {
                n3 = IonUTF8.getByte2Of2(n);
                break;
            }
            case 3: {
                n3 = IonUTF8.getByte2Of3(n);
                n3 |= IonUTF8.getByte3Of3(n) << 8;
                break;
            }
            case 4: {
                n3 = IonUTF8.getByte2Of4(n);
                n3 |= IonUTF8.getByte3Of4(n) << 8;
                n3 |= IonUTF8.getByte4Of4(n) << 16;
            }
        }
        return n3;
    }

    public static final int getScalarFrom4BytesReversed(int n) {
        int n2 = n & 0xFF;
        switch (IonUTF8.getUTF8LengthFromFirstByte(n2)) {
            case 1: {
                return n2;
            }
            case 2: {
                n2 = (n2 & 0x1F) << 6;
                return n2 |= n >> 8 & 0x3F;
            }
            case 3: {
                n2 = (n2 & 0xF) << 12;
                n2 |= n >> 2 & 0xFC0;
                return n2 |= n >> 16 & 0x3F;
            }
            case 4: {
                n2 = (n2 & 7) << 18;
                n2 |= n << 4 & 0x3F000;
                n2 |= n >> 2 & 0xFC0;
                return n2 |= n >> 24 & 0x3F;
            }
        }
        throw new InvalidUnicodeCodePoint();
    }

    public static final int getScalarReadLengthFromBytes(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = n;
        int n6 = n + n2;
        if (n5 >= n6) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n5 + (n4 = IonUTF8.getUTF8LengthFromFirstByte(n3 = byArray[n5++] & 0xFF)) > n6) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return n4;
    }

    public static final int getScalarFromBytes(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = n;
        int n6 = n + n2;
        if (n5 >= n6) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n5 + (n4 = IonUTF8.getUTF8LengthFromFirstByte(n3 = byArray[n5++] & 0xFF)) > n6) {
            throw new ArrayIndexOutOfBoundsException();
        }
        switch (n4) {
            case 1: {
                break;
            }
            case 2: {
                n3 &= 0x1F;
                n3 |= byArray[n5++] & 0xFF & 0x3F;
                break;
            }
            case 3: {
                n3 &= 0xF;
                n3 |= byArray[n5++] & 0xFF & 0x3F;
                n3 |= byArray[n5++] & 0xFF & 0x3F;
                break;
            }
            case 4: {
                n3 &= 7;
                n3 |= byArray[n5++] & 0xFF & 0x3F;
                n3 |= byArray[n5++] & 0xFF & 0x3F;
                n3 |= byArray[n5++] & 0xFF & 0x3F;
                break;
            }
            default: {
                throw new InvalidUnicodeCodePoint("code point is invalid: " + n4);
            }
        }
        return n3;
    }

    public static final boolean needsSurrogateEncoding(int n) {
        return n > 65535;
    }

    public static final char highSurrogate(int n) {
        assert (n > 65535);
        assert (n <= 0x10FFFF);
        int n2 = n - 65536 >> 10;
        return (char)((n2 | 0xD800) & 0xFFFF);
    }

    public static final char lowSurrogate(int n) {
        assert (n > 65535);
        assert (n <= 0x10FFFF);
        int n2 = n - 65536 & 0x3FF;
        return (char)((n2 | 0xDC00) & 0xFFFF);
    }

    public static final int getUnicodeScalarFromSurrogates(int n, int n2) {
        assert (IonUTF8.isHighSurrogate(n));
        assert (IonUTF8.isLowSurrogate(n2));
        int n3 = n2 & 0x3FF;
        n3 += (n & 0x3FF) << 10;
        return n3 += 65536;
    }

    public static final class UTF8ToChar
    extends OutputStream
    implements Closeable {
        private final Appendable _char_stream;
        private int _expected_count = 0;
        private int _pending_count = 0;
        private int _pending_c1;
        private int _pending_c2;
        private int _pending_c3;

        public UTF8ToChar(Appendable appendable) {
            this._char_stream = appendable;
        }

        public final Appendable getAppendable() {
            return this._char_stream;
        }

        @Override
        public final void close() throws IOException {
            if (this._pending_count > 0) {
                throw new IOException("unfinished utf8 sequence still open");
            }
        }

        @Override
        public final void write(int n) throws IOException {
            n &= 0xFF;
            if (this._expected_count > 0) {
                this.write_helper_continue(n);
            } else if (n > 127) {
                if (!IonUTF8.isStartByte(n)) {
                    throw new IOException("invalid UTF8 sequence: byte > 127 is not a UTF8 leading byte");
                }
                this.write_helper_start_sequence(n);
            } else {
                this._char_stream.append((char)n);
            }
        }

        @Override
        public final void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            for (int i = n; i < n + n2; ++i) {
                int n3 = byArray[i] & 0xFF;
                if (this._pending_count == 0 && n3 < 128) {
                    this._char_stream.append((char)n3);
                    continue;
                }
                this.write(n3);
            }
        }

        private final void write_helper_start_sequence(int n) throws IOException {
            this._expected_count = IonUTF8.getUTF8LengthFromFirstByte(n);
            this._pending_count = 1;
            this._pending_c1 = n;
        }

        private final void write_helper_continue(int n) throws IOException {
            ++this._pending_count;
            if (this._expected_count == this._pending_count) {
                this.write_helper_write_char(n);
            } else {
                switch (this._pending_count) {
                    case 2: {
                        this._pending_c2 = n;
                        break;
                    }
                    case 3: {
                        this._pending_c3 = n;
                        break;
                    }
                    default: {
                        throw new IOException("invalid state for pending vs expected UTF8 bytes");
                    }
                }
            }
        }

        private final void write_helper_write_char(int n) throws IOException {
            switch (this._pending_count) {
                case 2: {
                    if (!IonUTF8.isContinueByteUTF8(n)) {
                        this.throwBadContinuationByte();
                    }
                    char c = IonUTF8.twoByteScalar(this._pending_c1, n);
                    this._char_stream.append(c);
                    break;
                }
                case 3: {
                    int n2;
                    if (!IonUTF8.isContinueByteUTF8(n)) {
                        this.throwBadContinuationByte();
                    }
                    if (!IonUTF8.isContinueByteUTF8(this._pending_c2)) {
                        this.throwBadContinuationByte();
                    }
                    if (IonUTF8.needsSurrogateEncoding(n2 = IonUTF8.threeByteScalar(this._pending_c1, this._pending_c2, n))) {
                        this._char_stream.append(IonUTF8.lowSurrogate(n2));
                        this._char_stream.append(IonUTF8.highSurrogate(n2));
                        break;
                    }
                    this._char_stream.append((char)n2);
                    break;
                }
                case 4: {
                    int n3;
                    if (!IonUTF8.isContinueByteUTF8(n)) {
                        this.throwBadContinuationByte();
                    }
                    if (!IonUTF8.isContinueByteUTF8(this._pending_c2)) {
                        this.throwBadContinuationByte();
                    }
                    if (!IonUTF8.isContinueByteUTF8(this._pending_c3)) {
                        this.throwBadContinuationByte();
                    }
                    if (IonUTF8.needsSurrogateEncoding(n3 = IonUTF8.fourByteScalar(this._pending_c1, this._pending_c2, this._pending_c3, n))) {
                        this._char_stream.append(IonUTF8.lowSurrogate(n3));
                        this._char_stream.append(IonUTF8.highSurrogate(n3));
                        break;
                    }
                    this._char_stream.append((char)n3);
                    break;
                }
                default: {
                    throw new IOException("invalid state for UTF8 sequence length " + this._pending_count);
                }
            }
        }

        private void throwBadContinuationByte() throws IOException {
            throw new IOException("continuation byte expected");
        }
    }

    public static class InvalidUnicodeCodePoint
    extends IonException {
        private static final long serialVersionUID = -3200811216940328945L;

        public InvalidUnicodeCodePoint() {
            super("invalid UTF8");
        }

        public InvalidUnicodeCodePoint(String string) {
            super(string);
        }

        public InvalidUnicodeCodePoint(Exception exception) {
            super(exception);
        }

        public InvalidUnicodeCodePoint(String string, Exception exception) {
            super(string, exception);
        }
    }
}

