/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonDatagram;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonStruct;
import software.amazon.ion.IonSymbol;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.SeekableReader;
import software.amazon.ion.Span;
import software.amazon.ion.SpanProvider;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.ValueFactory;
import software.amazon.ion.impl.DowncastingFaceted;
import software.amazon.ion.impl.IonReaderTreeSystem;
import software.amazon.ion.impl.PrivateReaderWriter;
import software.amazon.ion.impl.PrivateUtils;

final class IonReaderTreeUserX
extends IonReaderTreeSystem
implements PrivateReaderWriter {
    IonCatalog _catalog;
    private int _symbol_table_top = 0;
    private SymbolTable[] _symbol_table_stack = new SymbolTable[3];

    public IonReaderTreeUserX(IonValue ionValue, IonCatalog ionCatalog) {
        super(ionValue);
        this._catalog = ionCatalog;
    }

    @Override
    public IonType next() {
        if (!this.next_helper_user()) {
            this._curr = null;
            return null;
        }
        this._curr = this._next;
        this._next = null;
        return this._curr.getType();
    }

    private boolean next_helper_user() {
        IonType ionType;
        if (this._eof) {
            return false;
        }
        if (this._next != null) {
            return true;
        }
        this.clear_system_value_stack();
        while (true) {
            Object object;
            ionType = this.next_helper_system();
            if (this._top != 0 || !(this._parent instanceof IonDatagram)) break;
            if (IonType.SYMBOL.equals((Object)ionType)) {
                Object object2;
                assert (this._next instanceof IonSymbol);
                object = (IonSymbol)((Object)this._next);
                if (object.isNullValue()) break;
                int n = object.symbolValue().getSid();
                if (n == -1 && (object2 = object.stringValue()) != null) {
                    n = this._system.getSystemSymbolTable().findSymbol((String)object2);
                }
                if (n != 2 || this._next.getTypeAnnotationSymbols().length != 0) break;
                object2 = this._system.getSystemSymbolTable();
                this.set_symbol_table((SymbolTable)object2);
                this.push_symbol_table((SymbolTable)object2);
                this._next = null;
                continue;
            }
            if (!IonType.STRUCT.equals((Object)ionType) || !this._next.hasTypeAnnotation("$ion_symbol_table")) break;
            assert (this._next instanceof IonStruct);
            object = new IonReaderTreeUserX(this._next, this._catalog);
            SymbolTable symbolTable = PrivateUtils.newLocalSymtab((ValueFactory)this._system, this._system.getSystemSymbolTable(), this._system.getCatalog(), (IonReader)object, false);
            this.set_symbol_table(symbolTable);
            this.push_symbol_table(symbolTable);
            this._next = null;
        }
        return ionType != null;
    }

    private void clear_system_value_stack() {
        while (this._symbol_table_top > 0) {
            --this._symbol_table_top;
            this._symbol_table_stack[this._symbol_table_top] = null;
        }
    }

    private void push_symbol_table(SymbolTable symbolTable) {
        assert (symbolTable != null);
        if (this._symbol_table_top >= this._symbol_table_stack.length) {
            int n = this._symbol_table_stack.length * 2;
            SymbolTable[] symbolTableArray = new SymbolTable[n];
            System.arraycopy(this._symbol_table_stack, 0, symbolTableArray, 0, this._symbol_table_stack.length);
            this._symbol_table_stack = symbolTableArray;
        }
        this._symbol_table_stack[this._symbol_table_top++] = symbolTable;
    }

    @Override
    public SymbolTable pop_passed_symbol_table() {
        if (this._symbol_table_top <= 0) {
            return null;
        }
        --this._symbol_table_top;
        SymbolTable symbolTable = this._symbol_table_stack[this._symbol_table_top];
        this._symbol_table_stack[this._symbol_table_top] = null;
        return symbolTable;
    }

    private final Span currentSpanImpl() {
        if (this._curr == null) {
            throw new IllegalStateException("Reader has no current value");
        }
        TreeSpan treeSpan = new TreeSpan();
        treeSpan._value = this._curr;
        return treeSpan;
    }

    private void hoistImpl(Span span) {
        if (!(span instanceof TreeSpan)) {
            throw new IllegalArgumentException("Span not appropriate for this reader");
        }
        TreeSpan treeSpan = (TreeSpan)span;
        this.re_init(treeSpan._value, true);
    }

    @Override
    public <T> T asFacet(Class<T> clazz) {
        if (clazz == SeekableReader.class || clazz == SpanProvider.class) {
            return clazz.cast(new SeekableReaderFacet());
        }
        return super.asFacet(clazz);
    }

    private class SeekableReaderFacet
    implements SeekableReader {
        private SeekableReaderFacet() {
        }

        @Override
        public Span currentSpan() {
            return IonReaderTreeUserX.this.currentSpanImpl();
        }

        @Override
        public void hoist(Span span) {
            IonReaderTreeUserX.this.hoistImpl(span);
        }
    }

    private static final class TreeSpan
    extends DowncastingFaceted
    implements Span {
        IonValue _value;

        private TreeSpan() {
        }
    }
}

