/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.util.regex.Pattern;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonType;
import software.amazon.ion.OffsetSpan;
import software.amazon.ion.SeekableReader;
import software.amazon.ion.Span;
import software.amazon.ion.SpanProvider;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.TextSpan;
import software.amazon.ion.UnsupportedIonVersionException;
import software.amazon.ion.ValueFactory;
import software.amazon.ion.impl.DowncastingFaceted;
import software.amazon.ion.impl.IonReaderTextSystemX;
import software.amazon.ion.impl.PrivateReaderWriter;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.UnifiedDataPageX;
import software.amazon.ion.impl.UnifiedInputStreamX;

class IonReaderTextUserX
extends IonReaderTextSystemX
implements PrivateReaderWriter {
    private static final Pattern ION_VERSION_MARKER_REGEX = Pattern.compile("^\\$ion_[0-9]+_[0-9]+$");
    private final int _physical_start_offset;
    IonCatalog _catalog;
    SymbolTable _symbols;
    private int _symbol_table_top = 0;
    private SymbolTable[] _symbol_table_stack = new SymbolTable[3];

    protected IonReaderTextUserX(IonSystem ionSystem, IonCatalog ionCatalog, UnifiedInputStreamX unifiedInputStreamX, int n) {
        super(ionSystem, unifiedInputStreamX);
        this._physical_start_offset = n;
        this.initUserReader(ionSystem, ionCatalog);
    }

    protected IonReaderTextUserX(IonSystem ionSystem, IonCatalog ionCatalog, UnifiedInputStreamX unifiedInputStreamX) {
        super(ionSystem, unifiedInputStreamX);
        this._physical_start_offset = 0;
        this.initUserReader(ionSystem, ionCatalog);
    }

    private void initUserReader(IonSystem ionSystem, IonCatalog ionCatalog) {
        if (ionSystem == null) {
            throw new IllegalArgumentException();
        }
        this._system = ionSystem;
        this._catalog = ionCatalog != null ? ionCatalog : ionSystem.getCatalog();
    }

    @Override
    public IonSystem getSystem() {
        return this._system;
    }

    @Override
    boolean hasNext() {
        boolean bl = this.has_next_user_value();
        return bl;
    }

    private final boolean has_next_user_value() {
        this.clear_system_value_stack();
        block4: while (!this._has_next_called) {
            this.has_next_raw_value();
            if (this._value_type == null || this.isNullValue() || !IonType.DATAGRAM.equals((Object)this.getContainerType())) continue;
            switch (this._value_type) {
                case STRUCT: {
                    if (this._annotation_count <= 0) continue block4;
                    for (int i = 0; i < this._annotation_count; ++i) {
                        SymbolToken symbolToken = this._annotations[i];
                        if (!"$ion_symbol_table".equals(symbolToken.getText())) continue;
                        this._symbols = PrivateUtils.newLocalSymtab((ValueFactory)this._system, this._system.getSystemSymbolTable(), this._catalog, this, true);
                        this.push_symbol_table(this._symbols);
                        this._has_next_called = false;
                        continue block4;
                    }
                    continue block4;
                }
                case SYMBOL: {
                    String string;
                    if (this._annotation_count != 0 || !IonReaderTextUserX.isIonVersionMarker(string = this.symbolValue().getText())) continue block4;
                    if ("$ion_1_0".equals(string)) {
                        this.symbol_table_reset();
                        this.push_symbol_table(this._system.getSystemSymbolTable());
                        this._has_next_called = false;
                        continue block4;
                    }
                    throw new UnsupportedIonVersionException(string);
                }
            }
        }
        return !this._eof;
    }

    private static boolean isIonVersionMarker(String string) {
        return string != null && ION_VERSION_MARKER_REGEX.matcher(string).matches();
    }

    private final void symbol_table_reset() {
        IonType ionType = this.next();
        assert (IonType.SYMBOL.equals((Object)ionType));
        this._symbols = null;
    }

    @Override
    public SymbolTable getSymbolTable() {
        if (this._symbols == null) {
            SymbolTable symbolTable = this._system.getSystemSymbolTable();
            this._symbols = PrivateUtils.newLocalSymtab((ValueFactory)this._system, symbolTable, new SymbolTable[0]);
        }
        return this._symbols;
    }

    private void clear_system_value_stack() {
        while (this._symbol_table_top > 0) {
            --this._symbol_table_top;
            this._symbol_table_stack[this._symbol_table_top] = null;
        }
    }

    private void push_symbol_table(SymbolTable symbolTable) {
        assert (symbolTable != null);
        if (this._symbol_table_top >= this._symbol_table_stack.length) {
            int n = this._symbol_table_stack.length * 2;
            SymbolTable[] symbolTableArray = new SymbolTable[n];
            System.arraycopy(this._symbol_table_stack, 0, symbolTableArray, 0, this._symbol_table_stack.length);
            this._symbol_table_stack = symbolTableArray;
        }
        this._symbol_table_stack[this._symbol_table_top++] = symbolTable;
    }

    @Override
    public SymbolTable pop_passed_symbol_table() {
        if (this._symbol_table_top <= 0) {
            return null;
        }
        --this._symbol_table_top;
        SymbolTable symbolTable = this._symbol_table_stack[this._symbol_table_top];
        this._symbol_table_stack[this._symbol_table_top] = null;
        return symbolTable;
    }

    public Span currentSpanImpl() {
        if (this.getType() == null) {
            throw new IllegalStateException("must be on a value");
        }
        IonReaderTextSpan ionReaderTextSpan = new IonReaderTextSpan(this);
        return ionReaderTextSpan;
    }

    private void hoistImpl(Span span) {
        UnifiedInputStreamX unifiedInputStreamX;
        Object object;
        if (!(span instanceof IonReaderTextSpan)) {
            throw new IllegalArgumentException("position must match the reader");
        }
        IonReaderTextSpan ionReaderTextSpan = (IonReaderTextSpan)span;
        UnifiedInputStreamX unifiedInputStreamX2 = this._scanner.getSourceStream();
        UnifiedDataPageX unifiedDataPageX = ionReaderTextSpan.getDataPage();
        int n = (int)ionReaderTextSpan._start_offset + this._physical_start_offset;
        int n2 = unifiedDataPageX._page_limit;
        int n3 = n2 - n;
        assert (ionReaderTextSpan.getStartOffset() <= Integer.MAX_VALUE);
        if (unifiedInputStreamX2._is_byte_data) {
            object = unifiedInputStreamX2.getByteArray();
            assert (object != null);
            unifiedInputStreamX = UnifiedInputStreamX.makeStream(object, n, n3);
        } else {
            object = unifiedInputStreamX2.getCharArray();
            assert (object != null);
            unifiedInputStreamX = UnifiedInputStreamX.makeStream((char[])object, n, n3);
        }
        object = (Object)ionReaderTextSpan.getContainerType();
        this.re_init(unifiedInputStreamX, (IonType)((Object)object), ionReaderTextSpan._start_line, ionReaderTextSpan._start_column);
    }

    @Override
    public <T> T asFacet(Class<T> clazz) {
        if (clazz == SpanProvider.class) {
            return clazz.cast(new SpanProviderFacet());
        }
        if (clazz == SeekableReader.class && this._scanner.isBufferedInput()) {
            return clazz.cast(new SeekableReaderFacet());
        }
        return super.asFacet(clazz);
    }

    private final class SeekableReaderFacet
    extends SpanProviderFacet
    implements SeekableReader {
        private SeekableReaderFacet() {
        }

        @Override
        public void hoist(Span span) {
            IonReaderTextUserX.this.hoistImpl(span);
        }
    }

    private class SpanProviderFacet
    implements SpanProvider {
        private SpanProviderFacet() {
        }

        @Override
        public Span currentSpan() {
            return IonReaderTextUserX.this.currentSpanImpl();
        }
    }

    private static final class IonReaderTextSpan
    extends DowncastingFaceted
    implements OffsetSpan,
    Span,
    TextSpan {
        private final UnifiedDataPageX _data_page;
        private final IonType _container_type;
        private final long _start_offset;
        private final long _start_line;
        private final long _start_column;

        IonReaderTextSpan(IonReaderTextUserX ionReaderTextUserX) {
            UnifiedInputStreamX unifiedInputStreamX = ionReaderTextUserX._scanner.getSourceStream();
            this._data_page = unifiedInputStreamX._buffer.getCurrentPage();
            this._container_type = ionReaderTextUserX.getContainerType();
            this._start_offset = ionReaderTextUserX._value_start_offset - (long)ionReaderTextUserX._physical_start_offset;
            this._start_line = ionReaderTextUserX._value_start_line;
            this._start_column = ionReaderTextUserX._value_start_column;
        }

        @Override
        public long getStartLine() {
            if (this._start_line < 1L) {
                throw new IllegalStateException("not positioned on a reader");
            }
            return this._start_line;
        }

        @Override
        public long getStartColumn() {
            if (this._start_column < 0L) {
                throw new IllegalStateException("not positioned on a reader");
            }
            return this._start_column;
        }

        @Override
        public long getFinishLine() {
            return -1L;
        }

        @Override
        public long getFinishColumn() {
            return -1L;
        }

        @Override
        public long getStartOffset() {
            return this._start_offset;
        }

        @Override
        public long getFinishOffset() {
            return -1L;
        }

        IonType getContainerType() {
            return this._container_type;
        }

        UnifiedDataPageX getDataPage() {
            return this._data_page;
        }
    }
}

