/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import software.amazon.ion.Decimal;
import software.amazon.ion.IntegerSize;
import software.amazon.ion.IonBlob;
import software.amazon.ion.IonClob;
import software.amazon.ion.IonException;
import software.amazon.ion.IonList;
import software.amazon.ion.IonSequence;
import software.amazon.ion.IonSexp;
import software.amazon.ion.IonStruct;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonTimestamp;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.Timestamp;
import software.amazon.ion.UnknownSymbolException;
import software.amazon.ion.impl.IonReaderTextRawTokensX;
import software.amazon.ion.impl.IonReaderTextRawX;
import software.amazon.ion.impl.IonTokenConstsX;
import software.amazon.ion.impl.PrivateReaderWriter;
import software.amazon.ion.impl.PrivateScalarConversions;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.SymbolTokenImpl;
import software.amazon.ion.impl.UnifiedInputStreamX;

class IonReaderTextSystemX
extends IonReaderTextRawX
implements PrivateReaderWriter {
    private static int UNSIGNED_BYTE_MAX_VALUE = 255;
    protected IonSystem _system;

    protected IonReaderTextSystemX(IonSystem ionSystem, UnifiedInputStreamX unifiedInputStreamX) {
        this._system = ionSystem;
        this.init_once();
        this.init(unifiedInputStreamX, IonType.DATAGRAM);
    }

    public IonSystem getSystem() {
        return this._system;
    }

    @Override
    public IntegerSize getIntegerSize() {
        this.load_once();
        if (this._value_type != IonType.INT || this._v.isNull()) {
            return null;
        }
        return PrivateScalarConversions.getIntegerSize(this._v.getAuthoritativeType());
    }

    private void load_once() {
        if (this._v.isEmpty()) {
            try {
                this.load_scalar_value();
            }
            catch (IOException iOException) {
                throw new IonException(iOException);
            }
        }
    }

    private final void load_or_cast_cached_value(int n) {
        this.load_once();
        if (n != 0 && !this._v.hasValueOfType(n)) {
            this.cast_cached_value(n);
        }
    }

    private final void load_scalar_value() throws IOException {
        char c;
        int n;
        switch (this._value_type) {
            case NULL: {
                this._v.setValueToNull(this._null_type);
                this._v.setAuthoritativeType(1);
                return;
            }
            case BOOL: 
            case INT: 
            case FLOAT: 
            case DECIMAL: 
            case TIMESTAMP: 
            case SYMBOL: 
            case STRING: {
                break;
            }
            default: {
                return;
            }
        }
        StringBuilder stringBuilder = this.token_contents_load(this._scanner.getToken());
        int n2 = this._scanner.getToken();
        if (this._value_type == IonType.DECIMAL) {
            for (n = 0; n < stringBuilder.length(); ++n) {
                c = stringBuilder.charAt(n);
                if (c != 'd' && c != 'D') continue;
                stringBuilder.setCharAt(n, 'e');
                break;
            }
        } else if (n2 == 3) {
            n = stringBuilder.charAt(0) == '-' ? 1 : 0;
            c = n != 0 ? (char)'\u0001' : '\u0000';
            assert (stringBuilder.length() > 2 && stringBuilder.charAt(c) == '0' && (stringBuilder.charAt(c + '\u0001') == 'x' || stringBuilder.charAt(c + '\u0001') == 'X'));
            stringBuilder.deleteCharAt(c);
            stringBuilder.deleteCharAt(c);
        } else if (n2 == 26) {
            n = stringBuilder.charAt(0) == '-' ? 1 : 0;
            c = n != 0 ? (char)'\u0001' : '\u0000';
            stringBuilder.deleteCharAt(c);
            stringBuilder.deleteCharAt(c);
        }
        n = stringBuilder.length();
        String string = stringBuilder.toString();
        this.clear_current_value_buffer();
        block9 : switch (n2) {
            case 1: {
                switch (this._value_type) {
                    case INT: {
                        if (Radix.DECIMAL.isInt(string, n)) {
                            this._v.setValue(Integer.parseInt(string));
                            break block9;
                        }
                        if (Radix.DECIMAL.isLong(string, n)) {
                            this._v.setValue(Long.parseLong(string));
                            break block9;
                        }
                        this._v.setValue(new BigInteger(string));
                        break block9;
                    }
                    case DECIMAL: {
                        try {
                            this._v.setValue(Decimal.valueOf(string));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.parse_error(numberFormatException);
                        }
                        break block9;
                    }
                    case FLOAT: {
                        try {
                            this._v.setValue(Double.parseDouble(string));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.parse_error(numberFormatException);
                        }
                        break block9;
                    }
                    case TIMESTAMP: {
                        this._v.setValue(Timestamp.valueOf(string));
                        break block9;
                    }
                }
                String string2 = "unexpected prefectched value type " + this.getType().toString() + " encountered handling an unquoted symbol";
                this.parse_error(string2);
                break;
            }
            case 2: {
                if (Radix.DECIMAL.isInt(string, n)) {
                    this._v.setValue(Integer.parseInt(string));
                    break;
                }
                if (Radix.DECIMAL.isLong(string, n)) {
                    this._v.setValue(Long.parseLong(string));
                    break;
                }
                this._v.setValue(new BigInteger(string));
                break;
            }
            case 26: {
                if (Radix.BINARY.isInt(string, n)) {
                    this._v.setValue(Integer.parseInt(string, 2));
                    break;
                }
                if (Radix.BINARY.isLong(string, n)) {
                    this._v.setValue(Long.parseLong(string, 2));
                    break;
                }
                this._v.setValue(new BigInteger(string, 2));
                break;
            }
            case 3: {
                if (Radix.HEX.isInt(string, n)) {
                    int n3 = Integer.parseInt(string, 16);
                    this._v.setValue(n3);
                    break;
                }
                if (Radix.HEX.isLong(string, n)) {
                    long l = Long.parseLong(string, 16);
                    this._v.setValue(l);
                    break;
                }
                BigInteger bigInteger = new BigInteger(string, 16);
                this._v.setValue(bigInteger);
                break;
            }
            case 4: {
                try {
                    this._v.setValue(Decimal.valueOf(string));
                }
                catch (NumberFormatException numberFormatException) {
                    this.parse_error(numberFormatException);
                }
                break;
            }
            case 5: {
                try {
                    this._v.setValue(Double.parseDouble(string));
                }
                catch (NumberFormatException numberFormatException) {
                    this.parse_error(numberFormatException);
                }
                break;
            }
            case 8: {
                Timestamp timestamp = null;
                try {
                    timestamp = Timestamp.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.parse_error(illegalArgumentException);
                }
                this._v.setValue(timestamp);
                break;
            }
            case 9: {
                if (this.isNullValue()) {
                    this._v.setValueToNull(this._null_type);
                    break;
                }
                switch (this.getType()) {
                    case SYMBOL: {
                        this._v.setValue(string);
                        break block9;
                    }
                    case FLOAT: {
                        switch (this._value_keyword) {
                            case 16: {
                                this._v.setValue(Double.NaN);
                                break block9;
                            }
                        }
                        String string3 = "unexpected keyword " + string + " identified as a FLOAT";
                        this.parse_error(string3);
                        break block9;
                    }
                    case BOOL: {
                        switch (this._value_keyword) {
                            case 1: {
                                this._v.setValue(true);
                                break block9;
                            }
                            case 2: {
                                this._v.setValue(false);
                                break block9;
                            }
                        }
                        String string4 = "unexpected keyword " + string + " identified as a BOOL";
                        this.parse_error(string4);
                        break block9;
                    }
                }
                String string5 = "unexpected prefectched value type " + this.getType().toString() + " encountered handling an unquoted symbol";
                this.parse_error(string5);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                this._v.setValue(string);
                break;
            }
            case 13: {
                this._v.setValue(string);
                break;
            }
            default: {
                this.parse_error("scalar token " + IonTokenConstsX.getTokenName(this._scanner.getToken()) + "isn't a recognized type");
            }
        }
    }

    private final void cast_cached_value(int n) {
        block8: {
            block7: {
                assert (!this._v.hasValueOfType(n));
                if (this._v.isNull()) {
                    return;
                }
                if (!IonType.SYMBOL.equals((Object)this._value_type)) break block7;
                switch (n) {
                    case 8: {
                        int n2 = this._v.getInt();
                        String string = this.getSymbolTable().findKnownSymbol(n2);
                        this._v.addValue(string);
                        break block8;
                    }
                    case 3: {
                        String string = this._v.getString();
                        int n3 = this.getSymbolTable().findSymbol(string);
                        this._v.addValue(n3);
                        break block8;
                    }
                    default: {
                        String string = "can't cast symbol from " + PrivateScalarConversions.getValueTypeName(this._v.getAuthoritativeType()) + " to " + PrivateScalarConversions.getValueTypeName(n);
                        throw new PrivateScalarConversions.CantConvertException(string);
                    }
                }
            }
            if (!this._v.can_convert(n)) {
                String string = "can't cast from " + PrivateScalarConversions.getValueTypeName(this._v.getAuthoritativeType()) + " to " + PrivateScalarConversions.getValueTypeName(n);
                throw new PrivateScalarConversions.CantConvertException(string);
            }
            int n4 = this._v.get_conversion_fnid(n);
            this._v.cast(n4);
        }
    }

    @Override
    public SymbolToken[] getTypeAnnotationSymbols() {
        int n = this._annotation_count;
        if (n == 0) {
            return SymbolToken.EMPTY_ARRAY;
        }
        SymbolTable symbolTable = this.getSymbolTable();
        SymbolToken[] symbolTokenArray = new SymbolToken[n];
        for (int i = 0; i < n; ++i) {
            SymbolToken symbolToken = this._annotations[i];
            SymbolToken symbolToken2 = PrivateUtils.localize(symbolTable, symbolToken);
            if (symbolToken2 != symbolToken) {
                this._annotations[i] = symbolToken2;
            }
            symbolTokenArray[i] = symbolToken2;
        }
        return symbolTokenArray;
    }

    @Override
    public boolean isNullValue() {
        return this._v.isNull();
    }

    @Override
    public boolean booleanValue() {
        this.load_or_cast_cached_value(2);
        return this._v.getBoolean();
    }

    @Override
    public double doubleValue() {
        this.load_or_cast_cached_value(7);
        return this._v.getDouble();
    }

    @Override
    public int intValue() {
        if (this._value_type != IonType.INT && this._value_type != IonType.DECIMAL && this._value_type != IonType.FLOAT) {
            throw new IllegalStateException();
        }
        this.load_or_cast_cached_value(3);
        return this._v.getInt();
    }

    @Override
    public long longValue() {
        if (this._value_type != IonType.INT && this._value_type != IonType.DECIMAL && this._value_type != IonType.FLOAT) {
            throw new IllegalStateException();
        }
        this.load_or_cast_cached_value(4);
        return this._v.getLong();
    }

    @Override
    public BigInteger bigIntegerValue() {
        if (this._value_type != IonType.INT && this._value_type != IonType.DECIMAL && this._value_type != IonType.FLOAT) {
            throw new IllegalStateException();
        }
        this.load_or_cast_cached_value(5);
        if (this._v.isNull()) {
            return null;
        }
        return this._v.getBigInteger();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        this.load_or_cast_cached_value(6);
        if (this._v.isNull()) {
            return null;
        }
        return this._v.getBigDecimal();
    }

    @Override
    public Decimal decimalValue() {
        this.load_or_cast_cached_value(6);
        if (this._v.isNull()) {
            return null;
        }
        return this._v.getDecimal();
    }

    @Override
    public Date dateValue() {
        this.load_or_cast_cached_value(9);
        if (this._v.isNull()) {
            return null;
        }
        return this._v.getDate();
    }

    @Override
    public Timestamp timestampValue() {
        this.load_or_cast_cached_value(10);
        if (this._v.isNull()) {
            return null;
        }
        return this._v.getTimestamp();
    }

    @Override
    public final String stringValue() {
        if (!IonType.isText(this._value_type)) {
            throw new IllegalStateException();
        }
        if (this._v.isNull()) {
            return null;
        }
        this.load_or_cast_cached_value(8);
        String string = this._v.getString();
        if (string == null) {
            assert (this._value_type == IonType.SYMBOL);
            int n = this._v.getInt();
            assert (n > 0);
            throw new UnknownSymbolException(n);
        }
        return string;
    }

    @Override
    public SymbolTable getSymbolTable() {
        SymbolTable symbolTable = super.getSymbolTable();
        if (symbolTable == null) {
            symbolTable = this._system.getSystemSymbolTable();
        }
        return symbolTable;
    }

    @Override
    final int getFieldId() {
        String string;
        int n = super.getFieldId();
        if (n == -1 && (string = this.getRawFieldName()) != null) {
            SymbolTable symbolTable = this.getSymbolTable();
            n = symbolTable.findSymbol(string);
        }
        return n;
    }

    @Override
    public final String getFieldName() {
        SymbolTable symbolTable;
        int n;
        String string = this.getRawFieldName();
        if (string == null && (n = this.getFieldId()) != -1 && (string = (symbolTable = this.getSymbolTable()).findKnownSymbol(n)) == null) {
            throw new UnknownSymbolException(n);
        }
        return string;
    }

    @Override
    public final SymbolToken getFieldNameSymbol() {
        SymbolToken symbolToken = super.getFieldNameSymbol();
        if (symbolToken != null) {
            symbolToken = PrivateUtils.localize(this.getSymbolTable(), symbolToken);
        }
        return symbolToken;
    }

    @Override
    public SymbolToken symbolValue() {
        if (this._value_type != IonType.SYMBOL) {
            throw new IllegalStateException();
        }
        if (this._v.isNull()) {
            return null;
        }
        this.load_or_cast_cached_value(8);
        if (!this._v.hasValueOfType(3)) {
            this.cast_cached_value(3);
        }
        String string = this._v.getString();
        int n = this._v.getInt();
        return new SymbolTokenImpl(string, n);
    }

    @Override
    public int byteSize() {
        long l;
        this.ensureLob("byteSize");
        try {
            l = this.load_lob_contents();
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
        if (l < 0L || l > Integer.MAX_VALUE) {
            this.load_lob_length_overflow_error(l);
        }
        return (int)l;
    }

    private final void load_lob_length_overflow_error(long l) {
        String string = "Size overflow: " + this._value_type.toString() + " size (" + Long.toString(l) + ") exceeds int ";
        throw new IonException(string);
    }

    private final long load_lob_save_point() throws IOException {
        if (this._lob_loaded == IonReaderTextRawX.LOB_STATE.EMPTY) {
            assert (!this._current_value_save_point_loaded && this._current_value_save_point.isClear());
            this._scanner.save_point_start(this._current_value_save_point);
            this._scanner.skip_over_lob(this._lob_token, this._current_value_save_point);
            this._current_value_save_point_loaded = true;
            this.tokenValueIsFinished();
            this._lob_loaded = IonReaderTextRawX.LOB_STATE.READ;
        }
        long l = this._current_value_save_point.length();
        return l;
    }

    private int load_lob_contents() throws IOException {
        if (this._lob_loaded == IonReaderTextRawX.LOB_STATE.EMPTY) {
            this.load_lob_save_point();
        }
        if (this._lob_loaded == IonReaderTextRawX.LOB_STATE.READ) {
            long l = this._current_value_save_point.length();
            if (l < 0L || l > Integer.MAX_VALUE) {
                this.load_lob_length_overflow_error(l);
            }
            this._lob_bytes = new byte[(int)l];
            try {
                assert (this._current_value_save_point_loaded && this._current_value_save_point.isDefined());
                this._scanner.save_point_activate(this._current_value_save_point);
                this._lob_actual_len = this.readBytes(this._lob_bytes, 0, (int)l);
                this._scanner.save_point_deactivate(this._current_value_save_point);
            }
            catch (IOException iOException) {
                throw new IonException(iOException);
            }
            assert ((long)this._lob_actual_len <= l);
            this._lob_loaded = IonReaderTextRawX.LOB_STATE.FINISHED;
        }
        assert (this._lob_loaded == IonReaderTextRawX.LOB_STATE.FINISHED);
        return this._lob_actual_len;
    }

    private void ensureLob(String string) {
        switch (this._value_type) {
            case CLOB: 
            case BLOB: {
                break;
            }
            default: {
                String string2 = string + " is only valid if the reader is on a lob value, not a " + (Object)((Object)this._value_type) + " value";
                throw new IllegalStateException(string2);
            }
        }
    }

    @Override
    public byte[] newBytes() {
        int n;
        this.ensureLob("newBytes");
        try {
            n = this.load_lob_contents();
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this._lob_bytes, 0, byArray, 0, n);
        return byArray;
    }

    @Override
    public int getBytes(byte[] byArray, int n, int n2) {
        int n3;
        this.ensureLob("getBytes");
        if (this._lob_loaded == IonReaderTextRawX.LOB_STATE.READ) {
            try {
                this.load_lob_contents();
            }
            catch (IOException iOException) {
                throw new IonException(iOException);
            }
        }
        if (this._lob_loaded == IonReaderTextRawX.LOB_STATE.FINISHED) {
            n3 = n2;
            if (n3 > this._lob_actual_len) {
                n3 = this._lob_actual_len;
            }
            System.arraycopy(this._lob_bytes, 0, byArray, n, n3);
        } else {
            try {
                if (this._current_value_save_point_loaded && this._lob_value_position > 0L) {
                    if (this._current_value_save_point.isActive()) {
                        this._scanner.save_point_deactivate(this._current_value_save_point);
                    }
                    this._scanner.save_point_activate(this._current_value_save_point);
                    this._lob_value_position = 0L;
                }
                assert (this._current_value_save_point_loaded && this._current_value_save_point.isDefined());
                this._scanner.save_point_activate(this._current_value_save_point);
                n3 = this.readBytes(byArray, n, n2);
                this._scanner.save_point_deactivate(this._current_value_save_point);
            }
            catch (IOException iOException) {
                throw new IonException(iOException);
            }
        }
        return n3;
    }

    private int readBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = -1;
        block0 : switch (this._lob_token) {
            case 24: {
                while (n2-- > 0 && (n4 = this._scanner.read_base64_byte()) >= 0) {
                    byArray[n++] = (byte)n4;
                }
                break;
            }
            case 12: {
                while (n2-- > 0) {
                    n4 = this._scanner.read_double_quoted_char(true);
                    if (n4 < 0) {
                        if (n4 != -7 && n4 != -8 && n4 != -9) break block0;
                        continue;
                    }
                    assert (n4 >= 0 && n4 <= UNSIGNED_BYTE_MAX_VALUE);
                    byArray[n++] = (byte)n4;
                }
                break;
            }
            case 13: {
                while (n2-- > 0) {
                    n4 = this._scanner.read_triple_quoted_char(true);
                    if (n4 < 0) {
                        if (n4 == -7 || n4 == -8 || n4 == -9 || n4 == -3) continue;
                        if (n4 != -4 && n4 != -5 && n4 != -6) break block0;
                        byArray[n++] = 10;
                        continue;
                    }
                    assert (n4 >= 0 && n4 <= UNSIGNED_BYTE_MAX_VALUE);
                    byArray[n++] = (byte)n4;
                }
                break;
            }
            default: {
                String string = "invalid type [" + this._value_type.toString() + "] for lob handling";
                throw new IonReaderTextRawTokensX.IonReaderTextTokenException(string);
            }
        }
        if (n4 == -1) {
            this._scanner.tokenIsFinished();
        }
        int n5 = n - n3;
        this._lob_value_position += (long)n5;
        return n5;
    }

    public IonValue getIonValue(IonSystem ionSystem) {
        if (this.isNullValue()) {
            switch (this._value_type) {
                case NULL: {
                    return ionSystem.newNull();
                }
                case BOOL: {
                    return ionSystem.newNullBool();
                }
                case INT: {
                    return ionSystem.newNullInt();
                }
                case FLOAT: {
                    return ionSystem.newNullFloat();
                }
                case DECIMAL: {
                    return ionSystem.newNullDecimal();
                }
                case TIMESTAMP: {
                    return ionSystem.newNullTimestamp();
                }
                case SYMBOL: {
                    return ionSystem.newNullSymbol();
                }
                case STRING: {
                    return ionSystem.newNullString();
                }
                case CLOB: {
                    return ionSystem.newNullClob();
                }
                case BLOB: {
                    return ionSystem.newNullBlob();
                }
                case LIST: {
                    return ionSystem.newNullList();
                }
                case SEXP: {
                    return ionSystem.newNullSexp();
                }
                case STRUCT: {
                    return ionSystem.newNullString();
                }
            }
            throw new IonException("unrecognized type encountered");
        }
        switch (this._value_type) {
            case NULL: {
                return ionSystem.newNull();
            }
            case BOOL: {
                return ionSystem.newBool(this.booleanValue());
            }
            case INT: {
                return ionSystem.newInt(this.longValue());
            }
            case FLOAT: {
                return ionSystem.newFloat(this.doubleValue());
            }
            case DECIMAL: {
                return ionSystem.newDecimal(this.decimalValue());
            }
            case TIMESTAMP: {
                IonTimestamp ionTimestamp = ionSystem.newNullTimestamp();
                Timestamp timestamp = this.timestampValue();
                ionTimestamp.setValue(timestamp);
                return ionTimestamp;
            }
            case SYMBOL: {
                return ionSystem.newSymbol(this.stringValue());
            }
            case STRING: {
                return ionSystem.newString(this.stringValue());
            }
            case CLOB: {
                IonClob ionClob = ionSystem.newNullClob();
                ionClob.setBytes(this.newBytes());
                return ionClob;
            }
            case BLOB: {
                IonBlob ionBlob = ionSystem.newNullBlob();
                ionBlob.setBytes(this.newBytes());
                return ionBlob;
            }
            case LIST: {
                IonList ionList = ionSystem.newNullList();
                this.fillContainerList(ionSystem, ionList);
                return ionList;
            }
            case SEXP: {
                IonSexp ionSexp = ionSystem.newNullSexp();
                this.fillContainerList(ionSystem, ionSexp);
                return ionSexp;
            }
            case STRUCT: {
                IonStruct ionStruct = ionSystem.newNullStruct();
                this.fillContainerStruct(ionSystem, ionStruct);
                return ionStruct;
            }
        }
        throw new IonException("unrecognized type encountered");
    }

    private final void fillContainerList(IonSystem ionSystem, IonSequence ionSequence) {
        this.stepIn();
        while (this.next() != null) {
            IonValue ionValue = this.getIonValue(ionSystem);
            ionSequence.add(ionValue);
        }
        this.stepOut();
    }

    private final void fillContainerStruct(IonSystem ionSystem, IonStruct ionStruct) {
        this.stepIn();
        while (this.next() != null) {
            String string = this.getFieldName();
            IonValue ionValue = this.getIonValue(ionSystem);
            ionStruct.add(string, ionValue);
        }
        this.stepOut();
    }

    @Override
    public SymbolTable pop_passed_symbol_table() {
        return null;
    }

    static abstract class Radix
    extends Enum<Radix> {
        public static final /* enum */ Radix DECIMAL = new Radix(){

            @Override
            boolean isInt(String string, int n) {
                return Radix.valueWithinBounds(string, n, MIN_INT_IMAGE, MAX_INT_IMAGE);
            }

            @Override
            boolean isLong(String string, int n) {
                return Radix.valueWithinBounds(string, n, MIN_LONG_IMAGE, MAX_LONG_IMAGE);
            }
        };
        public static final /* enum */ Radix HEX = new Radix(){

            @Override
            boolean isInt(String string, int n) {
                return Radix.valueWithinBounds(string, n, MIN_HEX_INT_IMAGE, MAX_HEX_INT_IMAGE);
            }

            @Override
            boolean isLong(String string, int n) {
                return Radix.valueWithinBounds(string, n, MIN_HEX_LONG_IMAGE, MAX_HEX_LONG_IMAGE);
            }
        };
        public static final /* enum */ Radix BINARY = new Radix(){

            @Override
            boolean isInt(String string, int n) {
                return Radix.valueWithinBounds(string, n, MIN_BINARY_INT_IMAGE, MAX_BINARY_INT_IMAGE);
            }

            @Override
            boolean isLong(String string, int n) {
                return Radix.valueWithinBounds(string, n, MIN_BINARY_LONG_IMAGE, MAX_BINARY_LONG_IMAGE);
            }
        };
        private static final char[] MAX_INT_IMAGE;
        private static final char[] MIN_INT_IMAGE;
        private static final char[] MAX_LONG_IMAGE;
        private static final char[] MIN_LONG_IMAGE;
        private static final char[] MAX_BINARY_INT_IMAGE;
        private static final char[] MIN_BINARY_INT_IMAGE;
        private static final char[] MAX_BINARY_LONG_IMAGE;
        private static final char[] MIN_BINARY_LONG_IMAGE;
        private static final char[] MAX_HEX_INT_IMAGE;
        private static final char[] MIN_HEX_INT_IMAGE;
        private static final char[] MAX_HEX_LONG_IMAGE;
        private static final char[] MIN_HEX_LONG_IMAGE;
        private static final /* synthetic */ Radix[] $VALUES;

        public static Radix[] values() {
            return (Radix[])$VALUES.clone();
        }

        public static Radix valueOf(String string) {
            return Enum.valueOf(Radix.class, string);
        }

        abstract boolean isInt(String var1, int var2);

        abstract boolean isLong(String var1, int var2);

        private static boolean valueWithinBounds(String string, int n, char[] cArray, char[] cArray2) {
            boolean bl = string.charAt(0) == '-';
            char[] cArray3 = bl ? cArray : cArray2;
            int n2 = cArray3.length;
            return n < n2 || n == n2 && Radix.magnitudeLessThanOrEqualTo(string, n, cArray3);
        }

        private static boolean magnitudeLessThanOrEqualTo(String string, int n, char[] cArray) {
            assert (n == cArray.length);
            for (int i = n - 1; i >= 0; --i) {
                if (string.charAt(i) <= cArray[i]) continue;
                return false;
            }
            return true;
        }

        static {
            $VALUES = new Radix[]{DECIMAL, HEX, BINARY};
            MAX_INT_IMAGE = Integer.toString(Integer.MAX_VALUE).toCharArray();
            MIN_INT_IMAGE = Integer.toString(Integer.MIN_VALUE).toCharArray();
            MAX_LONG_IMAGE = Long.toString(Long.MAX_VALUE).toCharArray();
            MIN_LONG_IMAGE = Long.toString(Long.MIN_VALUE).toCharArray();
            MAX_BINARY_INT_IMAGE = Integer.toBinaryString(Integer.MAX_VALUE).toCharArray();
            MIN_BINARY_INT_IMAGE = ("-" + Integer.toBinaryString(Integer.MIN_VALUE)).toCharArray();
            MAX_BINARY_LONG_IMAGE = Long.toBinaryString(Long.MAX_VALUE).toCharArray();
            MIN_BINARY_LONG_IMAGE = ("-" + Long.toBinaryString(Long.MIN_VALUE)).toCharArray();
            MAX_HEX_INT_IMAGE = Integer.toHexString(Integer.MAX_VALUE).toCharArray();
            MIN_HEX_INT_IMAGE = ("-" + Integer.toHexString(Integer.MIN_VALUE)).toCharArray();
            MAX_HEX_LONG_IMAGE = Long.toHexString(Long.MAX_VALUE).toCharArray();
            MIN_HEX_LONG_IMAGE = ("-" + Long.toHexString(Long.MIN_VALUE)).toCharArray();
        }
    }
}

