/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import software.amazon.ion.Decimal;
import software.amazon.ion.IntegerSize;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonType;
import software.amazon.ion.NullValueException;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.Timestamp;
import software.amazon.ion.UnknownSymbolException;
import software.amazon.ion.impl.IonReaderBinaryRawX;
import software.amazon.ion.impl.PrivateReaderWriter;
import software.amazon.ion.impl.PrivateScalarConversions;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.SymbolTokenImpl;
import software.amazon.ion.impl.UnifiedInputStreamX;

class IonReaderBinarySystemX
extends IonReaderBinaryRawX
implements PrivateReaderWriter {
    IonSystem _system;
    SymbolTable _symbols;
    static final BigInteger MIN_LONG_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    static final BigInteger MAX_LONG_VALUE = BigInteger.valueOf(Long.MAX_VALUE);

    IonReaderBinarySystemX(IonSystem ionSystem, UnifiedInputStreamX unifiedInputStreamX) {
        this.init_raw(unifiedInputStreamX);
        this._system = ionSystem;
        this._symbols = ionSystem.getSystemSymbolTable();
    }

    @Override
    public SymbolToken[] getTypeAnnotationSymbols() {
        this.load_annotations();
        int n = this._annotation_count;
        if (n == 0) {
            return SymbolToken.EMPTY_ARRAY;
        }
        SymbolTable symbolTable = this.getSymbolTable();
        SymbolToken[] symbolTokenArray = new SymbolToken[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this._annotation_ids[i];
            String string = symbolTable.findKnownSymbol(n2);
            symbolTokenArray[i] = new SymbolTokenImpl(string, n2);
        }
        return symbolTokenArray;
    }

    private void load_once() {
        if (this._v.isEmpty()) {
            try {
                this.load_scalar_value();
            }
            catch (IOException iOException) {
                this.error(iOException);
            }
        }
    }

    protected final void prepare_value(int n) {
        this.load_once();
        if (n != 0 && !this._v.hasValueOfType(n)) {
            if (IonType.SYMBOL.equals((Object)this._value_type) && !PrivateScalarConversions.ValueVariant.isNumericType(n)) assert (IonType.SYMBOL.equals((Object)this._value_type) && !PrivateScalarConversions.ValueVariant.isNumericType(n));
            if (!this._v.can_convert(n)) {
                String string = "can't cast from " + PrivateScalarConversions.getValueTypeName(this._v.getAuthoritativeType()) + " to " + PrivateScalarConversions.getValueTypeName(n);
                throw new IllegalStateException(string);
            }
            int n2 = this._v.get_conversion_fnid(n);
            this._v.cast(n2);
        }
    }

    protected final void load_cached_value(int n) throws IOException {
        if (this._v.isEmpty()) {
            this.load_scalar_value();
        }
    }

    private static BigInteger unsignedLongToBigInteger(int n, long l) {
        byte[] byArray = new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        return new BigInteger(n, byArray);
    }

    private final void load_scalar_value() throws IOException {
        switch (this._value_type) {
            case NULL: 
            case BOOL: 
            case INT: 
            case FLOAT: 
            case DECIMAL: 
            case TIMESTAMP: 
            case SYMBOL: 
            case STRING: {
                break;
            }
            default: {
                return;
            }
        }
        if (this._value_is_null) {
            this._v.setValueToNull(this._value_type);
            this._v.setAuthoritativeType(1);
            return;
        }
        switch (this._value_type) {
            default: {
                return;
            }
            case BOOL: {
                this._v.setValue(this._value_is_true);
                this._v.setAuthoritativeType(2);
                break;
            }
            case INT: {
                if (this._value_len == 0) {
                    int n = 0;
                    this._v.setValue(n);
                    this._v.setAuthoritativeType(3);
                    break;
                }
                if (this._value_len <= 8) {
                    boolean bl;
                    long l = this.readULong(this._value_len);
                    boolean bl2 = bl = this._value_tid == 3;
                    if (l < 0L) {
                        int n = !bl ? 1 : -1;
                        BigInteger bigInteger = IonReaderBinarySystemX.unsignedLongToBigInteger(n, l);
                        this._v.setValue(bigInteger);
                        if (bigInteger.compareTo(MIN_LONG_VALUE) < 0 || bigInteger.compareTo(MAX_LONG_VALUE) > 0) {
                            this._v.setAuthoritativeType(5);
                            break;
                        }
                        this._v.addValue(bigInteger.longValue());
                        this._v.setAuthoritativeType(4);
                        break;
                    }
                    if (bl) {
                        l = -l;
                    }
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        this._v.setValue(l);
                        this._v.setAuthoritativeType(4);
                        break;
                    }
                    this._v.setValue((int)l);
                    this._v.setAuthoritativeType(3);
                    break;
                }
                boolean bl = this._value_tid == 3;
                BigInteger bigInteger = this.readBigInteger(this._value_len, bl);
                this._v.setValue(bigInteger);
                this._v.setAuthoritativeType(5);
                break;
            }
            case FLOAT: {
                double d = this._value_len == 0 ? 0.0 : this.readFloat(this._value_len);
                this._v.setValue(d);
                this._v.setAuthoritativeType(7);
                break;
            }
            case DECIMAL: {
                Decimal decimal = this.readDecimal(this._value_len);
                this._v.setValue(decimal);
                this._v.setAuthoritativeType(6);
                break;
            }
            case TIMESTAMP: {
                Timestamp timestamp = this.readTimestamp(this._value_len);
                this._v.setValue(timestamp);
                this._v.setAuthoritativeType(10);
                break;
            }
            case SYMBOL: {
                long l = this.readULong(this._value_len);
                if (l < 1L || l > Integer.MAX_VALUE) {
                    String string = "symbol id [" + l + "] out of range " + "(1-" + Integer.MAX_VALUE + ")";
                    this.throwErrorAt(string);
                }
                this._v.setValue((int)l);
                this._v.setAuthoritativeType(3);
                break;
            }
            case STRING: {
                String string = this.readString(this._value_len);
                this._v.setValue(string);
                this._v.setAuthoritativeType(8);
            }
        }
        this._state = IonReaderBinaryRawX.State.S_AFTER_VALUE;
    }

    @Override
    public boolean isNullValue() {
        return this._value_is_null;
    }

    @Override
    public boolean booleanValue() {
        this.prepare_value(2);
        return this._v.getBoolean();
    }

    @Override
    public double doubleValue() {
        this.prepare_value(7);
        return this._v.getDouble();
    }

    @Override
    public int intValue() {
        if (this._value_type != IonType.INT && this._value_type != IonType.DECIMAL && this._value_type != IonType.FLOAT) {
            throw new IllegalStateException();
        }
        this.prepare_value(3);
        return this._v.getInt();
    }

    @Override
    public long longValue() {
        if (this._value_type != IonType.INT && this._value_type != IonType.DECIMAL && this._value_type != IonType.FLOAT) {
            throw new IllegalStateException();
        }
        this.prepare_value(4);
        return this._v.getLong();
    }

    @Override
    public BigInteger bigIntegerValue() {
        if (this._value_type != IonType.INT && this._value_type != IonType.DECIMAL && this._value_type != IonType.FLOAT) {
            throw new IllegalStateException();
        }
        if (this._value_is_null) {
            return null;
        }
        this.prepare_value(5);
        return this._v.getBigInteger();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (this._value_is_null) {
            return null;
        }
        this.prepare_value(6);
        return this._v.getBigDecimal();
    }

    @Override
    public Decimal decimalValue() {
        if (this._value_is_null) {
            return null;
        }
        this.prepare_value(6);
        return this._v.getDecimal();
    }

    @Override
    public Date dateValue() {
        if (this._value_is_null) {
            return null;
        }
        this.prepare_value(9);
        return this._v.getDate();
    }

    @Override
    public Timestamp timestampValue() {
        if (this._value_is_null) {
            return null;
        }
        this.prepare_value(10);
        return this._v.getTimestamp();
    }

    @Override
    public IntegerSize getIntegerSize() {
        this.load_once();
        if (this._value_type != IonType.INT || this._v.isNull()) {
            return null;
        }
        return PrivateScalarConversions.getIntegerSize(this._v.getAuthoritativeType());
    }

    @Override
    public final String stringValue() {
        if (!IonType.isText(this._value_type)) {
            throw new IllegalStateException();
        }
        if (this._value_is_null) {
            return null;
        }
        if (this._value_type == IonType.SYMBOL) {
            if (!this._v.hasValueOfType(8)) {
                int n = this.getSymbolId();
                String string = this._symbols.findKnownSymbol(n);
                if (string == null) {
                    throw new UnknownSymbolException(n);
                }
                this._v.addValue(string);
            }
        } else {
            this.prepare_value(8);
        }
        return this._v.getString();
    }

    @Override
    public final SymbolToken symbolValue() {
        if (this._value_type != IonType.SYMBOL) {
            throw new IllegalStateException();
        }
        if (this._value_is_null) {
            return null;
        }
        int n = this.getSymbolId();
        assert (n != -1);
        String string = this._symbols.findKnownSymbol(n);
        return new SymbolTokenImpl(string, n);
    }

    int getSymbolId() {
        if (this._value_type != IonType.SYMBOL) {
            throw new IllegalStateException();
        }
        if (this._value_is_null) {
            throw new NullValueException();
        }
        this.prepare_value(3);
        return this._v.getInt();
    }

    @Override
    public final String getFieldName() {
        String string;
        if (this._value_field_id == -1) {
            string = null;
        } else {
            string = this._symbols.findKnownSymbol(this._value_field_id);
            if (string == null) {
                throw new UnknownSymbolException(this._value_field_id);
            }
        }
        return string;
    }

    @Override
    public final SymbolToken getFieldNameSymbol() {
        if (this._value_field_id == -1) {
            return null;
        }
        int n = this._value_field_id;
        String string = this._symbols.findKnownSymbol(n);
        return new SymbolTokenImpl(string, n);
    }

    @Override
    public final Iterator<String> iterateTypeAnnotations() {
        String[] stringArray = this.getTypeAnnotations();
        return PrivateUtils.stringIterator(stringArray);
    }

    @Override
    public final String[] getTypeAnnotations() {
        String[] stringArray;
        this.load_annotations();
        if (this._annotation_count < 1) {
            stringArray = PrivateUtils.EMPTY_STRING_ARRAY;
        } else {
            stringArray = new String[this._annotation_count];
            for (int i = 0; i < this._annotation_count; ++i) {
                stringArray[i] = this._symbols.findKnownSymbol(this._annotation_ids[i]);
                if (stringArray[i] != null) continue;
                throw new UnknownSymbolException(this._annotation_ids[i]);
            }
        }
        return stringArray;
    }

    @Override
    public final SymbolTable getSymbolTable() {
        return this._symbols;
    }

    @Override
    public SymbolTable pop_passed_symbol_table() {
        return null;
    }
}

