/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.apps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import software.amazon.ion.IonException;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.apps.BaseApp;

public class SymtabApp
extends BaseApp {
    private ArrayList<SymbolTable> myImports = new ArrayList();
    private ArrayList<String> mySymbols = new ArrayList();
    private String mySymtabName;
    private int mySymtabVersion;

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Need one file to build symtab");
            return;
        }
        SymtabApp symtabApp = new SymtabApp();
        symtabApp.doMain(stringArray);
    }

    @Override
    protected int processOptions(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string = stringArray[i];
            if ("--catalog".equals(string)) {
                String string2 = stringArray[++i];
                this.loadCatalog(string2);
                continue;
            }
            if ("--import".equals(string)) {
                String string3 = stringArray[++i];
                object = this.mySystem.getCatalog();
                SymbolTable symbolTable = object.getTable(string3);
                if (symbolTable == null) {
                    String string4 = "There's no symbol table in the catalog named " + string3;
                    throw new RuntimeException(string4);
                }
                this.myImports.add(symbolTable);
                this.logDebug("Imported symbol table " + string3 + "@" + symbolTable.getVersion());
                continue;
            }
            if ("--name".equals(string)) {
                if (this.mySymtabName != null) {
                    throw new RuntimeException("Multiple names");
                }
                this.mySymtabName = stringArray[++i];
                if (this.mySymtabName.length() != 0) continue;
                throw new RuntimeException("Name must not be empty");
            }
            if ("--version".equals(string)) {
                if (this.mySymtabVersion != 0) {
                    throw new RuntimeException("Multiple versions");
                }
                int n = Integer.parseInt(string);
                if (n < 1) {
                    throw new RuntimeException("Version must be at least 1");
                }
                if (n != 1) {
                    object = "Symtab extension not implemented";
                    throw new UnsupportedOperationException((String)object);
                }
                this.mySymtabVersion = n;
                continue;
            }
            return i;
        }
        return stringArray.length;
    }

    @Override
    protected boolean optionsAreValid(String[] stringArray) {
        if (this.mySymtabName == null) {
            throw new RuntimeException("Must provide --name");
        }
        if (this.mySymtabVersion == 0) {
            this.mySymtabVersion = 1;
        }
        if (stringArray.length == 0) {
            System.err.println("Must provide list of files to provide symbols");
            return false;
        }
        return true;
    }

    @Override
    public void processFiles(String[] stringArray) {
        super.processFiles(stringArray);
        SymbolTable[] symbolTableArray = new SymbolTable[this.myImports.size()];
        this.myImports.toArray(symbolTableArray);
        SymbolTable symbolTable = this.mySystem.newSharedSymbolTable(this.mySymtabName, this.mySymtabVersion, this.mySymbols.iterator(), symbolTableArray);
        IonWriter ionWriter = this.mySystem.newTextWriter(System.out);
        try {
            symbolTable.writeTo(ionWriter);
            System.out.println();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    protected void process(IonReader ionReader) throws IonException {
        IonType ionType;
        while ((ionType = ionReader.next()) != null) {
            String string = ionReader.getFieldName();
            this.intern(string);
            this.internAnnotations(ionReader);
            switch (ionType) {
                case SYMBOL: {
                    String string2 = ionReader.stringValue();
                    this.intern(string2);
                    break;
                }
                case LIST: 
                case SEXP: 
                case STRUCT: {
                    ionReader.stepIn();
                    break;
                }
            }
            while (ionReader.next() != null && ionReader.getDepth() > 0) {
                ionReader.stepOut();
            }
        }
    }

    private void internAnnotations(IonReader ionReader) {
        Iterator<String> iterator2 = ionReader.iterateTypeAnnotations();
        assert (iterator2 != null);
        while (iterator2.hasNext()) {
            String string = iterator2.next();
            this.intern(string);
        }
    }

    private void intern(String string) {
        if (string != null) {
            if (string.equals("$ion") || string.startsWith("$ion_")) {
                return;
            }
            this.mySymbols.add(string);
        }
    }
}

