/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.XMLEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.xml.AbstractXMLStreamReader;

class XMLEventStreamReader
extends AbstractXMLStreamReader {
    private XMLEvent event;
    private final XMLEventReader eventReader;

    public XMLEventStreamReader(XMLEventReader xMLEventReader) throws XMLStreamException {
        this.eventReader = xMLEventReader;
        this.event = xMLEventReader.nextEvent();
    }

    @Override
    public QName getName() {
        if (this.event.isStartElement()) {
            return this.event.asStartElement().getName();
        }
        if (this.event.isEndElement()) {
            return this.event.asEndElement().getName();
        }
        throw new IllegalStateException();
    }

    @Override
    public Location getLocation() {
        return this.event.getLocation();
    }

    @Override
    public int getEventType() {
        return this.event.getEventType();
    }

    @Override
    @Nullable
    public String getVersion() {
        if (this.event.isStartDocument()) {
            return ((StartDocument)this.event).getVersion();
        }
        return null;
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        return this.eventReader.getProperty(string);
    }

    @Override
    public boolean isStandalone() {
        if (this.event.isStartDocument()) {
            return ((StartDocument)this.event).isStandalone();
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean standaloneSet() {
        if (this.event.isStartDocument()) {
            return ((StartDocument)this.event).standaloneSet();
        }
        throw new IllegalStateException();
    }

    @Override
    @Nullable
    public String getEncoding() {
        return null;
    }

    @Override
    @Nullable
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getPITarget() {
        if (this.event.isProcessingInstruction()) {
            return ((ProcessingInstruction)this.event).getTarget();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getPIData() {
        if (this.event.isProcessingInstruction()) {
            return ((ProcessingInstruction)this.event).getData();
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public String getText() {
        if (this.event.isCharacters()) {
            return this.event.asCharacters().getData();
        }
        if (this.event.getEventType() == 5) {
            return ((Comment)this.event).getText();
        }
        throw new IllegalStateException();
    }

    @Override
    public int getAttributeCount() {
        if (!this.event.isStartElement()) {
            throw new IllegalStateException();
        }
        Iterator<Attribute> iterator2 = this.event.asStartElement().getAttributes();
        return XMLEventStreamReader.countIterator(iterator2);
    }

    @Override
    public boolean isAttributeSpecified(int n) {
        return this.getAttribute(n).isSpecified();
    }

    @Override
    public QName getAttributeName(int n) {
        return this.getAttribute(n).getName();
    }

    @Override
    public String getAttributeType(int n) {
        return this.getAttribute(n).getDTDType();
    }

    @Override
    public String getAttributeValue(int n) {
        return this.getAttribute(n).getValue();
    }

    private Attribute getAttribute(int n) {
        if (!this.event.isStartElement()) {
            throw new IllegalStateException();
        }
        int n2 = 0;
        Iterator<Attribute> iterator2 = this.event.asStartElement().getAttributes();
        while (iterator2.hasNext()) {
            Attribute attribute = iterator2.next();
            if (n2 == n) {
                return attribute;
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        if (this.event.isStartElement()) {
            return this.event.asStartElement().getNamespaceContext();
        }
        throw new IllegalStateException();
    }

    @Override
    public int getNamespaceCount() {
        Iterator<Namespace> iterator2;
        if (this.event.isStartElement()) {
            iterator2 = this.event.asStartElement().getNamespaces();
        } else if (this.event.isEndElement()) {
            iterator2 = this.event.asEndElement().getNamespaces();
        } else {
            throw new IllegalStateException();
        }
        return XMLEventStreamReader.countIterator(iterator2);
    }

    @Override
    public String getNamespacePrefix(int n) {
        return this.getNamespace(n).getPrefix();
    }

    @Override
    public String getNamespaceURI(int n) {
        return this.getNamespace(n).getNamespaceURI();
    }

    private Namespace getNamespace(int n) {
        Iterator<Namespace> iterator2;
        if (this.event.isStartElement()) {
            iterator2 = this.event.asStartElement().getNamespaces();
        } else if (this.event.isEndElement()) {
            iterator2 = this.event.asEndElement().getNamespaces();
        } else {
            throw new IllegalStateException();
        }
        int n2 = 0;
        while (iterator2.hasNext()) {
            Namespace namespace = iterator2.next();
            if (n2 == n) {
                return namespace;
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int next() throws XMLStreamException {
        this.event = this.eventReader.nextEvent();
        return this.event.getEventType();
    }

    @Override
    public void close() throws XMLStreamException {
        this.eventReader.close();
    }

    private static int countIterator(Iterator iterator2) {
        int n = 0;
        while (iterator2.hasNext()) {
            iterator2.next();
            ++n;
        }
        return n;
    }
}

