/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

class DomContentHandler
implements ContentHandler {
    private final Document document;
    private final List<Element> elements = new ArrayList<Element>();
    private final Node node;

    DomContentHandler(Node node) {
        this.node = node;
        this.document = node instanceof Document ? (Document)node : node.getOwnerDocument();
    }

    private Node getParent() {
        if (!this.elements.isEmpty()) {
            return this.elements.get(this.elements.size() - 1);
        }
        return this.node;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        Node node = this.getParent();
        Element element = this.document.createElementNS(string, string3);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string4 = attributes.getURI(i);
            String string5 = attributes.getQName(i);
            String string6 = attributes.getValue(i);
            if (string5.startsWith("xmlns")) continue;
            element.setAttributeNS(string4, string5, string6);
        }
        element = (Element)node.appendChild(element);
        this.elements.add(element);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.elements.remove(this.elements.size() - 1);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        Node node = this.getParent();
        Node node2 = node.getLastChild();
        if (node2 != null && node2.getNodeType() == 3) {
            ((Text)node2).appendData(string);
        } else {
            Text text = this.document.createTextNode(string);
            node.appendChild(text);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) {
        Node node = this.getParent();
        ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(string, string2);
        node.appendChild(processingInstruction);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
    }

    @Override
    public void endPrefixMapping(String string) {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    @Override
    public void skippedEntity(String string) {
    }
}

