/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.unit;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataUnit;

public final class DataSize
implements Serializable,
Comparable<DataSize> {
    private static final Pattern PATTERN = Pattern.compile("^([+\\-]?\\d+)([a-zA-Z]{0,2})$");
    private static final long BYTES_PER_KB = 1024L;
    private static final long BYTES_PER_MB = 0x100000L;
    private static final long BYTES_PER_GB = 0x40000000L;
    private static final long BYTES_PER_TB = 0x10000000000L;
    private final long bytes;

    private DataSize(long l) {
        this.bytes = l;
    }

    public static DataSize ofBytes(long l) {
        return new DataSize(l);
    }

    public static DataSize ofKilobytes(long l) {
        return new DataSize(Math.multiplyExact(l, 1024L));
    }

    public static DataSize ofMegabytes(long l) {
        return new DataSize(Math.multiplyExact(l, 0x100000L));
    }

    public static DataSize ofGigabytes(long l) {
        return new DataSize(Math.multiplyExact(l, 0x40000000L));
    }

    public static DataSize ofTerabytes(long l) {
        return new DataSize(Math.multiplyExact(l, 0x10000000000L));
    }

    public static DataSize of(long l, DataUnit dataUnit) {
        Assert.notNull((Object)dataUnit, "Unit must not be null");
        return new DataSize(Math.multiplyExact(l, dataUnit.size().toBytes()));
    }

    public static DataSize parse(CharSequence charSequence) {
        return DataSize.parse(charSequence, null);
    }

    public static DataSize parse(CharSequence charSequence, @Nullable DataUnit dataUnit) {
        Assert.notNull((Object)charSequence, "Text must not be null");
        try {
            Matcher matcher = PATTERN.matcher(charSequence);
            Assert.state(matcher.matches(), "Does not match data size pattern");
            DataUnit dataUnit2 = DataSize.determineDataUnit(matcher.group(2), dataUnit);
            long l = Long.parseLong(matcher.group(1));
            return DataSize.of(l, dataUnit2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("'" + charSequence + "' is not a valid data size", exception);
        }
    }

    private static DataUnit determineDataUnit(String string, @Nullable DataUnit dataUnit) {
        DataUnit dataUnit2 = dataUnit != null ? dataUnit : DataUnit.BYTES;
        return StringUtils.hasLength(string) ? DataUnit.fromSuffix(string) : dataUnit2;
    }

    public boolean isNegative() {
        return this.bytes < 0L;
    }

    public long toBytes() {
        return this.bytes;
    }

    public long toKilobytes() {
        return this.bytes / 1024L;
    }

    public long toMegabytes() {
        return this.bytes / 0x100000L;
    }

    public long toGigabytes() {
        return this.bytes / 0x40000000L;
    }

    public long toTerabytes() {
        return this.bytes / 0x10000000000L;
    }

    @Override
    public int compareTo(DataSize dataSize) {
        return Long.compare(this.bytes, dataSize.bytes);
    }

    public String toString() {
        return String.format("%dB", this.bytes);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DataSize dataSize = (DataSize)object;
        return this.bytes == dataSize.bytes;
    }

    public int hashCode() {
        return Long.hashCode(this.bytes);
    }
}

