/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.concurrent;

import java.util.concurrent.ExecutionException;
import org.springframework.lang.Nullable;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.FutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;

public abstract class ListenableFutureAdapter<T, S>
extends FutureAdapter<T, S>
implements ListenableFuture<T> {
    protected ListenableFutureAdapter(ListenableFuture<S> listenableFuture) {
        super(listenableFuture);
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> listenableFutureCallback) {
        this.addCallback(listenableFutureCallback, listenableFutureCallback);
    }

    @Override
    public void addCallback(final SuccessCallback<? super T> successCallback, final FailureCallback failureCallback) {
        ListenableFuture listenableFuture = (ListenableFuture)this.getAdaptee();
        listenableFuture.addCallback(new ListenableFutureCallback<S>(){

            @Override
            public void onSuccess(@Nullable S s2) {
                Object t2 = null;
                if (s2 != null) {
                    try {
                        t2 = ListenableFutureAdapter.this.adaptInternal(s2);
                    }
                    catch (ExecutionException executionException) {
                        Throwable throwable = executionException.getCause();
                        this.onFailure(throwable != null ? throwable : executionException);
                        return;
                    }
                    catch (Throwable throwable) {
                        this.onFailure(throwable);
                        return;
                    }
                }
                successCallback.onSuccess(t2);
            }

            @Override
            public void onFailure(Throwable throwable) {
                failureCallback.onFailure(throwable);
            }
        });
    }
}

