/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Comparator;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.RouteMatcher;

public class SimpleRouteMatcher
implements RouteMatcher {
    private final PathMatcher pathMatcher;

    public SimpleRouteMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, "PathMatcher is required");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    @Override
    public RouteMatcher.Route parseRoute(String string) {
        return new DefaultRoute(string);
    }

    @Override
    public boolean isPattern(String string) {
        return this.pathMatcher.isPattern(string);
    }

    @Override
    public String combine(String string, String string2) {
        return this.pathMatcher.combine(string, string2);
    }

    @Override
    public boolean match(String string, RouteMatcher.Route route) {
        return this.pathMatcher.match(string, route.value());
    }

    @Override
    @Nullable
    public Map<String, String> matchAndExtract(String string, RouteMatcher.Route route) {
        if (!this.match(string, route)) {
            return null;
        }
        return this.pathMatcher.extractUriTemplateVariables(string, route.value());
    }

    @Override
    public Comparator<String> getPatternComparator(RouteMatcher.Route route) {
        return this.pathMatcher.getPatternComparator(route.value());
    }

    private static class DefaultRoute
    implements RouteMatcher.Route {
        private final String path;

        DefaultRoute(String string) {
            this.path = string;
        }

        @Override
        public String value() {
            return this.path;
        }

        public String toString() {
            return this.value();
        }
    }
}

