/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;

class MultiValueMapAdapter<K, V>
implements Serializable,
MultiValueMap<K, V> {
    private final Map<K, List<V>> targetMap;

    MultiValueMapAdapter(Map<K, List<V>> map) {
        this.targetMap = map;
    }

    @Override
    @Nullable
    public V getFirst(K k) {
        List<V> list = this.targetMap.get(k);
        return list != null && !list.isEmpty() ? (V)list.get(0) : null;
    }

    @Override
    public void add(K k, @Nullable V v) {
        List list = this.targetMap.computeIfAbsent(k, object -> new LinkedList());
        list.add(v);
    }

    @Override
    public void addAll(K k, List<? extends V> list) {
        List list2 = this.targetMap.computeIfAbsent(k, object -> new LinkedList());
        list2.addAll(list);
    }

    @Override
    public void addAll(MultiValueMap<K, V> multiValueMap) {
        for (Map.Entry entry : multiValueMap.entrySet()) {
            this.addAll(entry.getKey(), (List)entry.getValue());
        }
    }

    @Override
    public void set(K k, @Nullable V v) {
        LinkedList<V> linkedList = new LinkedList<V>();
        linkedList.add(v);
        this.targetMap.put(k, linkedList);
    }

    @Override
    public void setAll(Map<K, V> map) {
        map.forEach(this::set);
    }

    @Override
    public Map<K, V> toSingleValueMap() {
        LinkedHashMap linkedHashMap = new LinkedHashMap(this.targetMap.size());
        this.targetMap.forEach((object, list) -> {
            if (list != null && !list.isEmpty()) {
                linkedHashMap.put(object, list.get(0));
            }
        });
        return linkedHashMap;
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.targetMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.targetMap.containsValue(object);
    }

    @Override
    @Nullable
    public List<V> get(Object object) {
        return this.targetMap.get(object);
    }

    @Override
    @Nullable
    public List<V> put(K k, List<V> list) {
        return this.targetMap.put(k, list);
    }

    @Override
    @Nullable
    public List<V> remove(Object object) {
        return this.targetMap.remove(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> map) {
        this.targetMap.putAll(map);
    }

    @Override
    public void clear() {
        this.targetMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.targetMap.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.targetMap.values();
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.targetMap.entrySet();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return this == object || this.targetMap.equals(object);
    }

    @Override
    public int hashCode() {
        return this.targetMap.hashCode();
    }

    public String toString() {
        return this.targetMap.toString();
    }
}

