/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.lang.Nullable;

public class LinkedCaseInsensitiveMap<V>
implements Serializable,
Cloneable,
Map<String, V> {
    private final LinkedHashMap<String, V> targetMap;
    private final HashMap<String, String> caseInsensitiveKeys;
    private final Locale locale;
    @Nullable
    private volatile transient Set<String> keySet;
    @Nullable
    private volatile transient Collection<V> values;
    @Nullable
    private volatile transient Set<Map.Entry<String, V>> entrySet;

    public LinkedCaseInsensitiveMap() {
        this((Locale)null);
    }

    public LinkedCaseInsensitiveMap(@Nullable Locale locale) {
        this(16, locale);
    }

    public LinkedCaseInsensitiveMap(int n) {
        this(n, null);
    }

    public LinkedCaseInsensitiveMap(int n, @Nullable Locale locale) {
        this.targetMap = new LinkedHashMap<String, V>(n){

            @Override
            public boolean containsKey(Object object) {
                return LinkedCaseInsensitiveMap.this.containsKey(object);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, V> entry) {
                boolean bl = LinkedCaseInsensitiveMap.this.removeEldestEntry(entry);
                if (bl) {
                    LinkedCaseInsensitiveMap.this.removeCaseInsensitiveKey(entry.getKey());
                }
                return bl;
            }
        };
        this.caseInsensitiveKeys = new HashMap(n);
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    private LinkedCaseInsensitiveMap(LinkedCaseInsensitiveMap<V> linkedCaseInsensitiveMap) {
        this.targetMap = (LinkedHashMap)linkedCaseInsensitiveMap.targetMap.clone();
        this.caseInsensitiveKeys = (HashMap)linkedCaseInsensitiveMap.caseInsensitiveKeys.clone();
        this.locale = linkedCaseInsensitiveMap.locale;
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return object instanceof String && this.caseInsensitiveKeys.containsKey(this.convertKey((String)object));
    }

    @Override
    public boolean containsValue(Object object) {
        return this.targetMap.containsValue(object);
    }

    @Override
    @Nullable
    public V get(Object object) {
        String string;
        if (object instanceof String && (string = this.caseInsensitiveKeys.get(this.convertKey((String)object))) != null) {
            return this.targetMap.get(string);
        }
        return null;
    }

    @Override
    @Nullable
    public V getOrDefault(Object object, V v) {
        String string;
        if (object instanceof String && (string = this.caseInsensitiveKeys.get(this.convertKey((String)object))) != null) {
            return this.targetMap.get(string);
        }
        return v;
    }

    @Override
    @Nullable
    public V put(String string, @Nullable V v) {
        String string2 = this.caseInsensitiveKeys.put(this.convertKey(string), string);
        V v2 = null;
        if (string2 != null && !string2.equals(string)) {
            v2 = this.targetMap.remove(string2);
        }
        V v3 = this.targetMap.put(string, v);
        return v2 != null ? v2 : (V)v3;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        if (map.isEmpty()) {
            return;
        }
        map.forEach(this::put);
    }

    @Override
    @Nullable
    public V putIfAbsent(String string, @Nullable V v) {
        String string2 = this.caseInsensitiveKeys.putIfAbsent(this.convertKey(string), string);
        if (string2 != null) {
            return this.targetMap.get(string2);
        }
        return this.targetMap.putIfAbsent(string, v);
    }

    @Override
    @Nullable
    public V computeIfAbsent(String string, Function<? super String, ? extends V> function) {
        String string2 = this.caseInsensitiveKeys.putIfAbsent(this.convertKey(string), string);
        if (string2 != null) {
            return this.targetMap.get(string2);
        }
        return this.targetMap.computeIfAbsent(string, function);
    }

    @Override
    @Nullable
    public V remove(Object object) {
        String string;
        if (object instanceof String && (string = this.removeCaseInsensitiveKey((String)object)) != null) {
            return this.targetMap.remove(string);
        }
        return null;
    }

    @Override
    public void clear() {
        this.caseInsensitiveKeys.clear();
        this.targetMap.clear();
    }

    @Override
    public Set<String> keySet() {
        KeySet keySet = this.keySet;
        if (keySet == null) {
            this.keySet = keySet = new KeySet(this.targetMap.keySet());
        }
        return keySet;
    }

    @Override
    public Collection<V> values() {
        Values values2 = this.values;
        if (values2 == null) {
            this.values = values2 = new Values(this.targetMap.values());
        }
        return values2;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet = new EntrySet(this.targetMap.entrySet());
        }
        return entrySet;
    }

    public LinkedCaseInsensitiveMap<V> clone() {
        return new LinkedCaseInsensitiveMap<V>(this);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return this == object || this.targetMap.equals(object);
    }

    @Override
    public int hashCode() {
        return this.targetMap.hashCode();
    }

    public String toString() {
        return this.targetMap.toString();
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected String convertKey(String string) {
        return string.toLowerCase(this.getLocale());
    }

    protected boolean removeEldestEntry(Map.Entry<String, V> entry) {
        return false;
    }

    @Nullable
    private String removeCaseInsensitiveKey(String string) {
        return this.caseInsensitiveKeys.remove(this.convertKey(string));
    }

    private class EntrySetIterator
    extends EntryIterator<Map.Entry<String, V>> {
        private EntrySetIterator() {
        }

        @Override
        public Map.Entry<String, V> next() {
            return this.nextEntry();
        }
    }

    private class ValuesIterator
    extends EntryIterator<V> {
        private ValuesIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    private class KeySetIterator
    extends EntryIterator<String> {
        private KeySetIterator() {
        }

        @Override
        public String next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class EntryIterator<T>
    implements Iterator<T> {
        private final Iterator<Map.Entry<String, V>> delegate;
        @Nullable
        private Map.Entry<String, V> last;

        public EntryIterator() {
            this.delegate = LinkedCaseInsensitiveMap.this.targetMap.entrySet().iterator();
        }

        protected Map.Entry<String, V> nextEntry() {
            Map.Entry entry = this.delegate.next();
            this.last = entry;
            return entry;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void remove() {
            this.delegate.remove();
            if (this.last != null) {
                LinkedCaseInsensitiveMap.this.removeCaseInsensitiveKey(this.last.getKey());
                this.last = null;
            }
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        private final Set<Map.Entry<String, V>> delegate;

        public EntrySet(Set<Map.Entry<String, V>> set) {
            this.delegate = set;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean contains(Object object) {
            return this.delegate.contains(object);
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public boolean remove(Object object) {
            if (this.delegate.remove(object)) {
                LinkedCaseInsensitiveMap.this.removeCaseInsensitiveKey((String)((Map.Entry)object).getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.delegate.clear();
            LinkedCaseInsensitiveMap.this.caseInsensitiveKeys.clear();
        }

        @Override
        public Spliterator<Map.Entry<String, V>> spliterator() {
            return this.delegate.spliterator();
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<String, V>> consumer) {
            this.delegate.forEach(consumer);
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private final Collection<V> delegate;

        Values(Collection<V> collection) {
            this.delegate = collection;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean contains(Object object) {
            return this.delegate.contains(object);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void clear() {
            LinkedCaseInsensitiveMap.this.clear();
        }

        @Override
        public Spliterator<V> spliterator() {
            return this.delegate.spliterator();
        }

        @Override
        public void forEach(Consumer<? super V> consumer) {
            this.delegate.forEach(consumer);
        }
    }

    private class KeySet
    extends AbstractSet<String> {
        private final Set<String> delegate;

        KeySet(Set<String> set) {
            this.delegate = set;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean contains(Object object) {
            return this.delegate.contains(object);
        }

        @Override
        public Iterator<String> iterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean remove(Object object) {
            return LinkedCaseInsensitiveMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            LinkedCaseInsensitiveMap.this.clear();
        }

        @Override
        public Spliterator<String> spliterator() {
            return this.delegate.spliterator();
        }

        @Override
        public void forEach(Consumer<? super String> consumer) {
            this.delegate.forEach(consumer);
        }
    }
}

