/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Collection;
import java.util.Collections;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class InstanceFilter<T> {
    private final Collection<? extends T> includes;
    private final Collection<? extends T> excludes;
    private final boolean matchIfEmpty;

    public InstanceFilter(@Nullable Collection<? extends T> collection, @Nullable Collection<? extends T> collection2, boolean bl) {
        this.includes = collection != null ? collection : Collections.emptyList();
        this.excludes = collection2 != null ? collection2 : Collections.emptyList();
        this.matchIfEmpty = bl;
    }

    public boolean match(T t2) {
        boolean bl;
        Assert.notNull(t2, "Instance to match must not be null");
        boolean bl2 = !this.includes.isEmpty();
        boolean bl3 = bl = !this.excludes.isEmpty();
        if (!bl2 && !bl) {
            return this.matchIfEmpty;
        }
        boolean bl4 = this.match(t2, this.includes);
        boolean bl5 = this.match(t2, this.excludes);
        if (!bl2) {
            return !bl5;
        }
        if (!bl) {
            return bl4;
        }
        return bl4 && !bl5;
    }

    protected boolean match(T t2, T t3) {
        return t2.equals(t3);
    }

    protected boolean match(T t2, Collection<? extends T> collection) {
        for (T t3 : collection) {
            if (!this.match(t2, t3)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append(": includes=").append(this.includes);
        stringBuilder.append(", excludes=").append(this.excludes);
        stringBuilder.append(", matchIfEmpty=").append(this.matchIfEmpty);
        return stringBuilder.toString();
    }
}

