/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class CustomizableThreadCreator
implements Serializable {
    private String threadNamePrefix;
    private int threadPriority = 5;
    private boolean daemon = false;
    @Nullable
    private ThreadGroup threadGroup;
    private final AtomicInteger threadCount = new AtomicInteger(0);

    public CustomizableThreadCreator() {
        this.threadNamePrefix = this.getDefaultThreadNamePrefix();
    }

    public CustomizableThreadCreator(@Nullable String string) {
        this.threadNamePrefix = string != null ? string : this.getDefaultThreadNamePrefix();
    }

    public void setThreadNamePrefix(@Nullable String string) {
        this.threadNamePrefix = string != null ? string : this.getDefaultThreadNamePrefix();
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public void setThreadPriority(int n) {
        this.threadPriority = n;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setDaemon(boolean bl) {
        this.daemon = bl;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setThreadGroupName(String string) {
        this.threadGroup = new ThreadGroup(string);
    }

    public void setThreadGroup(@Nullable ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    @Nullable
    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public Thread createThread(Runnable runnable2) {
        Thread thread2 = new Thread(this.getThreadGroup(), runnable2, this.nextThreadName());
        thread2.setPriority(this.getThreadPriority());
        thread2.setDaemon(this.isDaemon());
        return thread2;
    }

    protected String nextThreadName() {
        return this.getThreadNamePrefix() + this.threadCount.incrementAndGet();
    }

    protected String getDefaultThreadNamePrefix() {
        return ClassUtils.getShortName(this.getClass()) + "-";
    }
}

