/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.beans.Introspector;
import java.io.Closeable;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public abstract class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char PATH_SEPARATOR = '/';
    private static final char INNER_CLASS_SEPARATOR = '$';
    public static final String CGLIB_CLASS_SEPARATOR = "$$";
    public static final String CLASS_FILE_SUFFIX = ".class";
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new IdentityHashMap(9);
    private static final Map<Class<?>, Class<?>> primitiveTypeToWrapperMap = new IdentityHashMap(9);
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(32);
    private static final Map<String, Class<?>> commonClassCache = new HashMap(64);
    private static final Set<Class<?>> javaLanguageInterfaces;
    private static final Map<Method, Method> interfaceMethodCache;

    private static void registerCommonClasses(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            commonClassCache.put(clazz.getName(), clazz);
        }
    }

    @Nullable
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (classLoader == null && (classLoader = ClassUtils.class.getClassLoader()) == null) {
            try {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return classLoader;
    }

    @Nullable
    public static ClassLoader overrideThreadContextClassLoader(@Nullable ClassLoader classLoader) {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader2 = thread2.getContextClassLoader();
        if (classLoader != null && !classLoader.equals(classLoader2)) {
            thread2.setContextClassLoader(classLoader);
            return classLoader2;
        }
        return null;
    }

    public static Class<?> forName(String string, @Nullable ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Assert.notNull((Object)string, "Name must not be null");
        Class<?> clazz = ClassUtils.resolvePrimitiveClassName(string);
        if (clazz == null) {
            clazz = commonClassCache.get(string);
        }
        if (clazz != null) {
            return clazz;
        }
        if (string.endsWith(ARRAY_SUFFIX)) {
            String string2 = string.substring(0, string.length() - ARRAY_SUFFIX.length());
            Class<?> clazz2 = ClassUtils.forName(string2, classLoader);
            return Array.newInstance(clazz2, 0).getClass();
        }
        if (string.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && string.endsWith(";")) {
            String string3 = string.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), string.length() - 1);
            Class<?> clazz3 = ClassUtils.forName(string3, classLoader);
            return Array.newInstance(clazz3, 0).getClass();
        }
        if (string.startsWith(INTERNAL_ARRAY_PREFIX)) {
            String string4 = string.substring(INTERNAL_ARRAY_PREFIX.length());
            Class<?> clazz4 = ClassUtils.forName(string4, classLoader);
            return Array.newInstance(clazz4, 0).getClass();
        }
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = ClassUtils.getDefaultClassLoader();
        }
        try {
            return Class.forName(string, false, classLoader2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            int n = string.lastIndexOf(46);
            if (n != -1) {
                String string5 = string.substring(0, n) + '$' + string.substring(n + 1);
                try {
                    return Class.forName(string5, false, classLoader2);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            throw classNotFoundException;
        }
    }

    public static Class<?> resolveClassName(String string, @Nullable ClassLoader classLoader) throws IllegalArgumentException {
        try {
            return ClassUtils.forName(string, classLoader);
        }
        catch (IllegalAccessError illegalAccessError) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + string + "]: " + illegalAccessError.getMessage(), illegalAccessError);
        }
        catch (LinkageError linkageError) {
            throw new IllegalArgumentException("Unresolvable class definition for class [" + string + "]", linkageError);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find class [" + string + "]", classNotFoundException);
        }
    }

    public static boolean isPresent(String string, @Nullable ClassLoader classLoader) {
        try {
            ClassUtils.forName(string, classLoader);
            return true;
        }
        catch (IllegalAccessError illegalAccessError) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + string + "]: " + illegalAccessError.getMessage(), illegalAccessError);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isVisible(Class<?> clazz, @Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            if (clazz.getClassLoader() == classLoader) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ClassUtils.isLoadable(clazz, classLoader);
    }

    public static boolean isCacheSafe(Class<?> clazz, @Nullable ClassLoader classLoader) {
        Assert.notNull(clazz, "Class must not be null");
        try {
            ClassLoader classLoader2 = clazz.getClassLoader();
            if (classLoader2 == classLoader || classLoader2 == null) {
                return true;
            }
            if (classLoader == null) {
                return false;
            }
            ClassLoader classLoader3 = classLoader;
            while (classLoader3 != null) {
                if ((classLoader3 = classLoader3.getParent()) != classLoader2) continue;
                return true;
            }
            while (classLoader2 != null) {
                if ((classLoader2 = classLoader2.getParent()) != classLoader) continue;
                return false;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return classLoader != null && ClassUtils.isLoadable(clazz, classLoader);
    }

    private static boolean isLoadable(Class<?> clazz, ClassLoader classLoader) {
        try {
            return clazz == classLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Nullable
    public static Class<?> resolvePrimitiveClassName(@Nullable String string) {
        Class<?> clazz = null;
        if (string != null && string.length() <= 7) {
            clazz = primitiveTypeNameMap.get(string);
        }
        return clazz;
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return primitiveWrapperTypeMap.containsKey(clazz);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveArray(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveWrapperArray(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isArray() && ClassUtils.isPrimitiveWrapper(clazz.getComponentType());
    }

    public static Class<?> resolvePrimitiveIfNecessary(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() && clazz != Void.TYPE ? primitiveTypeToWrapperMap.get(clazz) : clazz;
    }

    public static boolean isAssignable(Class<?> clazz, Class<?> clazz2) {
        Assert.notNull(clazz, "Left-hand side type must not be null");
        Assert.notNull(clazz2, "Right-hand side type must not be null");
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            Class<?> clazz3 = primitiveWrapperTypeMap.get(clazz2);
            return clazz == clazz3;
        }
        Class<?> clazz4 = primitiveTypeToWrapperMap.get(clazz2);
        return clazz4 != null && clazz.isAssignableFrom(clazz4);
    }

    public static boolean isAssignableValue(Class<?> clazz, @Nullable Object object) {
        Assert.notNull(clazz, "Type must not be null");
        return object != null ? ClassUtils.isAssignable(clazz, object.getClass()) : !clazz.isPrimitive();
    }

    public static String convertResourcePathToClassName(String string) {
        Assert.notNull((Object)string, "Resource path must not be null");
        return string.replace('/', '.');
    }

    public static String convertClassNameToResourcePath(String string) {
        Assert.notNull((Object)string, "Class name must not be null");
        return string.replace('.', '/');
    }

    public static String addResourcePathToPackagePath(Class<?> clazz, String string) {
        Assert.notNull((Object)string, "Resource name must not be null");
        if (!string.startsWith("/")) {
            return ClassUtils.classPackageAsResourcePath(clazz) + '/' + string;
        }
        return ClassUtils.classPackageAsResourcePath(clazz) + string;
    }

    public static String classPackageAsResourcePath(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        String string2 = string.substring(0, n);
        return string2.replace('.', '/');
    }

    public static String classNamesToString(Class<?> ... classArray) {
        return ClassUtils.classNamesToString(Arrays.asList(classArray));
    }

    public static String classNamesToString(@Nullable Collection<Class<?>> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return ARRAY_SUFFIX;
        }
        StringJoiner stringJoiner = new StringJoiner(", ", INTERNAL_ARRAY_PREFIX, "]");
        for (Class<?> clazz : collection) {
            stringJoiner.add(clazz.getName());
        }
        return stringJoiner.toString();
    }

    public static Class<?>[] toClassArray(@Nullable Collection<Class<?>> collection) {
        return !CollectionUtils.isEmpty(collection) ? collection.toArray(EMPTY_CLASS_ARRAY) : EMPTY_CLASS_ARRAY;
    }

    public static Class<?>[] getAllInterfaces(Object object) {
        Assert.notNull(object, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClass(object.getClass());
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz) {
        return ClassUtils.getAllInterfacesForClass(clazz, null);
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz, @Nullable ClassLoader classLoader) {
        return ClassUtils.toClassArray(ClassUtils.getAllInterfacesForClassAsSet(clazz, classLoader));
    }

    public static Set<Class<?>> getAllInterfacesAsSet(Object object) {
        Assert.notNull(object, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClassAsSet(object.getClass());
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz) {
        return ClassUtils.getAllInterfacesForClassAsSet(clazz, null);
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz, @Nullable ClassLoader classLoader) {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isInterface() && ClassUtils.isVisible(clazz, classLoader)) {
            return Collections.singleton(clazz);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class<?>[] classArray;
            for (Class<?> clazz3 : classArray = clazz2.getInterfaces()) {
                if (!ClassUtils.isVisible(clazz3, classLoader)) continue;
                linkedHashSet.add(clazz3);
            }
        }
        return linkedHashSet;
    }

    public static Class<?> createCompositeInterface(Class<?>[] classArray, @Nullable ClassLoader classLoader) {
        Assert.notEmpty((Object[])classArray, "Interface array must not be empty");
        return Proxy.getProxyClass(classLoader, classArray);
    }

    @Nullable
    public static Class<?> determineCommonAncestor(@Nullable Class<?> clazz, @Nullable Class<?> clazz2) {
        if (clazz == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz;
        }
        if (clazz.isAssignableFrom(clazz2)) {
            return clazz;
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return clazz2;
        }
        Class<?> clazz3 = clazz;
        do {
            if ((clazz3 = clazz3.getSuperclass()) != null && Object.class != clazz3) continue;
            return null;
        } while (!clazz3.isAssignableFrom(clazz2));
        return clazz3;
    }

    public static boolean isJavaLanguageInterface(Class<?> clazz) {
        return javaLanguageInterfaces.contains(clazz);
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers());
    }

    @Deprecated
    public static boolean isCglibProxy(Object object) {
        return ClassUtils.isCglibProxyClass(object.getClass());
    }

    @Deprecated
    public static boolean isCglibProxyClass(@Nullable Class<?> clazz) {
        return clazz != null && ClassUtils.isCglibProxyClassName(clazz.getName());
    }

    @Deprecated
    public static boolean isCglibProxyClassName(@Nullable String string) {
        return string != null && string.contains(CGLIB_CLASS_SEPARATOR);
    }

    public static Class<?> getUserClass(Object object) {
        Assert.notNull(object, "Instance must not be null");
        return ClassUtils.getUserClass(object.getClass());
    }

    public static Class<?> getUserClass(Class<?> clazz) {
        Class<?> clazz2;
        if (clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (clazz2 = clazz.getSuperclass()) != null && clazz2 != Object.class) {
            return clazz2;
        }
        return clazz;
    }

    @Nullable
    public static String getDescriptiveType(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (Proxy.isProxyClass(clazz)) {
            String string = clazz.getName() + " implementing ";
            StringJoiner stringJoiner = new StringJoiner(",", string, "");
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                stringJoiner.add(clazz2.getName());
            }
            return stringJoiner.toString();
        }
        return clazz.getTypeName();
    }

    public static boolean matchesTypeName(Class<?> clazz, @Nullable String string) {
        return string != null && (string.equals(clazz.getTypeName()) || string.equals(clazz.getSimpleName()));
    }

    public static String getShortName(String string) {
        Assert.hasLength(string, "Class name must not be empty");
        int n = string.lastIndexOf(46);
        int n2 = string.indexOf(CGLIB_CLASS_SEPARATOR);
        if (n2 == -1) {
            n2 = string.length();
        }
        String string2 = string.substring(n + 1, n2);
        string2 = string2.replace('$', '.');
        return string2;
    }

    public static String getShortName(Class<?> clazz) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz));
    }

    public static String getShortNameAsProperty(Class<?> clazz) {
        String string = ClassUtils.getShortName(clazz);
        int n = string.lastIndexOf(46);
        string = n != -1 ? string.substring(n + 1) : string;
        return Introspector.decapitalize(string);
    }

    public static String getClassFileName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(n + 1) + CLASS_FILE_SUFFIX;
    }

    public static String getPackageName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return ClassUtils.getPackageName(clazz.getName());
    }

    public static String getPackageName(String string) {
        Assert.notNull((Object)string, "Class name must not be null");
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(0, n) : "";
    }

    public static String getQualifiedName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.getTypeName();
    }

    public static String getQualifiedMethodName(Method method) {
        return ClassUtils.getQualifiedMethodName(method, null);
    }

    public static String getQualifiedMethodName(Method method, @Nullable Class<?> clazz) {
        Assert.notNull((Object)method, "Method must not be null");
        return (clazz != null ? clazz : method.getDeclaringClass()).getName() + '.' + method.getName();
    }

    public static boolean hasConstructor(Class<?> clazz, Class<?> ... classArray) {
        return ClassUtils.getConstructorIfAvailable(clazz, classArray) != null;
    }

    @Nullable
    public static <T> Constructor<T> getConstructorIfAvailable(Class<T> clazz, Class<?> ... classArray) {
        Assert.notNull(clazz, "Class must not be null");
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static boolean hasMethod(Class<?> clazz, Method method) {
        Class<?>[] classArray;
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)method, "Method must not be null");
        if (clazz == method.getDeclaringClass()) {
            return true;
        }
        String string = method.getName();
        return ClassUtils.getMethodOrNull(clazz, string, classArray = method.getParameterTypes()) != null;
    }

    public static boolean hasMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        return ClassUtils.getMethodIfAvailable(clazz, string, classArray) != null;
    }

    public static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)string, "Method name must not be null");
        if (classArray != null) {
            try {
                return clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException("Expected method not found: " + noSuchMethodException);
            }
        }
        Set<Method> set = ClassUtils.findMethodCandidatesByName(clazz, string);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        if (set.isEmpty()) {
            throw new IllegalStateException("Expected method not found: " + clazz.getName() + '.' + string);
        }
        throw new IllegalStateException("No unique method found: " + clazz.getName() + '.' + string);
    }

    @Nullable
    public static Method getMethodIfAvailable(Class<?> clazz, String string, Class<?> ... classArray) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)string, "Method name must not be null");
        if (classArray != null) {
            return ClassUtils.getMethodOrNull(clazz, string, classArray);
        }
        Set<Method> set = ClassUtils.findMethodCandidatesByName(clazz, string);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        return null;
    }

    public static int getMethodCountForName(Class<?> clazz, String string) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)string, "Method name must not be null");
        int n = 0;
        Method[] methodArray = clazz.getDeclaredMethods();
        GenericDeclaration[] genericDeclarationArray = methodArray;
        int n2 = genericDeclarationArray.length;
        for (int i = 0; i < n2; ++i) {
            Method method = genericDeclarationArray[i];
            if (!string.equals(method.getName())) continue;
            ++n;
        }
        for (GenericDeclaration genericDeclaration : genericDeclarationArray = clazz.getInterfaces()) {
            n += ClassUtils.getMethodCountForName(genericDeclaration, string);
        }
        if (clazz.getSuperclass() != null) {
            n += ClassUtils.getMethodCountForName(clazz.getSuperclass(), string);
        }
        return n;
    }

    public static boolean hasAtLeastOneMethodWithName(Class<?> clazz, String string) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)string, "Method name must not be null");
        Method[] methodArray = clazz.getDeclaredMethods();
        GenericDeclaration[] genericDeclarationArray = methodArray;
        int n = genericDeclarationArray.length;
        for (int i = 0; i < n; ++i) {
            Method method = genericDeclarationArray[i];
            if (!method.getName().equals(string)) continue;
            return true;
        }
        for (GenericDeclaration genericDeclaration : genericDeclarationArray = clazz.getInterfaces()) {
            if (!ClassUtils.hasAtLeastOneMethodWithName(genericDeclaration, string)) continue;
            return true;
        }
        return clazz.getSuperclass() != null && ClassUtils.hasAtLeastOneMethodWithName(clazz.getSuperclass(), string);
    }

    public static Method getMostSpecificMethod(Method method, @Nullable Class<?> clazz) {
        if (clazz != null && clazz != method.getDeclaringClass() && ClassUtils.isOverridable(method, clazz)) {
            try {
                if (Modifier.isPublic(method.getModifiers())) {
                    try {
                        return clazz.getMethod(method.getName(), method.getParameterTypes());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return method;
                    }
                }
                Method method2 = ReflectionUtils.findMethod(clazz, method.getName(), method.getParameterTypes());
                return method2 != null ? method2 : method;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return method;
    }

    public static Method getInterfaceMethodIfPossible(Method method2) {
        if (!Modifier.isPublic(method2.getModifiers()) || method2.getDeclaringClass().isInterface()) {
            return method2;
        }
        return interfaceMethodCache.computeIfAbsent(method2, method -> {
            for (Class<?> clazz = method.getDeclaringClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                Class<?>[] classArray;
                for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
                    try {
                        return clazz2.getMethod(method.getName(), method.getParameterTypes());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            return method;
        });
    }

    public static boolean isUserLevelMethod(Method method) {
        Assert.notNull((Object)method, "Method must not be null");
        return method.isBridge() || !method.isSynthetic() && !ClassUtils.isGroovyObjectMethod(method);
    }

    private static boolean isGroovyObjectMethod(Method method) {
        return method.getDeclaringClass().getName().equals("groovy.lang.GroovyObject");
    }

    private static boolean isOverridable(Method method, @Nullable Class<?> clazz) {
        if (Modifier.isPrivate(method.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(method.getModifiers()) || Modifier.isProtected(method.getModifiers())) {
            return true;
        }
        return clazz == null || ClassUtils.getPackageName(method.getDeclaringClass()).equals(ClassUtils.getPackageName(clazz));
    }

    @Nullable
    public static Method getStaticMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)string, "Method name must not be null");
        try {
            Method method = clazz.getMethod(string, classArray);
            return Modifier.isStatic(method.getModifiers()) ? method : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Nullable
    private static Method getMethodOrNull(Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Set<Method> findMethodCandidatesByName(Class<?> clazz, String string) {
        Method[] methodArray;
        HashSet<Method> hashSet = new HashSet<Method>(1);
        for (Method method : methodArray = clazz.getMethods()) {
            if (!string.equals(method.getName())) continue;
            hashSet.add(method);
        }
        return hashSet;
    }

    static {
        interfaceMethodCache = new ConcurrentReferenceHashMap<Method, Method>(256);
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        primitiveWrapperTypeMap.put(Void.class, Void.TYPE);
        for (Map.Entry<Class<?>, Class<?>> classArray2 : primitiveWrapperTypeMap.entrySet()) {
            primitiveTypeToWrapperMap.put(classArray2.getValue(), classArray2.getKey());
            ClassUtils.registerCommonClasses(classArray2.getKey());
        }
        HashSet hashSet = new HashSet(32);
        hashSet.addAll(primitiveWrapperTypeMap.values());
        Collections.addAll(hashSet, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class);
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            Class clazz = (Class)iterator2.next();
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
        ClassUtils.registerCommonClasses(Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class);
        ClassUtils.registerCommonClasses(Number.class, Number[].class, String.class, String[].class, Class.class, Class[].class, Object.class, Object[].class);
        ClassUtils.registerCommonClasses(Throwable.class, Exception.class, RuntimeException.class, Error.class, StackTraceElement.class, StackTraceElement[].class);
        ClassUtils.registerCommonClasses(Enum.class, Iterable.class, Iterator.class, Enumeration.class, Collection.class, List.class, Set.class, Map.class, Map.Entry.class, Optional.class);
        Class[] classArray = new Class[]{Serializable.class, Externalizable.class, Closeable.class, AutoCloseable.class, Cloneable.class, Comparable.class};
        ClassUtils.registerCommonClasses(classArray);
        javaLanguageInterfaces = new HashSet<Class>(Arrays.asList(classArray));
    }
}

