/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class AutoPopulatingList<E>
implements Serializable,
List<E> {
    private final List<E> backingList;
    private final ElementFactory<E> elementFactory;

    public AutoPopulatingList(Class<? extends E> clazz) {
        this(new ArrayList(), clazz);
    }

    public AutoPopulatingList(List<E> list, Class<? extends E> clazz) {
        this(list, new ReflectiveElementFactory<E>(clazz));
    }

    public AutoPopulatingList(ElementFactory<E> elementFactory) {
        this(new ArrayList(), elementFactory);
    }

    public AutoPopulatingList(List<E> list, ElementFactory<E> elementFactory) {
        Assert.notNull(list, "Backing List must not be null");
        Assert.notNull(elementFactory, "Element factory must not be null");
        this.backingList = list;
        this.elementFactory = elementFactory;
    }

    @Override
    public void add(int n, E e) {
        this.backingList.add(n, e);
    }

    @Override
    public boolean add(E e) {
        return this.backingList.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.backingList.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        return this.backingList.addAll(n, collection);
    }

    @Override
    public void clear() {
        this.backingList.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.backingList.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.backingList.containsAll(collection);
    }

    @Override
    public E get(int n) {
        int n2 = this.backingList.size();
        Object e = null;
        if (n < n2) {
            e = this.backingList.get(n);
            if (e == null) {
                e = this.elementFactory.createElement(n);
                this.backingList.set(n, e);
            }
        } else {
            for (int i = n2; i < n; ++i) {
                this.backingList.add(null);
            }
            e = this.elementFactory.createElement(n);
            this.backingList.add(e);
        }
        return e;
    }

    @Override
    public int indexOf(Object object) {
        return this.backingList.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.backingList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingList.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.backingList.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.backingList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return this.backingList.listIterator(n);
    }

    @Override
    public E remove(int n) {
        return this.backingList.remove(n);
    }

    @Override
    public boolean remove(Object object) {
        return this.backingList.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.backingList.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.backingList.retainAll(collection);
    }

    @Override
    public E set(int n, E e) {
        return this.backingList.set(n, e);
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public List<E> subList(int n, int n2) {
        return this.backingList.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.backingList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.backingList.toArray(TArray);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return this.backingList.equals(object);
    }

    @Override
    public int hashCode() {
        return this.backingList.hashCode();
    }

    private static class ReflectiveElementFactory<E>
    implements Serializable,
    ElementFactory<E> {
        private final Class<? extends E> elementClass;

        public ReflectiveElementFactory(Class<? extends E> clazz) {
            Assert.notNull(clazz, "Element class must not be null");
            Assert.isTrue(!clazz.isInterface(), "Element class must not be an interface type");
            Assert.isTrue(!Modifier.isAbstract(clazz.getModifiers()), "Element class cannot be an abstract class");
            this.elementClass = clazz;
        }

        @Override
        public E createElement(int n) {
            try {
                return ReflectionUtils.accessibleConstructor(this.elementClass, new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ElementInstantiationException("No default constructor on element class: " + this.elementClass.getName(), noSuchMethodException);
            }
            catch (InstantiationException instantiationException) {
                throw new ElementInstantiationException("Unable to instantiate element class: " + this.elementClass.getName(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ElementInstantiationException("Could not access element constructor: " + this.elementClass.getName(), illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ElementInstantiationException("Failed to invoke element constructor: " + this.elementClass.getName(), invocationTargetException.getTargetException());
            }
        }
    }

    public static class ElementInstantiationException
    extends RuntimeException {
        public ElementInstantiationException(String string) {
            super(string);
        }

        public ElementInstantiationException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    @FunctionalInterface
    public static interface ElementFactory<E> {
        public E createElement(int var1) throws ElementInstantiationException;
    }
}

