/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class AntPathMatcher
implements PathMatcher {
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private static final int CACHE_TURNOFF_THRESHOLD = 65536;
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{[^/]+?\\}");
    private static final char[] WILDCARD_CHARS = new char[]{'*', '?', '{'};
    private String pathSeparator;
    private PathSeparatorPatternCache pathSeparatorPatternCache;
    private boolean caseSensitive = true;
    private boolean trimTokens = false;
    @Nullable
    private volatile Boolean cachePatterns;
    private final Map<String, String[]> tokenizedPatternCache = new ConcurrentHashMap<String, String[]>(256);
    final Map<String, AntPathStringMatcher> stringMatcherCache = new ConcurrentHashMap<String, AntPathStringMatcher>(256);

    public AntPathMatcher() {
        this.pathSeparator = DEFAULT_PATH_SEPARATOR;
        this.pathSeparatorPatternCache = new PathSeparatorPatternCache(DEFAULT_PATH_SEPARATOR);
    }

    public AntPathMatcher(String string) {
        Assert.notNull((Object)string, "'pathSeparator' is required");
        this.pathSeparator = string;
        this.pathSeparatorPatternCache = new PathSeparatorPatternCache(string);
    }

    public void setPathSeparator(@Nullable String string) {
        this.pathSeparator = string != null ? string : DEFAULT_PATH_SEPARATOR;
        this.pathSeparatorPatternCache = new PathSeparatorPatternCache(this.pathSeparator);
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public void setTrimTokens(boolean bl) {
        this.trimTokens = bl;
    }

    public void setCachePatterns(boolean bl) {
        this.cachePatterns = bl;
    }

    private void deactivatePatternCache() {
        this.cachePatterns = false;
        this.tokenizedPatternCache.clear();
        this.stringMatcherCache.clear();
    }

    @Override
    public boolean isPattern(@Nullable String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '*' || c == '?') {
                return true;
            }
            if (c == '{') {
                bl = true;
                continue;
            }
            if (c != '}' || !bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean match(String string, String string2) {
        return this.doMatch(string, string2, true, null);
    }

    @Override
    public boolean matchStart(String string, String string2) {
        return this.doMatch(string, string2, false, null);
    }

    protected boolean doMatch(String string, @Nullable String string2, boolean bl, @Nullable Map<String, String> map) {
        String string3;
        int n;
        if (string2 == null || string2.startsWith(this.pathSeparator) != string.startsWith(this.pathSeparator)) {
            return false;
        }
        String[] stringArray = this.tokenizePattern(string);
        if (bl && this.caseSensitive && !this.isPotentialMatch(string2, stringArray)) {
            return false;
        }
        String[] stringArray2 = this.tokenizePath(string2);
        int n2 = 0;
        int n3 = stringArray.length - 1;
        int n4 = stringArray2.length - 1;
        for (n = 0; n2 <= n3 && n <= n4 && !"**".equals(string3 = stringArray[n2]); ++n2, ++n) {
            if (this.matchStrings(string3, stringArray2[n], map)) continue;
            return false;
        }
        if (n > n4) {
            if (n2 > n3) {
                return string.endsWith(this.pathSeparator) == string2.endsWith(this.pathSeparator);
            }
            if (!bl) {
                return true;
            }
            if (n2 == n3 && stringArray[n2].equals("*") && string2.endsWith(this.pathSeparator)) {
                return true;
            }
            for (int i = n2; i <= n3; ++i) {
                if (stringArray[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (n2 > n3) {
            return false;
        }
        if (!bl && "**".equals(stringArray[n2])) {
            return true;
        }
        while (n2 <= n3 && n <= n4 && !(string3 = stringArray[n3]).equals("**")) {
            if (!this.matchStrings(string3, stringArray2[n4], map)) {
                return false;
            }
            --n3;
            --n4;
        }
        if (n > n4) {
            for (int i = n2; i <= n3; ++i) {
                if (stringArray[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (n2 != n3 && n <= n4) {
            int n5;
            int n6 = -1;
            for (n5 = n2 + 1; n5 <= n3; ++n5) {
                if (!stringArray[n5].equals("**")) continue;
                n6 = n5;
                break;
            }
            if (n6 == n2 + 1) {
                ++n2;
                continue;
            }
            n5 = n6 - n2 - 1;
            int n7 = n4 - n + 1;
            int n8 = -1;
            block6: for (int i = 0; i <= n7 - n5; ++i) {
                for (int j = 0; j < n5; ++j) {
                    String string4 = stringArray[n2 + j + 1];
                    String string5 = stringArray2[n + i + j];
                    if (!this.matchStrings(string4, string5, map)) continue block6;
                }
                n8 = n + i;
                break;
            }
            if (n8 == -1) {
                return false;
            }
            n2 = n6;
            n = n8 + n5;
        }
        for (int i = n2; i <= n3; ++i) {
            if (stringArray[i].equals("**")) continue;
            return false;
        }
        return true;
    }

    private boolean isPotentialMatch(String string, String[] stringArray) {
        if (!this.trimTokens) {
            int n = 0;
            for (String string2 : stringArray) {
                int n2 = this.skipSeparator(string, n, this.pathSeparator);
                if ((n2 = this.skipSegment(string, n += n2, string2)) < string2.length()) {
                    return n2 > 0 || string2.length() > 0 && this.isWildcardChar(string2.charAt(0));
                }
                n += n2;
            }
        }
        return true;
    }

    private int skipSegment(String string, int n, String string2) {
        int n2 = 0;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (this.isWildcardChar(c)) {
                return n2;
            }
            int n3 = n + n2;
            if (n3 >= string.length()) {
                return 0;
            }
            if (c != string.charAt(n3)) continue;
            ++n2;
        }
        return n2;
    }

    private int skipSeparator(String string, int n, String string2) {
        int n2 = 0;
        while (string.startsWith(string2, n + n2)) {
            n2 += string2.length();
        }
        return n2;
    }

    private boolean isWildcardChar(char c) {
        for (char c2 : WILDCARD_CHARS) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    protected String[] tokenizePattern(String string) {
        String[] stringArray = null;
        Boolean bl = this.cachePatterns;
        if (bl == null || bl.booleanValue()) {
            stringArray = this.tokenizedPatternCache.get(string);
        }
        if (stringArray == null) {
            stringArray = this.tokenizePath(string);
            if (bl == null && this.tokenizedPatternCache.size() >= 65536) {
                this.deactivatePatternCache();
                return stringArray;
            }
            if (bl == null || bl.booleanValue()) {
                this.tokenizedPatternCache.put(string, stringArray);
            }
        }
        return stringArray;
    }

    protected String[] tokenizePath(String string) {
        return StringUtils.tokenizeToStringArray(string, this.pathSeparator, this.trimTokens, true);
    }

    private boolean matchStrings(String string, String string2, @Nullable Map<String, String> map) {
        return this.getStringMatcher(string).matchStrings(string2, map);
    }

    protected AntPathStringMatcher getStringMatcher(String string) {
        AntPathStringMatcher antPathStringMatcher = null;
        Boolean bl = this.cachePatterns;
        if (bl == null || bl.booleanValue()) {
            antPathStringMatcher = this.stringMatcherCache.get(string);
        }
        if (antPathStringMatcher == null) {
            antPathStringMatcher = new AntPathStringMatcher(string, this.caseSensitive);
            if (bl == null && this.stringMatcherCache.size() >= 65536) {
                this.deactivatePatternCache();
                return antPathStringMatcher;
            }
            if (bl == null || bl.booleanValue()) {
                this.stringMatcherCache.put(string, antPathStringMatcher);
            }
        }
        return antPathStringMatcher;
    }

    @Override
    public String extractPathWithinPattern(String string, String string2) {
        String[] stringArray = StringUtils.tokenizeToStringArray(string, this.pathSeparator, this.trimTokens, true);
        String[] stringArray2 = StringUtils.tokenizeToStringArray(string2, this.pathSeparator, this.trimTokens, true);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3.indexOf(42) <= -1 && string3.indexOf(63) <= -1) continue;
            while (i < stringArray2.length) {
                if (bl || i == 0 && !string.startsWith(this.pathSeparator)) {
                    stringBuilder.append(this.pathSeparator);
                }
                stringBuilder.append(stringArray2[i]);
                bl = true;
                ++i;
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Map<String, String> extractUriTemplateVariables(String string, String string2) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        boolean bl = this.doMatch(string, string2, true, linkedHashMap);
        if (!bl) {
            throw new IllegalStateException("Pattern \"" + string + "\" is not a match for \"" + string2 + "\"");
        }
        return linkedHashMap;
    }

    @Override
    public String combine(String string, String string2) {
        boolean bl;
        boolean bl2;
        if (!StringUtils.hasText(string) && !StringUtils.hasText(string2)) {
            return "";
        }
        if (!StringUtils.hasText(string)) {
            return string2;
        }
        if (!StringUtils.hasText(string2)) {
            return string;
        }
        boolean bl3 = bl2 = string.indexOf(123) != -1;
        if (!string.equals(string2) && !bl2 && this.match(string, string2)) {
            return string2;
        }
        if (string.endsWith(this.pathSeparatorPatternCache.getEndsOnWildCard())) {
            return this.concat(string.substring(0, string.length() - 2), string2);
        }
        if (string.endsWith(this.pathSeparatorPatternCache.getEndsOnDoubleWildCard())) {
            return this.concat(string, string2);
        }
        int n = string.indexOf("*.");
        if (bl2 || n == -1 || this.pathSeparator.equals(".")) {
            return this.concat(string, string2);
        }
        String string3 = string.substring(n + 1);
        int n2 = string2.indexOf(46);
        String string4 = n2 == -1 ? string2 : string2.substring(0, n2);
        String string5 = n2 == -1 ? "" : string2.substring(n2);
        boolean bl4 = string3.equals(".*") || string3.isEmpty();
        boolean bl5 = bl = string5.equals(".*") || string5.isEmpty();
        if (!bl4 && !bl) {
            throw new IllegalArgumentException("Cannot combine patterns: " + string + " vs " + string2);
        }
        String string6 = bl4 ? string5 : string3;
        return string4 + string6;
    }

    private String concat(String string, String string2) {
        boolean bl = string.endsWith(this.pathSeparator);
        boolean bl2 = string2.startsWith(this.pathSeparator);
        if (bl && bl2) {
            return string + string2.substring(1);
        }
        if (bl || bl2) {
            return string + string2;
        }
        return string + this.pathSeparator + string2;
    }

    @Override
    public Comparator<String> getPatternComparator(String string) {
        return new AntPatternComparator(string);
    }

    private static class PathSeparatorPatternCache {
        private final String endsOnWildCard;
        private final String endsOnDoubleWildCard;

        public PathSeparatorPatternCache(String string) {
            this.endsOnWildCard = string + "*";
            this.endsOnDoubleWildCard = string + "**";
        }

        public String getEndsOnWildCard() {
            return this.endsOnWildCard;
        }

        public String getEndsOnDoubleWildCard() {
            return this.endsOnDoubleWildCard;
        }
    }

    protected static class AntPatternComparator
    implements Comparator<String> {
        private final String path;

        public AntPatternComparator(String string) {
            this.path = string;
        }

        @Override
        public int compare(String string, String string2) {
            PatternInfo patternInfo = new PatternInfo(string);
            PatternInfo patternInfo2 = new PatternInfo(string2);
            if (patternInfo.isLeastSpecific() && patternInfo2.isLeastSpecific()) {
                return 0;
            }
            if (patternInfo.isLeastSpecific()) {
                return 1;
            }
            if (patternInfo2.isLeastSpecific()) {
                return -1;
            }
            boolean bl = string.equals(this.path);
            boolean bl2 = string2.equals(this.path);
            if (bl && bl2) {
                return 0;
            }
            if (bl) {
                return -1;
            }
            if (bl2) {
                return 1;
            }
            if (patternInfo.isPrefixPattern() && patternInfo2.isPrefixPattern()) {
                return patternInfo2.getLength() - patternInfo.getLength();
            }
            if (patternInfo.isPrefixPattern() && patternInfo2.getDoubleWildcards() == 0) {
                return 1;
            }
            if (patternInfo2.isPrefixPattern() && patternInfo.getDoubleWildcards() == 0) {
                return -1;
            }
            if (patternInfo.getTotalCount() != patternInfo2.getTotalCount()) {
                return patternInfo.getTotalCount() - patternInfo2.getTotalCount();
            }
            if (patternInfo.getLength() != patternInfo2.getLength()) {
                return patternInfo2.getLength() - patternInfo.getLength();
            }
            if (patternInfo.getSingleWildcards() < patternInfo2.getSingleWildcards()) {
                return -1;
            }
            if (patternInfo2.getSingleWildcards() < patternInfo.getSingleWildcards()) {
                return 1;
            }
            if (patternInfo.getUriVars() < patternInfo2.getUriVars()) {
                return -1;
            }
            if (patternInfo2.getUriVars() < patternInfo.getUriVars()) {
                return 1;
            }
            return 0;
        }

        private static class PatternInfo {
            @Nullable
            private final String pattern;
            private int uriVars;
            private int singleWildcards;
            private int doubleWildcards;
            private boolean catchAllPattern;
            private boolean prefixPattern;
            @Nullable
            private Integer length;

            public PatternInfo(@Nullable String string) {
                this.pattern = string;
                if (this.pattern != null) {
                    this.initCounters();
                    this.catchAllPattern = this.pattern.equals("/**");
                    boolean bl = this.prefixPattern = !this.catchAllPattern && this.pattern.endsWith("/**");
                }
                if (this.uriVars == 0) {
                    this.length = this.pattern != null ? this.pattern.length() : 0;
                }
            }

            protected void initCounters() {
                int n = 0;
                if (this.pattern != null) {
                    while (n < this.pattern.length()) {
                        if (this.pattern.charAt(n) == '{') {
                            ++this.uriVars;
                            ++n;
                            continue;
                        }
                        if (this.pattern.charAt(n) == '*') {
                            if (n + 1 < this.pattern.length() && this.pattern.charAt(n + 1) == '*') {
                                ++this.doubleWildcards;
                                n += 2;
                                continue;
                            }
                            if (n > 0 && !this.pattern.substring(n - 1).equals(".*")) {
                                ++this.singleWildcards;
                                ++n;
                                continue;
                            }
                            ++n;
                            continue;
                        }
                        ++n;
                    }
                }
            }

            public int getUriVars() {
                return this.uriVars;
            }

            public int getSingleWildcards() {
                return this.singleWildcards;
            }

            public int getDoubleWildcards() {
                return this.doubleWildcards;
            }

            public boolean isLeastSpecific() {
                return this.pattern == null || this.catchAllPattern;
            }

            public boolean isPrefixPattern() {
                return this.prefixPattern;
            }

            public int getTotalCount() {
                return this.uriVars + this.singleWildcards + 2 * this.doubleWildcards;
            }

            public int getLength() {
                if (this.length == null) {
                    this.length = this.pattern != null ? VARIABLE_PATTERN.matcher(this.pattern).replaceAll("#").length() : 0;
                }
                return this.length;
            }
        }
    }

    protected static class AntPathStringMatcher {
        private static final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{((?:\\{[^/]+?\\}|[^/{}]|\\\\[{}])+?)\\}");
        private static final String DEFAULT_VARIABLE_PATTERN = "(.*)";
        private final Pattern pattern;
        private final List<String> variableNames = new LinkedList<String>();

        public AntPathStringMatcher(String string) {
            this(string, true);
        }

        public AntPathStringMatcher(String string, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            Matcher matcher = GLOB_PATTERN.matcher(string);
            int n = 0;
            while (matcher.find()) {
                stringBuilder.append(this.quote(string, n, matcher.start()));
                String string2 = matcher.group();
                if ("?".equals(string2)) {
                    stringBuilder.append('.');
                } else if ("*".equals(string2)) {
                    stringBuilder.append(".*");
                } else if (string2.startsWith("{") && string2.endsWith("}")) {
                    int n2 = string2.indexOf(58);
                    if (n2 == -1) {
                        stringBuilder.append(DEFAULT_VARIABLE_PATTERN);
                        this.variableNames.add(matcher.group(1));
                    } else {
                        String string3 = string2.substring(n2 + 1, string2.length() - 1);
                        stringBuilder.append('(');
                        stringBuilder.append(string3);
                        stringBuilder.append(')');
                        String string4 = string2.substring(1, n2);
                        this.variableNames.add(string4);
                    }
                }
                n = matcher.end();
            }
            stringBuilder.append(this.quote(string, n, string.length()));
            this.pattern = bl ? Pattern.compile(stringBuilder.toString()) : Pattern.compile(stringBuilder.toString(), 2);
        }

        private String quote(String string, int n, int n2) {
            if (n == n2) {
                return "";
            }
            return Pattern.quote(string.substring(n, n2));
        }

        public boolean matchStrings(String string, @Nullable Map<String, String> map) {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                if (map != null) {
                    if (this.variableNames.size() != matcher.groupCount()) {
                        throw new IllegalArgumentException("The number of capturing groups in the pattern segment " + this.pattern + " does not match the number of URI template variables it defines, which can occur if capturing groups are used in a URI template regex. Use non-capturing groups instead.");
                    }
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                        String string2 = this.variableNames.get(i - 1);
                        String string3 = matcher.group(i);
                        map.put(string2, string3);
                    }
                }
                return true;
            }
            return false;
        }
    }
}

