/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.instantiator.android;

import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.instantiator.ObjectInstantiator;
import org.springframework.objenesis.instantiator.annotations.Instantiator;
import org.springframework.objenesis.instantiator.annotations.Typology;

@Instantiator(value=Typology.STANDARD)
public class Android18Instantiator<T>
implements ObjectInstantiator<T> {
    private final Class<T> type;
    private final Method newInstanceMethod;
    private final Long objectConstructorId;

    public Android18Instantiator(Class<T> clazz) {
        this.type = clazz;
        this.newInstanceMethod = Android18Instantiator.getNewInstanceMethod();
        this.objectConstructorId = Android18Instantiator.findConstructorIdForJavaLangObjectConstructor();
    }

    @Override
    public T newInstance() {
        try {
            return this.type.cast(this.newInstanceMethod.invoke(null, this.type, this.objectConstructorId));
        }
        catch (Exception exception) {
            throw new ObjenesisException(exception);
        }
    }

    private static Method getNewInstanceMethod() {
        try {
            Method method = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class, Long.TYPE);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException | RuntimeException exception) {
            throw new ObjenesisException(exception);
        }
    }

    private static Long findConstructorIdForJavaLangObjectConstructor() {
        try {
            Method method = ObjectStreamClass.class.getDeclaredMethod("getConstructorId", Class.class);
            method.setAccessible(true);
            return (Long)method.invoke(null, Object.class);
        }
        catch (IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException exception) {
            throw new ObjenesisException(exception);
        }
    }
}

