/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis;

import org.springframework.core.SpringProperties;
import org.springframework.objenesis.Objenesis;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.instantiator.ObjectInstantiator;
import org.springframework.objenesis.strategy.InstantiatorStrategy;
import org.springframework.objenesis.strategy.StdInstantiatorStrategy;
import org.springframework.util.ConcurrentReferenceHashMap;

public class SpringObjenesis
implements Objenesis {
    public static final String IGNORE_OBJENESIS_PROPERTY_NAME = "spring.objenesis.ignore";
    private final InstantiatorStrategy strategy;
    private final ConcurrentReferenceHashMap<Class<?>, ObjectInstantiator<?>> cache = new ConcurrentReferenceHashMap();
    private volatile Boolean worthTrying;

    public SpringObjenesis() {
        this(null);
    }

    public SpringObjenesis(InstantiatorStrategy instantiatorStrategy) {
        InstantiatorStrategy instantiatorStrategy2 = this.strategy = instantiatorStrategy != null ? instantiatorStrategy : new StdInstantiatorStrategy();
        if (SpringProperties.getFlag(IGNORE_OBJENESIS_PROPERTY_NAME)) {
            this.worthTrying = Boolean.FALSE;
        }
    }

    public boolean isWorthTrying() {
        return this.worthTrying != Boolean.FALSE;
    }

    public <T> T newInstance(Class<T> clazz, boolean bl) {
        if (!bl) {
            return this.newInstantiatorOf(clazz).newInstance();
        }
        return this.getInstantiatorOf(clazz).newInstance();
    }

    @Override
    public <T> T newInstance(Class<T> clazz) {
        return this.getInstantiatorOf(clazz).newInstance();
    }

    @Override
    public <T> ObjectInstantiator<T> getInstantiatorOf(Class<T> clazz) {
        ObjectInstantiator<T> objectInstantiator;
        ObjectInstantiator<Object> objectInstantiator2 = this.cache.get(clazz);
        if (objectInstantiator2 == null && (objectInstantiator2 = this.cache.putIfAbsent(clazz, objectInstantiator = this.newInstantiatorOf(clazz))) == null) {
            objectInstantiator2 = objectInstantiator;
        }
        return objectInstantiator2;
    }

    protected <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> clazz) {
        Boolean bl = this.worthTrying;
        try {
            ObjectInstantiator<T> objectInstantiator = this.strategy.newInstantiatorOf(clazz);
            if (bl == null) {
                this.worthTrying = Boolean.TRUE;
            }
            return objectInstantiator;
        }
        catch (ObjenesisException objenesisException) {
            Throwable throwable;
            if (bl == null && ((throwable = objenesisException.getCause()) instanceof ClassNotFoundException || throwable instanceof IllegalAccessException)) {
                this.worthTrying = Boolean.FALSE;
            }
            throw objenesisException;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (bl == null) {
                this.worthTrying = Boolean.FALSE;
            }
            throw new ObjenesisException(noClassDefFoundError);
        }
    }
}

