/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.filter;

import org.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class AssignableTypeFilter
extends AbstractTypeHierarchyTraversingFilter {
    private final Class<?> targetType;

    public AssignableTypeFilter(Class<?> clazz) {
        super(true, true);
        this.targetType = clazz;
    }

    public final Class<?> getTargetType() {
        return this.targetType;
    }

    @Override
    protected boolean matchClassName(String string) {
        return this.targetType.getName().equals(string);
    }

    @Override
    @Nullable
    protected Boolean matchSuperClass(String string) {
        return this.matchTargetType(string);
    }

    @Override
    @Nullable
    protected Boolean matchInterface(String string) {
        return this.matchTargetType(string);
    }

    @Nullable
    protected Boolean matchTargetType(String string) {
        if (this.targetType.getName().equals(string)) {
            return true;
        }
        if (Object.class.getName().equals(string)) {
            return false;
        }
        if (string.startsWith("java")) {
            try {
                Class<?> clazz = ClassUtils.forName(string, this.getClass().getClassLoader());
                return this.targetType.isAssignableFrom(clazz);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

