/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.core.type.MethodMetadata;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public class StandardMethodMetadata
implements MethodMetadata {
    private final Method introspectedMethod;
    private final boolean nestedAnnotationsAsMap;
    private final MergedAnnotations mergedAnnotations;

    @Deprecated
    public StandardMethodMetadata(Method method) {
        this(method, false);
    }

    @Deprecated
    public StandardMethodMetadata(Method method, boolean bl) {
        Assert.notNull((Object)method, "Method must not be null");
        this.introspectedMethod = method;
        this.nestedAnnotationsAsMap = bl;
        this.mergedAnnotations = MergedAnnotations.from(method, MergedAnnotations.SearchStrategy.DIRECT, RepeatableContainers.none());
    }

    @Override
    public MergedAnnotations getAnnotations() {
        return this.mergedAnnotations;
    }

    public final Method getIntrospectedMethod() {
        return this.introspectedMethod;
    }

    @Override
    public String getMethodName() {
        return this.introspectedMethod.getName();
    }

    @Override
    public String getDeclaringClassName() {
        return this.introspectedMethod.getDeclaringClass().getName();
    }

    @Override
    public String getReturnTypeName() {
        return this.introspectedMethod.getReturnType().getName();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.introspectedMethod.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.introspectedMethod.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.introspectedMethod.getModifiers());
    }

    @Override
    public boolean isOverridable() {
        return !this.isStatic() && !this.isFinal() && !this.isPrivate();
    }

    private boolean isPrivate() {
        return Modifier.isPrivate(this.introspectedMethod.getModifiers());
    }

    @Override
    @Nullable
    public Map<String, Object> getAnnotationAttributes(String string, boolean bl) {
        if (this.nestedAnnotationsAsMap) {
            return MethodMetadata.super.getAnnotationAttributes(string, bl);
        }
        return AnnotatedElementUtils.getMergedAnnotationAttributes(this.introspectedMethod, string, bl, false);
    }

    @Override
    @Nullable
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String string, boolean bl) {
        if (this.nestedAnnotationsAsMap) {
            return MethodMetadata.super.getAllAnnotationAttributes(string, bl);
        }
        return AnnotatedElementUtils.getAllAnnotationAttributes(this.introspectedMethod, string, bl, false);
    }
}

