/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;

public interface AnnotationMetadata
extends AnnotatedTypeMetadata,
ClassMetadata {
    default public Set<String> getAnnotationTypes() {
        return this.getAnnotations().stream().filter(MergedAnnotation::isDirectlyPresent).map(mergedAnnotation -> mergedAnnotation.getType().getName()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    default public Set<String> getMetaAnnotationTypes(String string) {
        MergedAnnotation mergedAnnotation2 = this.getAnnotations().get(string, MergedAnnotation::isDirectlyPresent);
        if (!mergedAnnotation2.isPresent()) {
            return Collections.emptySet();
        }
        return MergedAnnotations.from(mergedAnnotation2.getType(), MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).stream().map(mergedAnnotation -> mergedAnnotation.getType().getName()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    default public boolean hasAnnotation(String string) {
        return this.getAnnotations().isDirectlyPresent(string);
    }

    default public boolean hasMetaAnnotation(String string) {
        return this.getAnnotations().get(string, MergedAnnotation::isMetaPresent).isPresent();
    }

    default public boolean hasAnnotatedMethods(String string) {
        return !this.getAnnotatedMethods(string).isEmpty();
    }

    public Set<MethodMetadata> getAnnotatedMethods(String var1);

    public static AnnotationMetadata introspect(Class<?> clazz) {
        return StandardAnnotationMetadata.from(clazz);
    }
}

