/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.task;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrencyThrottleSupport;
import org.springframework.util.CustomizableThreadCreator;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureTask;

public class SimpleAsyncTaskExecutor
extends CustomizableThreadCreator
implements Serializable,
AsyncListenableTaskExecutor {
    public static final int UNBOUNDED_CONCURRENCY = -1;
    public static final int NO_CONCURRENCY = 0;
    private final ConcurrencyThrottleAdapter concurrencyThrottle = new ConcurrencyThrottleAdapter();
    @Nullable
    private ThreadFactory threadFactory;
    @Nullable
    private TaskDecorator taskDecorator;

    public SimpleAsyncTaskExecutor() {
    }

    public SimpleAsyncTaskExecutor(String string) {
        super(string);
    }

    public SimpleAsyncTaskExecutor(ThreadFactory threadFactory2) {
        this.threadFactory = threadFactory2;
    }

    public void setThreadFactory(@Nullable ThreadFactory threadFactory2) {
        this.threadFactory = threadFactory2;
    }

    @Nullable
    public final ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public final void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    public void setConcurrencyLimit(int n) {
        this.concurrencyThrottle.setConcurrencyLimit(n);
    }

    public final int getConcurrencyLimit() {
        return this.concurrencyThrottle.getConcurrencyLimit();
    }

    public final boolean isThrottleActive() {
        return this.concurrencyThrottle.isThrottleActive();
    }

    @Override
    public void execute(Runnable runnable2) {
        this.execute(runnable2, Long.MAX_VALUE);
    }

    @Override
    public void execute(Runnable runnable2, long l) {
        Runnable runnable3;
        Assert.notNull((Object)runnable2, "Runnable must not be null");
        Runnable runnable4 = runnable3 = this.taskDecorator != null ? this.taskDecorator.decorate(runnable2) : runnable2;
        if (this.isThrottleActive() && l > 0L) {
            this.concurrencyThrottle.beforeAccess();
            this.doExecute(new ConcurrencyThrottlingRunnable(runnable3));
        } else {
            this.doExecute(runnable3);
        }
    }

    @Override
    public Future<?> submit(Runnable runnable2) {
        FutureTask<Object> futureTask = new FutureTask<Object>(runnable2, null);
        this.execute(futureTask, Long.MAX_VALUE);
        return futureTask;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        this.execute(futureTask, Long.MAX_VALUE);
        return futureTask;
    }

    @Override
    public ListenableFuture<?> submitListenable(Runnable runnable2) {
        ListenableFutureTask<Object> listenableFutureTask = new ListenableFutureTask<Object>(runnable2, null);
        this.execute(listenableFutureTask, Long.MAX_VALUE);
        return listenableFutureTask;
    }

    @Override
    public <T> ListenableFuture<T> submitListenable(Callable<T> callable) {
        ListenableFutureTask<T> listenableFutureTask = new ListenableFutureTask<T>(callable);
        this.execute(listenableFutureTask, Long.MAX_VALUE);
        return listenableFutureTask;
    }

    protected void doExecute(Runnable runnable2) {
        Thread thread2 = this.threadFactory != null ? this.threadFactory.newThread(runnable2) : this.createThread(runnable2);
        thread2.start();
    }

    private class ConcurrencyThrottlingRunnable
    implements Runnable {
        private final Runnable target;

        public ConcurrencyThrottlingRunnable(Runnable runnable2) {
            this.target = runnable2;
        }

        @Override
        public void run() {
            try {
                this.target.run();
            }
            finally {
                SimpleAsyncTaskExecutor.this.concurrencyThrottle.afterAccess();
            }
        }
    }

    private static class ConcurrencyThrottleAdapter
    extends ConcurrencyThrottleSupport {
        private ConcurrencyThrottleAdapter() {
        }

        @Override
        protected void beforeAccess() {
            super.beforeAccess();
        }

        @Override
        protected void afterAccess() {
            super.afterAccess();
        }
    }
}

