/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.style;

import org.springframework.core.style.ToStringStyler;
import org.springframework.core.style.ValueStyler;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class DefaultToStringStyler
implements ToStringStyler {
    private final ValueStyler valueStyler;

    public DefaultToStringStyler(ValueStyler valueStyler) {
        Assert.notNull((Object)valueStyler, "ValueStyler must not be null");
        this.valueStyler = valueStyler;
    }

    protected final ValueStyler getValueStyler() {
        return this.valueStyler;
    }

    @Override
    public void styleStart(StringBuilder stringBuilder, Object object) {
        if (!object.getClass().isArray()) {
            stringBuilder.append('[').append(ClassUtils.getShortName(object.getClass()));
            this.styleIdentityHashCode(stringBuilder, object);
        } else {
            stringBuilder.append('[');
            this.styleIdentityHashCode(stringBuilder, object);
            stringBuilder.append(' ');
            this.styleValue(stringBuilder, object);
        }
    }

    private void styleIdentityHashCode(StringBuilder stringBuilder, Object object) {
        stringBuilder.append('@');
        stringBuilder.append(ObjectUtils.getIdentityHexString(object));
    }

    @Override
    public void styleEnd(StringBuilder stringBuilder, Object object) {
        stringBuilder.append(']');
    }

    @Override
    public void styleField(StringBuilder stringBuilder, String string, @Nullable Object object) {
        this.styleFieldStart(stringBuilder, string);
        this.styleValue(stringBuilder, object);
        this.styleFieldEnd(stringBuilder, string);
    }

    protected void styleFieldStart(StringBuilder stringBuilder, String string) {
        stringBuilder.append(' ').append(string).append(" = ");
    }

    protected void styleFieldEnd(StringBuilder stringBuilder, String string) {
    }

    @Override
    public void styleValue(StringBuilder stringBuilder, @Nullable Object object) {
        stringBuilder.append(this.valueStyler.style(object));
    }

    @Override
    public void styleFieldSeparator(StringBuilder stringBuilder) {
        stringBuilder.append(',');
    }
}

