/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class SpringFactoriesLoader {
    public static final String FACTORIES_RESOURCE_LOCATION = "META-INF/spring.factories";
    private static final Log logger = LogFactory.getLog(SpringFactoriesLoader.class);
    private static final Map<ClassLoader, MultiValueMap<String, String>> cache = new ConcurrentReferenceHashMap<ClassLoader, MultiValueMap<String, String>>();

    private SpringFactoriesLoader() {
    }

    public static <T> List<T> loadFactories(Class<T> clazz, @Nullable ClassLoader classLoader) {
        Assert.notNull(clazz, "'factoryType' must not be null");
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = SpringFactoriesLoader.class.getClassLoader();
        }
        List<String> list = SpringFactoriesLoader.loadFactoryNames(clazz, classLoader2);
        if (logger.isTraceEnabled()) {
            logger.trace("Loaded [" + clazz.getName() + "] names: " + list);
        }
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        for (String string : list) {
            arrayList.add(SpringFactoriesLoader.instantiateFactory(string, clazz, classLoader2));
        }
        AnnotationAwareOrderComparator.sort(arrayList);
        return arrayList;
    }

    public static List<String> loadFactoryNames(Class<?> clazz, @Nullable ClassLoader classLoader) {
        String string = clazz.getName();
        return SpringFactoriesLoader.loadSpringFactories(classLoader).getOrDefault(string, Collections.emptyList());
    }

    private static Map<String, List<String>> loadSpringFactories(@Nullable ClassLoader classLoader) {
        MultiValueMap<String, String> multiValueMap = cache.get(classLoader);
        if (multiValueMap != null) {
            return multiValueMap;
        }
        try {
            Enumeration<URL> enumeration = classLoader != null ? classLoader.getResources(FACTORIES_RESOURCE_LOCATION) : ClassLoader.getSystemResources(FACTORIES_RESOURCE_LOCATION);
            multiValueMap = new LinkedMultiValueMap<String, String>();
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                UrlResource urlResource = new UrlResource(uRL);
                Properties properties = PropertiesLoaderUtils.loadProperties(urlResource);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String string = ((String)entry.getKey()).trim();
                    for (String string2 : StringUtils.commaDelimitedListToStringArray((String)entry.getValue())) {
                        multiValueMap.add(string, string2.trim());
                    }
                }
            }
            cache.put(classLoader, multiValueMap);
            return multiValueMap;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to load factories from location [META-INF/spring.factories]", iOException);
        }
    }

    private static <T> T instantiateFactory(String string, Class<T> clazz, ClassLoader classLoader) {
        try {
            Class<?> clazz2 = ClassUtils.forName(string, classLoader);
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new IllegalArgumentException("Class [" + string + "] is not assignable to factory type [" + clazz.getName() + "]");
            }
            return (T)ReflectionUtils.accessibleConstructor(clazz2, new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Unable to instantiate factory class [" + string + "] for factory type [" + clazz.getName() + "]", throwable);
        }
    }
}

