/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.VfsResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.VfsPatternUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class PathMatchingResourcePatternResolver
implements ResourcePatternResolver {
    private static final Log logger = LogFactory.getLog(PathMatchingResourcePatternResolver.class);
    @Nullable
    private static Method equinoxResolveMethod;
    private final ResourceLoader resourceLoader;
    private PathMatcher pathMatcher = new AntPathMatcher();

    public PathMatchingResourcePatternResolver() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public PathMatchingResourcePatternResolver(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public PathMatchingResourcePatternResolver(@Nullable ClassLoader classLoader) {
        this.resourceLoader = new DefaultResourceLoader(classLoader);
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    @Nullable
    public ClassLoader getClassLoader() {
        return this.getResourceLoader().getClassLoader();
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, "PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    @Override
    public Resource getResource(String string) {
        return this.getResourceLoader().getResource(string);
    }

    @Override
    public Resource[] getResources(String string) throws IOException {
        int n;
        Assert.notNull((Object)string, "Location pattern must not be null");
        if (string.startsWith("classpath*:")) {
            if (this.getPathMatcher().isPattern(string.substring("classpath*:".length()))) {
                return this.findPathMatchingResources(string);
            }
            return this.findAllClassPathResources(string.substring("classpath*:".length()));
        }
        int n2 = n = string.startsWith("war:") ? string.indexOf("*/") + 1 : string.indexOf(58) + 1;
        if (this.getPathMatcher().isPattern(string.substring(n))) {
            return this.findPathMatchingResources(string);
        }
        return new Resource[]{this.getResourceLoader().getResource(string)};
    }

    protected Resource[] findAllClassPathResources(String string) throws IOException {
        String string2 = string;
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        Set<Resource> set = this.doFindAllClassPathResources(string2);
        if (logger.isTraceEnabled()) {
            logger.trace("Resolved classpath location [" + string + "] to resources " + set);
        }
        return set.toArray(new Resource[0]);
    }

    protected Set<Resource> doFindAllClassPathResources(String string) throws IOException {
        Enumeration<URL> enumeration;
        LinkedHashSet<Resource> linkedHashSet = new LinkedHashSet<Resource>(16);
        ClassLoader classLoader = this.getClassLoader();
        Enumeration<URL> enumeration2 = enumeration = classLoader != null ? classLoader.getResources(string) : ClassLoader.getSystemResources(string);
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            linkedHashSet.add(this.convertClassLoaderURL(uRL));
        }
        if (!StringUtils.hasLength(string)) {
            this.addAllClassLoaderJarRoots(classLoader, linkedHashSet);
        }
        return linkedHashSet;
    }

    protected Resource convertClassLoaderURL(URL uRL) {
        return new UrlResource(uRL);
    }

    protected void addAllClassLoaderJarRoots(@Nullable ClassLoader classLoader, Set<Resource> set) {
        block11: {
            block10: {
                if (classLoader instanceof URLClassLoader) {
                    try {
                        for (URL uRL : ((URLClassLoader)classLoader).getURLs()) {
                            try {
                                UrlResource urlResource;
                                UrlResource urlResource2 = urlResource = "jar".equals(uRL.getProtocol()) ? new UrlResource(uRL) : new UrlResource("jar:" + uRL + "!/");
                                if (!urlResource.exists()) continue;
                                set.add(urlResource);
                            }
                            catch (MalformedURLException malformedURLException) {
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug("Cannot search for matching files underneath [" + uRL + "] because it cannot be converted to a valid 'jar:' URL: " + malformedURLException.getMessage());
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (!logger.isDebugEnabled()) break block10;
                        logger.debug("Cannot introspect jar files since ClassLoader [" + classLoader + "] does not support 'getURLs()': " + exception);
                    }
                }
            }
            if (classLoader == ClassLoader.getSystemClassLoader()) {
                this.addClassPathManifestEntries(set);
            }
            if (classLoader != null) {
                try {
                    this.addAllClassLoaderJarRoots(classLoader.getParent(), set);
                }
                catch (Exception exception) {
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug("Cannot introspect jar files in parent ClassLoader since [" + classLoader + "] does not support 'getParent()': " + exception);
                }
            }
        }
    }

    protected void addClassPathManifestEntries(Set<Resource> set) {
        block6: {
            try {
                String string = System.getProperty("java.class.path");
                for (String string2 : StringUtils.delimitedListToStringArray(string, System.getProperty("path.separator"))) {
                    try {
                        String string3 = new File(string2).getAbsolutePath();
                        int n = string3.indexOf(58);
                        if (n == 1) {
                            string3 = StringUtils.capitalize(string3);
                        }
                        string3 = StringUtils.replace(string3, "#", "%23");
                        UrlResource urlResource = new UrlResource("jar:file:" + string3 + "!/");
                        if (set.contains(urlResource) || this.hasDuplicate(string3, set) || !urlResource.exists()) continue;
                        set.add(urlResource);
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Cannot search for matching files underneath [" + string2 + "] because it cannot be converted to a valid 'jar:' URL: " + malformedURLException.getMessage());
                    }
                }
            }
            catch (Exception exception) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("Failed to evaluate 'java.class.path' manifest entries: " + exception);
            }
        }
    }

    private boolean hasDuplicate(String string, Set<Resource> set) {
        if (set.isEmpty()) {
            return false;
        }
        String string2 = string.startsWith("/") ? string.substring(1) : "/" + string;
        try {
            return set.contains(new UrlResource("jar:file:" + string2 + "!/"));
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    protected Resource[] findPathMatchingResources(String string) throws IOException {
        String string2 = this.determineRootDir(string);
        String string3 = string.substring(string2.length());
        Resource[] resourceArray = this.getResources(string2);
        LinkedHashSet<Resource> linkedHashSet = new LinkedHashSet<Resource>(16);
        for (Resource resource : resourceArray) {
            resource = this.resolveRootDirResource(resource);
            URL uRL = resource.getURL();
            if (equinoxResolveMethod != null && uRL.getProtocol().startsWith("bundle")) {
                URL uRL2 = (URL)ReflectionUtils.invokeMethod(equinoxResolveMethod, null, uRL);
                if (uRL2 != null) {
                    uRL = uRL2;
                }
                resource = new UrlResource(uRL);
            }
            if (uRL.getProtocol().startsWith("vfs")) {
                linkedHashSet.addAll(VfsResourceMatchingDelegate.findMatchingResources(uRL, string3, this.getPathMatcher()));
                continue;
            }
            if (ResourceUtils.isJarURL(uRL) || this.isJarResource(resource)) {
                linkedHashSet.addAll(this.doFindPathMatchingJarResources(resource, uRL, string3));
                continue;
            }
            linkedHashSet.addAll(this.doFindPathMatchingFileResources(resource, string3));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Resolved location pattern [" + string + "] to resources " + linkedHashSet);
        }
        return linkedHashSet.toArray(new Resource[0]);
    }

    protected String determineRootDir(String string) {
        int n = string.indexOf(58) + 1;
        int n2 = string.length();
        while (n2 > n && this.getPathMatcher().isPattern(string.substring(n, n2))) {
            n2 = string.lastIndexOf(47, n2 - 2) + 1;
        }
        if (n2 == 0) {
            n2 = n;
        }
        return string.substring(0, n2);
    }

    protected Resource resolveRootDirResource(Resource resource) throws IOException {
        return resource;
    }

    protected boolean isJarResource(Resource resource) throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Resource> doFindPathMatchingJarResources(Resource resource, URL uRL, String string) throws IOException {
        boolean bl;
        String string2;
        LinkedHashSet<Resource> linkedHashSet;
        Object object;
        JarFile jarFile;
        LinkedHashSet<Resource> linkedHashSet2;
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof JarURLConnection) {
            linkedHashSet2 = (JarURLConnection)uRLConnection;
            ResourceUtils.useCachesIfNecessary((URLConnection)((Object)linkedHashSet2));
            jarFile = ((JarURLConnection)((Object)linkedHashSet2)).getJarFile();
            object = ((JarURLConnection)((Object)linkedHashSet2)).getJarFileURL().toExternalForm();
            linkedHashSet = ((JarURLConnection)((Object)linkedHashSet2)).getJarEntry();
            string2 = linkedHashSet != null ? ((ZipEntry)((Object)linkedHashSet)).getName() : "";
            bl = !((URLConnection)((Object)linkedHashSet2)).getUseCaches();
        } else {
            linkedHashSet2 = uRL.getFile();
            try {
                int n = ((String)((Object)linkedHashSet2)).indexOf("*/");
                if (n == -1) {
                    n = ((String)((Object)linkedHashSet2)).indexOf("!/");
                }
                if (n != -1) {
                    object = ((String)((Object)linkedHashSet2)).substring(0, n);
                    string2 = ((String)((Object)linkedHashSet2)).substring(n + 2);
                    jarFile = this.getJarFile((String)object);
                } else {
                    jarFile = new JarFile((String)((Object)linkedHashSet2));
                    object = linkedHashSet2;
                    string2 = "";
                }
                bl = true;
            }
            catch (ZipException zipException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Skipping invalid jar classpath entry [" + (String)((Object)linkedHashSet2) + "]");
                }
                return Collections.emptySet();
            }
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("Looking for matching resources in jar file [" + (String)object + "]");
            }
            if (StringUtils.hasLength(string2) && !string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            linkedHashSet2 = new LinkedHashSet<Resource>(8);
            linkedHashSet = jarFile.entries();
            while (linkedHashSet.hasMoreElements()) {
                JarEntry jarEntry = (JarEntry)linkedHashSet.nextElement();
                String string3 = jarEntry.getName();
                if (!string3.startsWith(string2)) continue;
                String string4 = string3.substring(string2.length());
                if (!this.getPathMatcher().match(string, string4)) continue;
                linkedHashSet2.add(resource.createRelative(string4));
            }
            linkedHashSet = linkedHashSet2;
            return linkedHashSet;
        }
        finally {
            if (bl) {
                jarFile.close();
            }
        }
    }

    protected JarFile getJarFile(String string) throws IOException {
        if (string.startsWith("file:")) {
            try {
                return new JarFile(ResourceUtils.toURI(string).getSchemeSpecificPart());
            }
            catch (URISyntaxException uRISyntaxException) {
                return new JarFile(string.substring("file:".length()));
            }
        }
        return new JarFile(string);
    }

    protected Set<Resource> doFindPathMatchingFileResources(Resource resource, String string) throws IOException {
        File file;
        try {
            file = resource.getFile().getAbsoluteFile();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot search for matching files underneath " + resource + " in the file system: " + fileNotFoundException.getMessage());
            }
            return Collections.emptySet();
        }
        catch (Exception exception) {
            if (logger.isInfoEnabled()) {
                logger.info("Failed to resolve " + resource + " in the file system: " + exception);
            }
            return Collections.emptySet();
        }
        return this.doFindMatchingFileSystemResources(file, string);
    }

    protected Set<Resource> doFindMatchingFileSystemResources(File file, String string) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace("Looking for matching resources in directory tree [" + file.getPath() + "]");
        }
        Set<File> set = this.retrieveMatchingFiles(file, string);
        LinkedHashSet<Resource> linkedHashSet = new LinkedHashSet<Resource>(set.size());
        for (File file2 : set) {
            linkedHashSet.add(new FileSystemResource(file2));
        }
        return linkedHashSet;
    }

    protected Set<File> retrieveMatchingFiles(File file, String string) throws IOException {
        if (!file.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping [" + file.getAbsolutePath() + "] because it does not exist");
            }
            return Collections.emptySet();
        }
        if (!file.isDirectory()) {
            if (logger.isInfoEnabled()) {
                logger.info("Skipping [" + file.getAbsolutePath() + "] because it does not denote a directory");
            }
            return Collections.emptySet();
        }
        if (!file.canRead()) {
            if (logger.isInfoEnabled()) {
                logger.info("Skipping search for matching files underneath directory [" + file.getAbsolutePath() + "] because the application is not allowed to read the directory");
            }
            return Collections.emptySet();
        }
        String string2 = StringUtils.replace(file.getAbsolutePath(), File.separator, "/");
        if (!string.startsWith("/")) {
            string2 = string2 + "/";
        }
        string2 = string2 + StringUtils.replace(string, File.separator, "/");
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>(8);
        this.doRetrieveMatchingFiles(string2, file, linkedHashSet);
        return linkedHashSet;
    }

    protected void doRetrieveMatchingFiles(String string, File file, Set<File> set) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace("Searching directory [" + file.getAbsolutePath() + "] for files matching pattern [" + string + "]");
        }
        for (File file2 : this.listDirectory(file)) {
            String string2 = StringUtils.replace(file2.getAbsolutePath(), File.separator, "/");
            if (file2.isDirectory() && this.getPathMatcher().matchStart(string, string2 + "/")) {
                if (!file2.canRead()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Skipping subdirectory [" + file.getAbsolutePath() + "] because the application is not allowed to read the directory");
                    }
                } else {
                    this.doRetrieveMatchingFiles(string, file2, set);
                }
            }
            if (!this.getPathMatcher().match(string, string2)) continue;
            set.add(file2);
        }
    }

    protected File[] listDirectory(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Could not retrieve contents of directory [" + file.getAbsolutePath() + "]");
            }
            return new File[0];
        }
        Arrays.sort(fileArray, Comparator.comparing(File::getName));
        return fileArray;
    }

    static {
        try {
            Class<?> clazz = ClassUtils.forName("org.eclipse.core.runtime.FileLocator", PathMatchingResourcePatternResolver.class.getClassLoader());
            equinoxResolveMethod = clazz.getMethod("resolve", URL.class);
            logger.trace("Found Equinox FileLocator for OSGi bundle URL resolution");
        }
        catch (Throwable throwable) {
            equinoxResolveMethod = null;
        }
    }

    private static class PatternVirtualFileVisitor
    implements InvocationHandler {
        private final String subPattern;
        private final PathMatcher pathMatcher;
        private final String rootPath;
        private final Set<Resource> resources = new LinkedHashSet<Resource>();

        public PatternVirtualFileVisitor(String string, String string2, PathMatcher pathMatcher) {
            this.subPattern = string2;
            this.pathMatcher = pathMatcher;
            this.rootPath = string.isEmpty() || string.endsWith("/") ? string : string + "/";
        }

        @Override
        @Nullable
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (Object.class == method.getDeclaringClass()) {
                if (string.equals("equals")) {
                    return object == objectArray[0];
                }
                if (string.equals("hashCode")) {
                    return System.identityHashCode(object);
                }
            } else {
                if ("getAttributes".equals(string)) {
                    return this.getAttributes();
                }
                if ("visit".equals(string)) {
                    this.visit(objectArray[0]);
                    return null;
                }
                if ("toString".equals(string)) {
                    return this.toString();
                }
            }
            throw new IllegalStateException("Unexpected method invocation: " + method);
        }

        public void visit(Object object) {
            if (this.pathMatcher.match(this.subPattern, VfsPatternUtils.getPath(object).substring(this.rootPath.length()))) {
                this.resources.add(new VfsResource(object));
            }
        }

        @Nullable
        public Object getAttributes() {
            return VfsPatternUtils.getVisitorAttributes();
        }

        public Set<Resource> getResources() {
            return this.resources;
        }

        public int size() {
            return this.resources.size();
        }

        public String toString() {
            return "sub-pattern: " + this.subPattern + ", resources: " + this.resources;
        }
    }

    private static class VfsResourceMatchingDelegate {
        private VfsResourceMatchingDelegate() {
        }

        public static Set<Resource> findMatchingResources(URL uRL, String string, PathMatcher pathMatcher) throws IOException {
            Object object = VfsPatternUtils.findRoot(uRL);
            PatternVirtualFileVisitor patternVirtualFileVisitor = new PatternVirtualFileVisitor(VfsPatternUtils.getPath(object), string, pathMatcher);
            VfsPatternUtils.visit(object, patternVirtualFileVisitor);
            return patternVirtualFileVisitor.getResources();
        }
    }
}

