/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.util.Locale;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class LocalizedResourceHelper {
    public static final String DEFAULT_SEPARATOR = "_";
    private final ResourceLoader resourceLoader;
    private String separator = "_";

    public LocalizedResourceHelper() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public LocalizedResourceHelper(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public void setSeparator(@Nullable String string) {
        this.separator = string != null ? string : DEFAULT_SEPARATOR;
    }

    public Resource findLocalizedResource(String string, String string2, @Nullable Locale locale) {
        String string3;
        Assert.notNull((Object)string, "Name must not be null");
        Assert.notNull((Object)string2, "Extension must not be null");
        Resource resource = null;
        if (locale != null) {
            String string4;
            string3 = locale.getLanguage();
            String string5 = locale.getCountry();
            String string6 = locale.getVariant();
            if (string6.length() > 0) {
                string4 = string + this.separator + string3 + this.separator + string5 + this.separator + string6 + string2;
                resource = this.resourceLoader.getResource(string4);
            }
            if (!(resource != null && resource.exists() || string5.length() <= 0)) {
                string4 = string + this.separator + string3 + this.separator + string5 + string2;
                resource = this.resourceLoader.getResource(string4);
            }
            if (!(resource != null && resource.exists() || string3.length() <= 0)) {
                string4 = string + this.separator + string3 + string2;
                resource = this.resourceLoader.getResource(string4);
            }
        }
        if (resource == null || !resource.exists()) {
            string3 = string + string2;
            resource = this.resourceLoader.getResource(string3);
        }
        return resource;
    }
}

