/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.List;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.util.Assert;

public class NettyDataBufferFactory
implements DataBufferFactory {
    private final ByteBufAllocator byteBufAllocator;

    public NettyDataBufferFactory(ByteBufAllocator byteBufAllocator) {
        Assert.notNull((Object)byteBufAllocator, "ByteBufAllocator must not be null");
        this.byteBufAllocator = byteBufAllocator;
    }

    public ByteBufAllocator getByteBufAllocator() {
        return this.byteBufAllocator;
    }

    @Override
    public NettyDataBuffer allocateBuffer() {
        ByteBuf byteBuf = this.byteBufAllocator.buffer();
        return new NettyDataBuffer(byteBuf, this);
    }

    @Override
    public NettyDataBuffer allocateBuffer(int n) {
        ByteBuf byteBuf = this.byteBufAllocator.buffer(n);
        return new NettyDataBuffer(byteBuf, this);
    }

    @Override
    public NettyDataBuffer wrap(ByteBuffer byteBuffer) {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuffer)byteBuffer);
        return new NettyDataBuffer(byteBuf, this);
    }

    @Override
    public DataBuffer wrap(byte[] byArray) {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])byArray);
        return new NettyDataBuffer(byteBuf, this);
    }

    public NettyDataBuffer wrap(ByteBuf byteBuf) {
        byteBuf.touch();
        return new NettyDataBuffer(byteBuf, this);
    }

    @Override
    public DataBuffer join(List<? extends DataBuffer> list) {
        Assert.notEmpty(list, "DataBuffer List must not be empty");
        int n = list.size();
        if (n == 1) {
            return list.get(0);
        }
        CompositeByteBuf compositeByteBuf = this.byteBufAllocator.compositeBuffer(n);
        for (DataBuffer dataBuffer : list) {
            Assert.isInstanceOf(NettyDataBuffer.class, dataBuffer);
            compositeByteBuf.addComponent(true, ((NettyDataBuffer)dataBuffer).getNativeBuffer());
        }
        return new NettyDataBuffer((ByteBuf)compositeByteBuf, this);
    }

    public static ByteBuf toByteBuf(DataBuffer dataBuffer) {
        if (dataBuffer instanceof NettyDataBuffer) {
            return ((NettyDataBuffer)dataBuffer).getNativeBuffer();
        }
        return Unpooled.wrappedBuffer((ByteBuffer)dataBuffer.asByteBuffer());
    }

    public String toString() {
        return "NettyDataBufferFactory (" + this.byteBufAllocator + ")";
    }
}

