/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public abstract class VfsUtils {
    private static final String VFS3_PKG = "org.jboss.vfs.";
    private static final String VFS_NAME = "VFS";
    private static final Method VFS_METHOD_GET_ROOT_URL;
    private static final Method VFS_METHOD_GET_ROOT_URI;
    private static final Method VIRTUAL_FILE_METHOD_EXISTS;
    private static final Method VIRTUAL_FILE_METHOD_GET_INPUT_STREAM;
    private static final Method VIRTUAL_FILE_METHOD_GET_SIZE;
    private static final Method VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED;
    private static final Method VIRTUAL_FILE_METHOD_TO_URL;
    private static final Method VIRTUAL_FILE_METHOD_TO_URI;
    private static final Method VIRTUAL_FILE_METHOD_GET_NAME;
    private static final Method VIRTUAL_FILE_METHOD_GET_PATH_NAME;
    private static final Method VIRTUAL_FILE_METHOD_GET_PHYSICAL_FILE;
    private static final Method VIRTUAL_FILE_METHOD_GET_CHILD;
    protected static final Class<?> VIRTUAL_FILE_VISITOR_INTERFACE;
    protected static final Method VIRTUAL_FILE_METHOD_VISIT;
    private static final Field VISITOR_ATTRIBUTES_FIELD_RECURSE;

    protected static Object invokeVfsMethod(Method method, @Nullable Object object, Object ... objectArray) throws IOException {
        try {
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            ReflectionUtils.handleInvocationTargetException(invocationTargetException);
        }
        catch (Exception exception) {
            ReflectionUtils.handleReflectionException(exception);
        }
        throw new IllegalStateException("Invalid code path reached");
    }

    static boolean exists(Object object) {
        try {
            return (Boolean)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_EXISTS, object, new Object[0]);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static boolean isReadable(Object object) {
        try {
            return (Long)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_SIZE, object, new Object[0]) > 0L;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static long getSize(Object object) throws IOException {
        return (Long)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_SIZE, object, new Object[0]);
    }

    static long getLastModified(Object object) throws IOException {
        return (Long)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED, object, new Object[0]);
    }

    static InputStream getInputStream(Object object) throws IOException {
        return (InputStream)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_INPUT_STREAM, object, new Object[0]);
    }

    static URL getURL(Object object) throws IOException {
        return (URL)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_TO_URL, object, new Object[0]);
    }

    static URI getURI(Object object) throws IOException {
        return (URI)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_TO_URI, object, new Object[0]);
    }

    static String getName(Object object) {
        try {
            return (String)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_NAME, object, new Object[0]);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Cannot get resource name", iOException);
        }
    }

    static Object getRelative(URL uRL) throws IOException {
        return VfsUtils.invokeVfsMethod(VFS_METHOD_GET_ROOT_URL, null, uRL);
    }

    static Object getChild(Object object, String string) throws IOException {
        return VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_CHILD, object, string);
    }

    static File getFile(Object object) throws IOException {
        return (File)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_PHYSICAL_FILE, object, new Object[0]);
    }

    static Object getRoot(URI uRI) throws IOException {
        return VfsUtils.invokeVfsMethod(VFS_METHOD_GET_ROOT_URI, null, uRI);
    }

    protected static Object getRoot(URL uRL) throws IOException {
        return VfsUtils.invokeVfsMethod(VFS_METHOD_GET_ROOT_URL, null, uRL);
    }

    @Nullable
    protected static Object doGetVisitorAttributes() {
        return ReflectionUtils.getField(VISITOR_ATTRIBUTES_FIELD_RECURSE, null);
    }

    @Nullable
    protected static String doGetPath(Object object) {
        return (String)ReflectionUtils.invokeMethod(VIRTUAL_FILE_METHOD_GET_PATH_NAME, object);
    }

    static {
        ClassLoader classLoader = VfsUtils.class.getClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass("org.jboss.vfs.VFS");
            VFS_METHOD_GET_ROOT_URL = clazz.getMethod("getChild", URL.class);
            VFS_METHOD_GET_ROOT_URI = clazz.getMethod("getChild", URI.class);
            Class<?> clazz2 = classLoader.loadClass("org.jboss.vfs.VirtualFile");
            VIRTUAL_FILE_METHOD_EXISTS = clazz2.getMethod("exists", new Class[0]);
            VIRTUAL_FILE_METHOD_GET_INPUT_STREAM = clazz2.getMethod("openStream", new Class[0]);
            VIRTUAL_FILE_METHOD_GET_SIZE = clazz2.getMethod("getSize", new Class[0]);
            VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED = clazz2.getMethod("getLastModified", new Class[0]);
            VIRTUAL_FILE_METHOD_TO_URI = clazz2.getMethod("toURI", new Class[0]);
            VIRTUAL_FILE_METHOD_TO_URL = clazz2.getMethod("toURL", new Class[0]);
            VIRTUAL_FILE_METHOD_GET_NAME = clazz2.getMethod("getName", new Class[0]);
            VIRTUAL_FILE_METHOD_GET_PATH_NAME = clazz2.getMethod("getPathName", new Class[0]);
            VIRTUAL_FILE_METHOD_GET_PHYSICAL_FILE = clazz2.getMethod("getPhysicalFile", new Class[0]);
            VIRTUAL_FILE_METHOD_GET_CHILD = clazz2.getMethod("getChild", String.class);
            VIRTUAL_FILE_VISITOR_INTERFACE = classLoader.loadClass("org.jboss.vfs.VirtualFileVisitor");
            VIRTUAL_FILE_METHOD_VISIT = clazz2.getMethod("visit", VIRTUAL_FILE_VISITOR_INTERFACE);
            Class<?> clazz3 = classLoader.loadClass("org.jboss.vfs.VisitorAttributes");
            VISITOR_ATTRIBUTES_FIELD_RECURSE = clazz3.getField("RECURSE");
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Could not detect JBoss VFS infrastructure", throwable);
        }
    }
}

