/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ClassRelativeResourceLoader
extends DefaultResourceLoader {
    private final Class<?> clazz;

    public ClassRelativeResourceLoader(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        this.clazz = clazz;
        this.setClassLoader(clazz.getClassLoader());
    }

    @Override
    protected Resource getResourceByPath(String string) {
        return new ClassRelativeContextResource(string, this.clazz);
    }

    private static class ClassRelativeContextResource
    extends ClassPathResource
    implements ContextResource {
        private final Class<?> clazz;

        public ClassRelativeContextResource(String string, Class<?> clazz) {
            super(string, clazz);
            this.clazz = clazz;
        }

        @Override
        public String getPathWithinContext() {
            return this.getPath();
        }

        @Override
        public Resource createRelative(String string) {
            String string2 = StringUtils.applyRelativePath(this.getPath(), string);
            return new ClassRelativeContextResource(string2, this.clazz);
        }
    }
}

