/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.lang.Nullable;

public class MutablePropertySources
implements PropertySources {
    private final List<PropertySource<?>> propertySourceList = new CopyOnWriteArrayList();

    public MutablePropertySources() {
    }

    public MutablePropertySources(PropertySources propertySources) {
        this();
        for (PropertySource propertySource : propertySources) {
            this.addLast(propertySource);
        }
    }

    @Override
    public Iterator<PropertySource<?>> iterator() {
        return this.propertySourceList.iterator();
    }

    @Override
    public Spliterator<PropertySource<?>> spliterator() {
        return Spliterators.spliterator(this.propertySourceList, 0);
    }

    @Override
    public Stream<PropertySource<?>> stream() {
        return this.propertySourceList.stream();
    }

    @Override
    public boolean contains(String string) {
        for (PropertySource<?> propertySource : this.propertySourceList) {
            if (!propertySource.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public PropertySource<?> get(String string) {
        for (PropertySource<?> propertySource : this.propertySourceList) {
            if (!propertySource.getName().equals(string)) continue;
            return propertySource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(PropertySource<?> propertySource) {
        List<PropertySource<?>> list = this.propertySourceList;
        synchronized (list) {
            this.removeIfPresent(propertySource);
            this.propertySourceList.add(0, propertySource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(PropertySource<?> propertySource) {
        List<PropertySource<?>> list = this.propertySourceList;
        synchronized (list) {
            this.removeIfPresent(propertySource);
            this.propertySourceList.add(propertySource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBefore(String string, PropertySource<?> propertySource) {
        this.assertLegalRelativeAddition(string, propertySource);
        List<PropertySource<?>> list = this.propertySourceList;
        synchronized (list) {
            this.removeIfPresent(propertySource);
            int n = this.assertPresentAndGetIndex(string);
            this.addAtIndex(n, propertySource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAfter(String string, PropertySource<?> propertySource) {
        this.assertLegalRelativeAddition(string, propertySource);
        List<PropertySource<?>> list = this.propertySourceList;
        synchronized (list) {
            this.removeIfPresent(propertySource);
            int n = this.assertPresentAndGetIndex(string);
            this.addAtIndex(n + 1, propertySource);
        }
    }

    public int precedenceOf(PropertySource<?> propertySource) {
        return this.propertySourceList.indexOf(propertySource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PropertySource<?> remove(String string) {
        List<PropertySource<?>> list = this.propertySourceList;
        synchronized (list) {
            int n = this.propertySourceList.indexOf(PropertySource.named(string));
            return n != -1 ? this.propertySourceList.remove(n) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String string, PropertySource<?> propertySource) {
        List<PropertySource<?>> list = this.propertySourceList;
        synchronized (list) {
            int n = this.assertPresentAndGetIndex(string);
            this.propertySourceList.set(n, propertySource);
        }
    }

    public int size() {
        return this.propertySourceList.size();
    }

    public String toString() {
        return this.propertySourceList.toString();
    }

    protected void assertLegalRelativeAddition(String string, PropertySource<?> propertySource) {
        String string2 = propertySource.getName();
        if (string.equals(string2)) {
            throw new IllegalArgumentException("PropertySource named '" + string2 + "' cannot be added relative to itself");
        }
    }

    protected void removeIfPresent(PropertySource<?> propertySource) {
        this.propertySourceList.remove(propertySource);
    }

    private void addAtIndex(int n, PropertySource<?> propertySource) {
        this.removeIfPresent(propertySource);
        this.propertySourceList.add(n, propertySource);
    }

    private int assertPresentAndGetIndex(String string) {
        int n = this.propertySourceList.indexOf(PropertySource.named(string));
        if (n == -1) {
            throw new IllegalArgumentException("PropertySource named '" + string + "' does not exist");
        }
        return n;
    }
}

