/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.SpringProperties;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.MissingRequiredPropertiesException;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.Profiles;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.env.ReadOnlySystemAttributesMap;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractEnvironment
implements ConfigurableEnvironment {
    public static final String IGNORE_GETENV_PROPERTY_NAME = "spring.getenv.ignore";
    public static final String ACTIVE_PROFILES_PROPERTY_NAME = "spring.profiles.active";
    public static final String DEFAULT_PROFILES_PROPERTY_NAME = "spring.profiles.default";
    protected static final String RESERVED_DEFAULT_PROFILE_NAME = "default";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Set<String> activeProfiles = new LinkedHashSet<String>();
    private final Set<String> defaultProfiles = new LinkedHashSet<String>(this.getReservedDefaultProfiles());
    private final MutablePropertySources propertySources = new MutablePropertySources();
    private final ConfigurablePropertyResolver propertyResolver = new PropertySourcesPropertyResolver(this.propertySources);

    public AbstractEnvironment() {
        this.customizePropertySources(this.propertySources);
    }

    protected void customizePropertySources(MutablePropertySources mutablePropertySources) {
    }

    protected Set<String> getReservedDefaultProfiles() {
        return Collections.singleton(RESERVED_DEFAULT_PROFILE_NAME);
    }

    @Override
    public String[] getActiveProfiles() {
        return StringUtils.toStringArray(this.doGetActiveProfiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> doGetActiveProfiles() {
        Set<String> set = this.activeProfiles;
        synchronized (set) {
            String string;
            if (this.activeProfiles.isEmpty() && StringUtils.hasText(string = this.getProperty(ACTIVE_PROFILES_PROPERTY_NAME))) {
                this.setActiveProfiles(StringUtils.commaDelimitedListToStringArray(StringUtils.trimAllWhitespace(string)));
            }
            return this.activeProfiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveProfiles(String ... stringArray) {
        Assert.notNull((Object)stringArray, "Profile array must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Activating profiles " + Arrays.asList(stringArray));
        }
        Set<String> set = this.activeProfiles;
        synchronized (set) {
            this.activeProfiles.clear();
            for (String string : stringArray) {
                this.validateProfile(string);
                this.activeProfiles.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActiveProfile(String string) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Activating profile '" + string + "'");
        }
        this.validateProfile(string);
        this.doGetActiveProfiles();
        Set<String> set = this.activeProfiles;
        synchronized (set) {
            this.activeProfiles.add(string);
        }
    }

    @Override
    public String[] getDefaultProfiles() {
        return StringUtils.toStringArray(this.doGetDefaultProfiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> doGetDefaultProfiles() {
        Set<String> set = this.defaultProfiles;
        synchronized (set) {
            String string;
            if (this.defaultProfiles.equals(this.getReservedDefaultProfiles()) && StringUtils.hasText(string = this.getProperty(DEFAULT_PROFILES_PROPERTY_NAME))) {
                this.setDefaultProfiles(StringUtils.commaDelimitedListToStringArray(StringUtils.trimAllWhitespace(string)));
            }
            return this.defaultProfiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultProfiles(String ... stringArray) {
        Assert.notNull((Object)stringArray, "Profile array must not be null");
        Set<String> set = this.defaultProfiles;
        synchronized (set) {
            this.defaultProfiles.clear();
            for (String string : stringArray) {
                this.validateProfile(string);
                this.defaultProfiles.add(string);
            }
        }
    }

    @Override
    @Deprecated
    public boolean acceptsProfiles(String ... stringArray) {
        Assert.notEmpty((Object[])stringArray, "Must specify at least one profile");
        for (String string : stringArray) {
            if (!(StringUtils.hasLength(string) && string.charAt(0) == '!' ? !this.isProfileActive(string.substring(1)) : this.isProfileActive(string))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsProfiles(Profiles profiles) {
        Assert.notNull((Object)profiles, "Profiles must not be null");
        return profiles.matches(this::isProfileActive);
    }

    protected boolean isProfileActive(String string) {
        this.validateProfile(string);
        Set<String> set = this.doGetActiveProfiles();
        return set.contains(string) || set.isEmpty() && this.doGetDefaultProfiles().contains(string);
    }

    protected void validateProfile(String string) {
        if (!StringUtils.hasText(string)) {
            throw new IllegalArgumentException("Invalid profile [" + string + "]: must contain text");
        }
        if (string.charAt(0) == '!') {
            throw new IllegalArgumentException("Invalid profile [" + string + "]: must not begin with ! operator");
        }
    }

    @Override
    public MutablePropertySources getPropertySources() {
        return this.propertySources;
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        try {
            return System.getProperties();
        }
        catch (AccessControlException accessControlException) {
            return new ReadOnlySystemAttributesMap(){

                @Override
                @Nullable
                protected String getSystemAttribute(String string) {
                    try {
                        return System.getProperty(string);
                    }
                    catch (AccessControlException accessControlException) {
                        if (AbstractEnvironment.this.logger.isInfoEnabled()) {
                            AbstractEnvironment.this.logger.info("Caught AccessControlException when accessing system property '" + string + "'; its value will be returned [null]. Reason: " + accessControlException.getMessage());
                        }
                        return null;
                    }
                }
            };
        }
    }

    @Override
    public Map<String, Object> getSystemEnvironment() {
        if (this.suppressGetenvAccess()) {
            return Collections.emptyMap();
        }
        try {
            return System.getenv();
        }
        catch (AccessControlException accessControlException) {
            return new ReadOnlySystemAttributesMap(){

                @Override
                @Nullable
                protected String getSystemAttribute(String string) {
                    try {
                        return System.getenv(string);
                    }
                    catch (AccessControlException accessControlException) {
                        if (AbstractEnvironment.this.logger.isInfoEnabled()) {
                            AbstractEnvironment.this.logger.info("Caught AccessControlException when accessing system environment variable '" + string + "'; its value will be returned [null]. Reason: " + accessControlException.getMessage());
                        }
                        return null;
                    }
                }
            };
        }
    }

    protected boolean suppressGetenvAccess() {
        return SpringProperties.getFlag(IGNORE_GETENV_PROPERTY_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(ConfigurableEnvironment configurableEnvironment) {
        Object[] objectArray2;
        for (Object[] objectArray2 : configurableEnvironment.getPropertySources()) {
            if (this.propertySources.contains(objectArray2.getName())) continue;
            this.propertySources.addLast((PropertySource<?>)objectArray2);
        }
        Object[] objectArray3 = configurableEnvironment.getActiveProfiles();
        if (!ObjectUtils.isEmpty(objectArray3)) {
            objectArray2 = this.activeProfiles;
            synchronized (objectArray2) {
                Collections.addAll(this.activeProfiles, objectArray3);
            }
        }
        if (!ObjectUtils.isEmpty(objectArray2 = configurableEnvironment.getDefaultProfiles())) {
            Set<String> set = this.defaultProfiles;
            synchronized (set) {
                this.defaultProfiles.remove(RESERVED_DEFAULT_PROFILE_NAME);
                Collections.addAll(this.defaultProfiles, objectArray2);
            }
        }
    }

    @Override
    public ConfigurableConversionService getConversionService() {
        return this.propertyResolver.getConversionService();
    }

    @Override
    public void setConversionService(ConfigurableConversionService configurableConversionService) {
        this.propertyResolver.setConversionService(configurableConversionService);
    }

    @Override
    public void setPlaceholderPrefix(String string) {
        this.propertyResolver.setPlaceholderPrefix(string);
    }

    @Override
    public void setPlaceholderSuffix(String string) {
        this.propertyResolver.setPlaceholderSuffix(string);
    }

    @Override
    public void setValueSeparator(@Nullable String string) {
        this.propertyResolver.setValueSeparator(string);
    }

    @Override
    public void setIgnoreUnresolvableNestedPlaceholders(boolean bl) {
        this.propertyResolver.setIgnoreUnresolvableNestedPlaceholders(bl);
    }

    @Override
    public void setRequiredProperties(String ... stringArray) {
        this.propertyResolver.setRequiredProperties(stringArray);
    }

    @Override
    public void validateRequiredProperties() throws MissingRequiredPropertiesException {
        this.propertyResolver.validateRequiredProperties();
    }

    @Override
    public boolean containsProperty(String string) {
        return this.propertyResolver.containsProperty(string);
    }

    @Override
    @Nullable
    public String getProperty(String string) {
        return this.propertyResolver.getProperty(string);
    }

    @Override
    public String getProperty(String string, String string2) {
        return this.propertyResolver.getProperty(string, string2);
    }

    @Override
    @Nullable
    public <T> T getProperty(String string, Class<T> clazz) {
        return this.propertyResolver.getProperty(string, clazz);
    }

    @Override
    public <T> T getProperty(String string, Class<T> clazz, T t2) {
        return this.propertyResolver.getProperty(string, clazz, t2);
    }

    @Override
    public String getRequiredProperty(String string) throws IllegalStateException {
        return this.propertyResolver.getRequiredProperty(string);
    }

    @Override
    public <T> T getRequiredProperty(String string, Class<T> clazz) throws IllegalStateException {
        return this.propertyResolver.getRequiredProperty(string, clazz);
    }

    @Override
    public String resolvePlaceholders(String string) {
        return this.propertyResolver.resolvePlaceholders(string);
    }

    @Override
    public String resolveRequiredPlaceholders(String string) throws IllegalArgumentException {
        return this.propertyResolver.resolveRequiredPlaceholders(string);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {activeProfiles=" + this.activeProfiles + ", defaultProfiles=" + this.defaultProfiles + ", propertySources=" + this.propertySources + "}";
    }
}

