/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

final class StringToCollectionConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public StringToCollectionConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Collection.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return typeDescriptor2.getElementTypeDescriptor() == null || this.conversionService.canConvert(typeDescriptor, typeDescriptor2.getElementTypeDescriptor());
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (object == null) {
            return null;
        }
        String string = (String)object;
        String[] stringArray = StringUtils.commaDelimitedListToStringArray(string);
        TypeDescriptor typeDescriptor3 = typeDescriptor2.getElementTypeDescriptor();
        Collection<Object> collection = CollectionFactory.createCollection(typeDescriptor2.getType(), typeDescriptor3 != null ? typeDescriptor3.getType() : null, stringArray.length);
        if (typeDescriptor3 == null) {
            for (String string2 : stringArray) {
                collection.add(string2.trim());
            }
        } else {
            for (String string3 : stringArray) {
                Object object2 = this.conversionService.convert(string3.trim(), typeDescriptor, typeDescriptor3);
                collection.add(object2);
            }
        }
        return collection;
    }
}

